/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.communication.WebComponentBootstrapHandler;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class WebComponentBootstrapHandlerViteTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File projectRootFolder;
    private DeploymentConfiguration deploymentConfiguration;

    @Before
    public void init() throws IOException {
        this.projectRootFolder = this.temporaryFolder.newFolder();
        TestUtil.createWebComponentHtmlStub(this.projectRootFolder);
        TestUtil.createStatsJsonStub(this.projectRootFolder);
        this.deploymentConfiguration = (DeploymentConfiguration)Mockito.mock((Object[])new DeploymentConfiguration[0]);
        Mockito.when((Object)this.deploymentConfiguration.isProductionMode()).thenReturn((Object)true);
    }

    @Test
    public void writeBootstrapPage_skipMetaAndStyleHeaderElements() throws IOException {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Element head = new Document("").head();
        Element meta = head.ownerDocument().createElement("meta");
        head.appendChild((Node)meta);
        meta.attr("http-equiv", "Content-Type");
        Element style = head.ownerDocument().createElement("style");
        head.appendChild((Node)style);
        style.attr("type", "text/css");
        style.text("body {height:100vh;width:100vw;margin:0;}");
        Element script = head.ownerDocument().createElement("script");
        head.appendChild((Node)script);
        script.text("var i=1;");
        VaadinResponse response = this.getMockResponse(stream);
        handler.writeBootstrapPage("", response, head, "");
        String resultingScript = stream.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)resultingScript, (Matcher)CoreMatchers.containsString((String)"var i=1;"));
        MatcherAssert.assertThat((Object)resultingScript, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"body {height:100vh;width:100vw;margin:0;}")));
        MatcherAssert.assertThat((Object)resultingScript, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"http-equiv")));
    }

    @Test
    public void writeBootstrapPage_scriptSrcHasNoDoubleQuotes_attributeIsTransferred() throws IOException {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Element head = new Document("").head();
        Element script = head.ownerDocument().createElement("script");
        head.appendChild((Node)script);
        script.attr("src", "foo'bar%20%27?baz%22");
        VaadinResponse response = this.getMockResponse(stream);
        handler.writeBootstrapPage("", response, head, "");
        String resultingScript = stream.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)resultingScript, (Matcher)CoreMatchers.containsString((String)"foo'bar%20%27?baz%22"));
    }

    @Test(expected=IllegalStateException.class)
    public void writeBootstrapPage_scriptSrcHasDoubleQuotes_throws() throws IOException {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Element head = new Document("").head();
        Element script = head.ownerDocument().createElement("script");
        head.appendChild((Node)script);
        script.attr("src", "foo\"");
        VaadinResponse response = this.getMockResponse(stream);
        handler.writeBootstrapPage("", response, head, "");
    }

    @Test
    public void writeBootstrapPage_noPWA() throws IOException, ServiceException {
        TestWebComponentBootstrapHandler handler = new TestWebComponentBootstrapHandler();
        final PwaRegistry registry = (PwaRegistry)Mockito.mock(PwaRegistry.class);
        PwaConfiguration conf = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)registry.getPwaConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)conf.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)conf.getManifestPath()).thenReturn((Object)"bar");
        PwaIcon icon = (PwaIcon)Mockito.mock(PwaIcon.class);
        Mockito.when((Object)icon.asElement()).thenReturn((Object)new Element("h1"));
        Mockito.when((Object)registry.getHeaderIcons()).thenReturn(Collections.singletonList(icon));
        MockVaadinServletService service = new MockVaadinServletService(){

            protected PwaRegistry getPwaRegistry() {
                return registry;
            }

            @Override
            protected void instrumentMockLookup(Lookup lookup) {
                WebComponentBootstrapHandlerViteTest.this.initLookup(lookup);
            }
        };
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockDeploymentConfiguration config = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        config.setProjectFolder(this.projectRootFolder);
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        VaadinResponse response = this.getMockResponse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        handler.synchronizedHandleRequest(session, (VaadinRequest)request, response);
        String result = stream.toString(StandardCharsets.UTF_8.name());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"bar")));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"h1")));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"baz")));
    }

    @Test
    public void writeBootstrapPage_devToolsDisabled() throws IOException, ServiceException {
        TestWebComponentBootstrapHandler handler = new TestWebComponentBootstrapHandler();
        MockVaadinServletService service = new MockVaadinServletService(){

            @Override
            protected void instrumentMockLookup(Lookup lookup) {
                WebComponentBootstrapHandlerViteTest.this.initLookup(lookup);
            }
        };
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockDeploymentConfiguration config = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        config.setProjectFolder(this.projectRootFolder);
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        VaadinResponse response = this.getMockResponse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        handler.synchronizedHandleRequest(session, (VaadinRequest)request, response);
        String result = stream.toString(StandardCharsets.UTF_8.name());
        int scriptIndex = result.indexOf("var hasScript = function(src)");
        Assert.assertTrue((scriptIndex >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.contains("\\\"devToolsEnabled\\\" : false"));
    }

    @Test
    public void writeBootstrapPage_spepe() throws Exception {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Element head = new Document("").head();
        VaadinResponse response = this.getMockResponse(stream);
        handler.writeBootstrapPage("", response, head, "");
        String resultingScript = stream.toString(StandardCharsets.UTF_8.name());
    }

    @Test
    public void canHandleRequest_hasNoWebComponentConfigPathIsWebComponentUI_returnsFalse() {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        VaadinRequest request = this.mockRequest(false);
        Assert.assertFalse((boolean)handler.canHandleRequest(request));
    }

    @Test
    public void canHandleRequest_hasWebComponentConfigPathIsWebComponentUI_returnsTrue() {
        WebComponentBootstrapHandler handler = new WebComponentBootstrapHandler();
        VaadinRequest request = this.mockRequest(true);
        Assert.assertTrue((boolean)handler.canHandleRequest(request));
    }

    @Ignore
    @Test
    public void writeBootstrapPage_withExportChunk() throws IOException, ServiceException {
        TestWebComponentBootstrapHandler handler = new TestWebComponentBootstrapHandler();
        MockVaadinServletService service = new MockVaadinServletService(){

            @Override
            protected void instrumentMockLookup(Lookup lookup) {
                WebComponentBootstrapHandlerViteTest.this.initLookup(lookup);
            }
        };
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockDeploymentConfiguration config = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        config.setProjectFolder(this.projectRootFolder);
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/");
        VaadinResponse response = this.getMockResponse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        handler.synchronizedHandleRequest(session, (VaadinRequest)request, response);
        String result = stream.toString(StandardCharsets.UTF_8.name());
        Assert.assertTrue((boolean)result.contains("VAADIN/build/vaadin-export-2222.cache.js"));
        Assert.assertFalse((boolean)result.contains("VAADIN/build/vaadin-bundle-1111.cache.js"));
    }

    @Ignore
    @Test
    public void writeBootstrapPage_noExportChunk() throws IOException, ServiceException {
        TestWebComponentBootstrapHandler handler = new TestWebComponentBootstrapHandler();
        MockVaadinServletService service = new MockVaadinServletService(){

            @Override
            protected void instrumentMockLookup(Lookup lookup) {
                WebComponentBootstrapHandlerViteTest.this.initLookup(lookup);
            }
        };
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockDeploymentConfiguration config = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        config.setApplicationOrSystemProperty("statistics.file.path", "META-INF/VAADIN/config/stats_no_export.json");
        config.setProjectFolder(this.projectRootFolder);
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/");
        VaadinResponse response = this.getMockResponse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        handler.synchronizedHandleRequest(session, (VaadinRequest)request, response);
        String result = stream.toString(StandardCharsets.UTF_8.name());
        Assert.assertTrue((boolean)result.contains("VAADIN/build/vaadin-bundle-1111.cache.js"));
    }

    @Test
    public void usageStatistics() throws IOException {
        TestWebComponentBootstrapHandler handler = new TestWebComponentBootstrapHandler();
        MockVaadinServletService service = new MockVaadinServletService();
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockDeploymentConfiguration config = (MockDeploymentConfiguration)service.getDeploymentConfiguration();
        config.setProjectFolder(this.projectRootFolder);
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        VaadinResponse response = this.getMockResponse(null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        UsageStatistics.removeEntry((String)"exported-wc");
        handler.synchronizedHandleRequest(session, (VaadinRequest)request, response);
        Assert.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(entry -> entry.getName().equals("exported-wc")));
    }

    private VaadinRequest mockRequest(boolean hasConfig) {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        WebComponentConfigurationRegistry registry = (WebComponentConfigurationRegistry)Mockito.mock(WebComponentConfigurationRegistry.class);
        Mockito.when((Object)((WebComponentConfigurationRegistry)context.getAttribute((Class)Mockito.eq(WebComponentConfigurationRegistry.class), (Supplier)Mockito.any()))).thenReturn((Object)registry);
        Mockito.when((Object)registry.hasConfigurations()).thenReturn((Object)hasConfig);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/web-component/web-component-ui.js");
        return request;
    }

    private void initLookup(Lookup lookup) {
        Mockito.reset((Object[])new Lookup[]{lookup});
        ResourceProvider provider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)((ResourceProvider)lookup.lookup(ResourceProvider.class))).thenReturn((Object)provider);
        Mockito.when((Object)provider.getApplicationResource(Mockito.anyString())).thenAnswer(answer -> WebComponentBootstrapHandlerViteTest.class.getClassLoader().getResource((String)answer.getArgument(0)));
        try {
            Mockito.when((Object)provider.getClientResourceAsStream("META-INF/resources/VAADIN/static/client/compile.properties")).thenAnswer(invocation -> new ByteArrayInputStream("jsFile=foo".getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private VaadinResponse getMockResponse(ByteArrayOutputStream stream) throws IOException {
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)stream);
        Mockito.when((Object)response.getService()).thenReturn((Object)service);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        Mockito.when((Object)((WebComponentConfigurationRegistry)context.getAttribute((Class)ArgumentMatchers.eq(WebComponentConfigurationRegistry.class), (Supplier)ArgumentMatchers.any()))).thenReturn((Object)((WebComponentConfigurationRegistry)Mockito.mock(WebComponentConfigurationRegistry.class)));
        return response;
    }

    private static class TestWebComponentBootstrapHandler
    extends WebComponentBootstrapHandler {
        private TestWebComponentBootstrapHandler() {
        }

        protected boolean canHandleRequest(VaadinRequest request) {
            return true;
        }

        protected String getServiceUrl(VaadinRequest request, VaadinResponse response) {
            return "/";
        }
    }
}

