/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.JacksonSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;

public class JacksonSerializerTest {
    private static final double PRECISION = 1.0E-6;

    @Test
    public void serializeBasicTypes_returnJsonBasicTypes() {
        JsonNode json = JacksonSerializer.toJson((Object)"someString");
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonString", (boolean)(json instanceof StringNode));
        Assert.assertEquals((Object)"someString", (Object)json.asString());
        json = JacksonSerializer.toJson((Object)0);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNumber", (boolean)(json instanceof NumericNode));
        Assert.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0.0);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNumber", (boolean)(json instanceof NumericNode));
        Assert.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0L);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNumber", (boolean)(json instanceof NumericNode));
        Assert.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNumber", (boolean)(json instanceof NumericNode));
        Assert.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)0);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNumber", (boolean)(json instanceof NumericNode));
        Assert.assertEquals((double)0.0, (double)json.doubleValue(), (double)1.0E-6);
        json = JacksonSerializer.toJson((Object)true);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonBoolean", (boolean)(json instanceof BooleanNode));
        Assert.assertTrue((boolean)json.asBoolean());
        json = JacksonSerializer.toJson((Object)false);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonBoolean", (boolean)(json instanceof BooleanNode));
        Assert.assertFalse((boolean)json.asBoolean());
        json = JacksonSerializer.toJson((Object)((Object)SomeEnum.SOME_VALUE_1));
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonString", (boolean)(json instanceof StringNode));
        Assert.assertEquals((Object)SomeEnum.SOME_VALUE_1.name(), (Object)json.asString());
    }

    @Test
    public void serializeNull_returnNull() {
        JsonNode json = JacksonSerializer.toJson(null);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonNull", (boolean)(json instanceof NullNode));
    }

    @Test
    public void serializeEmptyObjectWithBasicTypes_returnJsonObjectWithEmptyProperties() {
        ObjectWithSimpleTypes bean = new ObjectWithSimpleTypes();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        ObjectNode object = (ObjectNode)json;
        this.assertObjectHasNullValueForKey(object, "stringProperty");
        this.assertObjectHas0ValueForKey(object, "intProperty");
        this.assertObjectHasNullValueForKey(object, "integerProperty");
        this.assertObjectHas0ValueForKey(object, "longProperty");
        this.assertObjectHasNullValueForKey(object, "longObjectProperty");
        this.assertObjectHas0ValueForKey(object, "shortProperty");
        this.assertObjectHasNullValueForKey(object, "shortObjectProperty");
        this.assertObjectHas0ValueForKey(object, "doubleProperty");
        this.assertObjectHasNullValueForKey(object, "doubleObjectProperty");
        this.assertObjectHas0ValueForKey(object, "byteProperty");
        this.assertObjectHasNullValueForKey(object, "byteObjectProperty");
        this.assertObjectHasFalseValueForKey(object, "booleanProperty");
        this.assertObjectHasNullValueForKey(object, "booleanObjectProperty");
        this.assertObjectHasNullValueForKey(object, "characterProperty");
        this.assertObjectHasNullValueForKey(object, "enumProperty");
        Assert.assertTrue((boolean)object.has("charProperty"));
        Assert.assertEquals((long)0L, (long)object.get("charProperty").asString().charAt(0));
        bean = (ObjectWithSimpleTypes)JacksonSerializer.toObject(ObjectWithSimpleTypes.class, (JsonNode)json);
        Assert.assertNotNull((Object)bean);
        Assert.assertNull((Object)bean.getStringProperty());
        Assert.assertEquals((long)0L, (long)bean.getIntProperty());
        Assert.assertNull((Object)bean.getIntegerProperty());
        Assert.assertEquals((long)0L, (long)bean.getLongProperty());
        Assert.assertNull((Object)bean.getLongObjectProperty());
        Assert.assertEquals((long)0L, (long)bean.getShortProperty());
        Assert.assertNull((Object)bean.getShortObjectProperty());
        Assert.assertEquals((double)0.0, (double)bean.getDoubleProperty(), (double)1.0E-5);
        Assert.assertNull((Object)bean.getDoubleObjectProperty());
        Assert.assertEquals((long)0L, (long)bean.getByteProperty());
        Assert.assertNull((Object)bean.getByteObjectProperty());
        Assert.assertEquals((Object)false, (Object)bean.isBooleanProperty());
        Assert.assertNull((Object)bean.getBooleanObjectProperty());
        Assert.assertEquals((long)0L, (long)bean.getCharProperty());
        Assert.assertNull((Object)bean.getCharacterProperty());
        Assert.assertNull((Object)((Object)bean.getEnumProperty()));
    }

    @Test
    public void serializePopulatedObjectWithBasicTypes_returnJsonObjectWithDefinedProperties() {
        ObjectWithSimpleTypes bean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode object = json;
        Assert.assertEquals((Object)"someProperty", (Object)object.get("stringProperty").asString());
        Assert.assertEquals((double)1.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)2.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)7.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)8.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)9.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assert.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assert.assertEquals((long)99L, (long)object.get("charProperty").asString().charAt(0));
        Assert.assertEquals((long)67L, (long)object.get("characterProperty").asString().charAt(0));
        Assert.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)object.get("enumProperty").asString());
        bean = (ObjectWithSimpleTypes)JacksonSerializer.toObject(ObjectWithSimpleTypes.class, (JsonNode)json);
        Assert.assertNotNull((Object)bean);
        Assert.assertEquals((Object)"someProperty", (Object)bean.getStringProperty());
        Assert.assertEquals((long)1L, (long)bean.getIntProperty());
        Assert.assertEquals((Object)2, (Object)bean.getIntegerProperty());
        Assert.assertEquals((long)3L, (long)bean.getLongProperty());
        Assert.assertEquals((Object)4L, (Object)bean.getLongObjectProperty());
        Assert.assertEquals((long)5L, (long)bean.getShortProperty());
        Assert.assertEquals((Object)6, (Object)bean.getShortObjectProperty());
        Assert.assertEquals((double)7.0, (double)bean.getDoubleProperty(), (double)1.0E-5);
        Assert.assertEquals((Object)8.0, (Object)bean.getDoubleObjectProperty());
        Assert.assertEquals((long)9L, (long)bean.getByteProperty());
        Assert.assertEquals((Object)10, (Object)bean.getByteObjectProperty());
        Assert.assertEquals((Object)true, (Object)bean.isBooleanProperty());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)bean.getBooleanObjectProperty());
        Assert.assertEquals((long)99L, (long)bean.getCharProperty());
        Assert.assertEquals((Object)Character.valueOf('C'), (Object)bean.getCharacterProperty());
        Assert.assertEquals((Object)((Object)SomeEnum.SOME_VALUE_2), (Object)((Object)bean.getEnumProperty()));
    }

    @Test
    public void serializeEmptyObjectWithObjects_returnJsonObjectWithNullProperties() {
        ObjectWithOtherObjects bean = new ObjectWithOtherObjects();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode jsonObject = json;
        Assert.assertTrue((boolean)jsonObject.has("object1"));
        Assert.assertTrue((boolean)(jsonObject.get("object1") instanceof NullNode));
        Assert.assertTrue((boolean)jsonObject.has("object2"));
        Assert.assertTrue((boolean)(jsonObject.get("object2") instanceof NullNode));
        Assert.assertTrue((boolean)jsonObject.has("record"));
        Assert.assertTrue((boolean)(jsonObject.get("record") instanceof NullNode));
        bean = (ObjectWithOtherObjects)JacksonSerializer.toObject(ObjectWithOtherObjects.class, (JsonNode)json);
        Assert.assertNotNull((String)"The deserialized object should not be null", (Object)bean);
        Assert.assertNull((Object)bean.getObject1());
        Assert.assertNull((Object)bean.getObject2());
        Assert.assertNull((Object)bean.getRecord());
    }

    @Test
    public void serializeObjectWithObjects_returnJsonObjectWithPopulatedProperties() {
        ObjectWithOtherObjects bean = new ObjectWithOtherObjects();
        ObjectWithSimpleTypes innerBean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        bean.setObject1(innerBean);
        innerBean = new ObjectWithSimpleTypes();
        innerBean.setStringProperty("someOtherProperty");
        innerBean.setIntProperty(10);
        innerBean.setIntegerProperty(20);
        innerBean.setLongProperty(30L);
        innerBean.setLongObjectProperty(40L);
        innerBean.setShortProperty((short)50);
        innerBean.setShortObjectProperty((short)60);
        innerBean.setDoubleProperty(70.0);
        innerBean.setDoubleObjectProperty(80.0);
        innerBean.setByteProperty((byte)90);
        innerBean.setByteObjectProperty((byte)100);
        innerBean.setBooleanProperty(true);
        innerBean.setBooleanObjectProperty(false);
        innerBean.setCharProperty('d');
        innerBean.setCharacterProperty(Character.valueOf('D'));
        innerBean.setEnumProperty(SomeEnum.SOME_VALUE_1);
        bean.setObject2(innerBean);
        SomeRecord record = new SomeRecord("someone", 42);
        bean.setRecord(record);
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode object = json.get("object1");
        Assert.assertNotNull((String)"The object1 should be not be null", (Object)object);
        Assert.assertEquals((Object)"someProperty", (Object)object.get("stringProperty").asString());
        Assert.assertEquals((double)1.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)2.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)7.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)8.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)9.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assert.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assert.assertEquals((long)99L, (long)object.get("charProperty").asString().charAt(0));
        Assert.assertEquals((long)67L, (long)object.get("characterProperty").asString().charAt(0));
        Assert.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)object.get("enumProperty").asString());
        object = json.get("object2");
        Assert.assertNotNull((String)"The object2 should be not be null", (Object)object);
        Assert.assertEquals((Object)"someOtherProperty", (Object)object.get("stringProperty").asString());
        Assert.assertEquals((double)10.0, (double)object.get("intProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)20.0, (double)object.get("integerProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)30.0, (double)object.get("longProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)40.0, (double)object.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)50.0, (double)object.get("shortProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)60.0, (double)object.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)70.0, (double)object.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)80.0, (double)object.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)90.0, (double)object.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((double)100.0, (double)object.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((Object)true, (Object)object.get("booleanProperty").booleanValue());
        Assert.assertEquals((Object)false, (Object)object.get("booleanObjectProperty").booleanValue());
        Assert.assertEquals((long)100L, (long)object.get("charProperty").asString().charAt(0));
        Assert.assertEquals((long)68L, (long)object.get("characterProperty").asString().charAt(0));
        Assert.assertEquals((Object)SomeEnum.SOME_VALUE_1.name(), (Object)object.get("enumProperty").asString());
        object = json.get("record");
        Assert.assertNotNull((String)"The record should be not be null", (Object)object);
        Assert.assertEquals((Object)"someone", (Object)object.get("name").asString());
        Assert.assertEquals((double)42.0, (double)object.get("age").intValue(), (double)1.0E-6);
    }

    @Test
    public void serializeEmptyRecursiveObject_returnJsonObjectWithNullProperties() {
        RecursiveObject bean = new RecursiveObject();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode jsonObject = json;
        Assert.assertTrue((boolean)jsonObject.has("recursive"));
        Assert.assertTrue((boolean)(jsonObject.get("recursive") instanceof NullNode));
        Assert.assertEquals((double)0.0, (double)jsonObject.get("index").intValue(), (double)1.0E-6);
        bean = (RecursiveObject)JacksonSerializer.toObject(RecursiveObject.class, (JsonNode)json);
        Assert.assertNotNull((String)"The deserialized object should not be null", (Object)bean);
        Assert.assertNull((Object)bean.getRecursive());
        Assert.assertEquals((long)0L, (long)bean.getIndex());
    }

    @Test
    public void serializePopulatedRecursiveObject_returnJsonObjectWithPopulatedProperties() {
        int i;
        int recursions = 10;
        RecursiveObject bean = this.createRecusiveObject(10, 0);
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode object = json;
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)i, (double)object.get("index").intValue(), (double)1.0E-6);
            if (i < 9) {
                object = object.get("recursive");
                continue;
            }
            Assert.assertTrue((boolean)(object.get("recursive") instanceof NullNode));
        }
        bean = (RecursiveObject)JacksonSerializer.toObject(RecursiveObject.class, (JsonNode)json);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)bean.getIndex());
            bean = bean.getRecursive();
        }
    }

    @Test
    public void serializeEmptyObjectWithBasicCollections_returnJsonObjectWithNullProperties() {
        ObjectWithBasicCollections bean = new ObjectWithBasicCollections();
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode jsonObject = json;
        Assert.assertTrue((boolean)jsonObject.has("listOfStrings"));
        Assert.assertTrue((boolean)(jsonObject.get("listOfStrings") instanceof NullNode));
        Assert.assertTrue((boolean)jsonObject.has("setOfIntegers"));
        Assert.assertTrue((boolean)(jsonObject.get("setOfIntegers") instanceof NullNode));
        Assert.assertTrue((boolean)jsonObject.has("linkedListOfBooleans"));
        Assert.assertTrue((boolean)(jsonObject.get("linkedListOfBooleans") instanceof NullNode));
        Assert.assertTrue((boolean)jsonObject.has("arrayListOfDoubles"));
        Assert.assertTrue((boolean)(jsonObject.get("arrayListOfDoubles") instanceof NullNode));
        bean = (ObjectWithBasicCollections)JacksonSerializer.toObject(ObjectWithBasicCollections.class, (JsonNode)json);
        Assert.assertNotNull((String)"The deserialized object should not be null", (Object)bean);
        Assert.assertNull(bean.getListOfStrings());
        Assert.assertNull(bean.getSetOfIntegers());
        Assert.assertNull(bean.getLinkedListOfBooleans());
        Assert.assertNull(bean.getArrayListOfDoubles());
    }

    @Test
    public void serializeObjectWithCollections_returnJsonObjectWithPopulatedProperties() {
        ObjectWithBasicCollections bean = new ObjectWithBasicCollections();
        bean.setListOfStrings(Arrays.asList("string1", "string2"));
        bean.setSetOfIntegers(new LinkedHashSet<Integer>(Arrays.asList(3, 4)));
        bean.setLinkedListOfBooleans(new LinkedList<Boolean>(Arrays.asList(true, false)));
        bean.setArrayListOfDoubles(new ArrayList<Double>(Arrays.asList(5.0, 6.0)));
        JsonNode json = JacksonSerializer.toJson((Object)bean);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode jsonObject = json;
        ArrayNode array = (ArrayNode)jsonObject.get("listOfStrings");
        Assert.assertEquals((Object)"string1", (Object)array.get(0).asString());
        Assert.assertEquals((Object)"string2", (Object)array.get(1).asString());
        array = (ArrayNode)jsonObject.get("setOfIntegers");
        Assert.assertEquals((double)3.0, (double)array.get(0).intValue(), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)array.get(1).intValue(), (double)1.0E-6);
        array = (ArrayNode)jsonObject.get("linkedListOfBooleans");
        Assert.assertEquals((Object)true, (Object)array.get(0).booleanValue());
        Assert.assertEquals((Object)false, (Object)array.get(1).booleanValue());
        array = (ArrayNode)jsonObject.get("arrayListOfDoubles");
        Assert.assertEquals((double)5.0, (double)array.get(0).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)array.get(1).doubleValue(), (double)1.0E-6);
        bean = (ObjectWithBasicCollections)JacksonSerializer.toObject(ObjectWithBasicCollections.class, (JsonNode)json);
        Assert.assertNotNull((String)"The deserialized object should not be null", (Object)bean);
        this.assertCollectionItemsAreEqual(bean.getListOfStrings(), "string1", "string2");
        this.assertCollectionItemsAreEqual(bean.getSetOfIntegers(), 3, 4);
        this.assertCollectionItemsAreEqual(bean.getLinkedListOfBooleans(), true, false);
        this.assertCollectionItemsAreEqual(bean.getArrayListOfDoubles(), 5.0, 6.0);
    }

    @Test
    public void serializeRecordWithRecordAndObject_returnJsonObjectWithPopulatedProperties() {
        SomeRecord record = new SomeRecord("someone", 42);
        ObjectWithSimpleTypes bean = JacksonSerializerTest.getPopulatedObjectWithSimpleTypes();
        RecordWithRecordAndObject mainRecord = new RecordWithRecordAndObject(record, bean);
        JsonNode json = JacksonSerializer.toJson((Object)mainRecord);
        Assert.assertTrue((String)"The JsonNode should be instanceof JsonObject", (boolean)(json instanceof ObjectNode));
        JsonNode object = json;
        JsonNode nestedRecord = object.get("record");
        JsonNode nestedObject = object.get("object");
        Assert.assertNotNull((Object)nestedRecord);
        Assert.assertNotNull((Object)nestedObject);
        Assert.assertEquals((Object)"someone", (Object)nestedRecord.get("name").asString());
        Assert.assertEquals((double)42.0, (double)nestedRecord.get("age").intValue(), (double)1.0E-6);
        Assert.assertEquals((Object)"someProperty", (Object)nestedObject.get("stringProperty").asString());
        Assert.assertEquals((double)1.0, (double)nestedObject.get("intProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)2.0, (double)nestedObject.get("integerProperty").intValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.0, (double)nestedObject.get("longProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)4.0, (double)nestedObject.get("longObjectProperty").longValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)nestedObject.get("shortProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)6.0, (double)nestedObject.get("shortObjectProperty").shortValue(), (double)1.0E-6);
        Assert.assertEquals((double)7.0, (double)nestedObject.get("doubleProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)8.0, (double)nestedObject.get("doubleObjectProperty").doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)9.0, (double)nestedObject.get("byteProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)nestedObject.get("byteObjectProperty").numberValue().byteValue(), (double)1.0E-6);
        Assert.assertTrue((boolean)nestedObject.get("booleanProperty").asBoolean());
        Assert.assertFalse((boolean)nestedObject.get("booleanObjectProperty").asBoolean());
        Assert.assertEquals((long)99L, (long)nestedObject.get("charProperty").asString().charAt(0));
        Assert.assertEquals((long)67L, (long)nestedObject.get("characterProperty").asString().charAt(0));
        Assert.assertEquals((Object)SomeEnum.SOME_VALUE_2.name(), (Object)nestedObject.get("enumProperty").asString());
        mainRecord = (RecordWithRecordAndObject)JacksonSerializer.toObject(RecordWithRecordAndObject.class, (JsonNode)json);
        Assert.assertNotNull((Object)mainRecord);
        SomeRecord deserializedRecord = mainRecord.record;
        Assert.assertEquals((Object)"someone", (Object)deserializedRecord.name);
        Assert.assertEquals((long)42L, (long)deserializedRecord.age);
        ObjectWithSimpleTypes deserializedObject = mainRecord.object;
        Assert.assertEquals((Object)"someProperty", (Object)deserializedObject.getStringProperty());
        Assert.assertEquals((long)1L, (long)deserializedObject.getIntProperty());
        Assert.assertEquals((Object)2, (Object)deserializedObject.getIntegerProperty());
        Assert.assertEquals((long)3L, (long)deserializedObject.getLongProperty());
        Assert.assertEquals((Object)4L, (Object)deserializedObject.getLongObjectProperty());
        Assert.assertEquals((long)5L, (long)deserializedObject.getShortProperty());
        Assert.assertEquals((Object)6, (Object)deserializedObject.getShortObjectProperty());
        Assert.assertEquals((double)7.0, (double)deserializedObject.getDoubleProperty(), (double)1.0E-5);
        Assert.assertEquals((Object)8.0, (Object)deserializedObject.getDoubleObjectProperty());
        Assert.assertEquals((long)9L, (long)deserializedObject.getByteProperty());
        Assert.assertEquals((Object)10, (Object)deserializedObject.getByteObjectProperty());
        Assert.assertEquals((Object)true, (Object)deserializedObject.isBooleanProperty());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)deserializedObject.getBooleanObjectProperty());
        Assert.assertEquals((long)99L, (long)deserializedObject.getCharProperty());
        Assert.assertEquals((Object)Character.valueOf('C'), (Object)deserializedObject.getCharacterProperty());
        Assert.assertEquals((Object)((Object)SomeEnum.SOME_VALUE_2), (Object)((Object)deserializedObject.getEnumProperty()));
    }

    private static ObjectWithSimpleTypes getPopulatedObjectWithSimpleTypes() {
        ObjectWithSimpleTypes bean = new ObjectWithSimpleTypes();
        bean.setStringProperty("someProperty");
        bean.setIntProperty(1);
        bean.setIntegerProperty(2);
        bean.setLongProperty(3L);
        bean.setLongObjectProperty(4L);
        bean.setShortProperty((short)5);
        bean.setShortObjectProperty((short)6);
        bean.setDoubleProperty(7.0);
        bean.setDoubleObjectProperty(8.0);
        bean.setByteProperty((byte)9);
        bean.setByteObjectProperty((byte)10);
        bean.setBooleanProperty(true);
        bean.setBooleanObjectProperty(false);
        bean.setCharProperty('c');
        bean.setCharacterProperty(Character.valueOf('C'));
        bean.setEnumProperty(SomeEnum.SOME_VALUE_2);
        return bean;
    }

    private <T> void assertCollectionItemsAreEqual(Collection<T> collection, T ... values) {
        int index = 0;
        for (T collectionValue : collection) {
            Assert.assertEquals(collectionValue, values[index]);
            ++index;
        }
    }

    private RecursiveObject createRecusiveObject(int recursions, int index) {
        if (index < recursions) {
            RecursiveObject bean = new RecursiveObject();
            bean.setIndex(index);
            bean.setRecursive(this.createRecusiveObject(recursions, index + 1));
            return bean;
        }
        return null;
    }

    private void assertObjectHasNullValueForKey(ObjectNode object, String key) {
        Assert.assertTrue((String)(key + " should be present in the JsonObject"), (boolean)object.has(key));
        Assert.assertTrue((String)(key + " property should be JsonNull"), (boolean)(object.get(key) instanceof NullNode));
    }

    private void assertObjectHas0ValueForKey(ObjectNode object, String key) {
        Assert.assertTrue((String)(key + " should be present in the JsonObject"), (boolean)object.has(key));
        Assert.assertEquals((String)(key + " should be 0.0 in the JsonObject"), (double)0.0, (double)object.get(key).doubleValue(), (double)1.0E-6);
    }

    private void assertObjectHasFalseValueForKey(ObjectNode object, String key) {
        Assert.assertTrue((String)(key + " should be present in the JsonObject"), (boolean)object.has(key));
        Assert.assertEquals((String)(key + " should be false in the JsonObject"), (Object)false, (Object)object.get(key).booleanValue());
    }

    public static enum SomeEnum {
        SOME_VALUE_1,
        SOME_VALUE_2;

    }

    public static class ObjectWithSimpleTypes {
        private String stringProperty;
        private int intProperty;
        private Integer integerProperty;
        private long longProperty;
        private Long longObjectProperty;
        private short shortProperty;
        private Short shortObjectProperty;
        private double doubleProperty;
        private Double doubleObjectProperty;
        private byte byteProperty;
        private Byte byteObjectProperty;
        private boolean booleanProperty;
        private Boolean booleanObjectProperty;
        private char charProperty;
        private Character characterProperty;
        private SomeEnum enumProperty;

        public String getStringProperty() {
            return this.stringProperty;
        }

        public void setStringProperty(String stringProperty) {
            this.stringProperty = stringProperty;
        }

        public int getIntProperty() {
            return this.intProperty;
        }

        public void setIntProperty(int intProperty) {
            this.intProperty = intProperty;
        }

        public Integer getIntegerProperty() {
            return this.integerProperty;
        }

        public void setIntegerProperty(Integer integerProperty) {
            this.integerProperty = integerProperty;
        }

        public long getLongProperty() {
            return this.longProperty;
        }

        public void setLongProperty(long longProperty) {
            this.longProperty = longProperty;
        }

        public Long getLongObjectProperty() {
            return this.longObjectProperty;
        }

        public void setLongObjectProperty(Long longObjectProperty) {
            this.longObjectProperty = longObjectProperty;
        }

        public short getShortProperty() {
            return this.shortProperty;
        }

        public void setShortProperty(short shortProperty) {
            this.shortProperty = shortProperty;
        }

        public Short getShortObjectProperty() {
            return this.shortObjectProperty;
        }

        public void setShortObjectProperty(Short shortObjectProperty) {
            this.shortObjectProperty = shortObjectProperty;
        }

        public Double getDoubleObjectProperty() {
            return this.doubleObjectProperty;
        }

        public void setDoubleObjectProperty(Double doubleObjectProperty) {
            this.doubleObjectProperty = doubleObjectProperty;
        }

        public double getDoubleProperty() {
            return this.doubleProperty;
        }

        public void setDoubleProperty(double doubleProperty) {
            this.doubleProperty = doubleProperty;
        }

        public byte getByteProperty() {
            return this.byteProperty;
        }

        public void setByteProperty(byte byteProperty) {
            this.byteProperty = byteProperty;
        }

        public Byte getByteObjectProperty() {
            return this.byteObjectProperty;
        }

        public void setByteObjectProperty(Byte byteObjectProperty) {
            this.byteObjectProperty = byteObjectProperty;
        }

        public boolean isBooleanProperty() {
            return this.booleanProperty;
        }

        public void setBooleanProperty(boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }

        public Boolean getBooleanObjectProperty() {
            return this.booleanObjectProperty;
        }

        public void setBooleanObjectProperty(Boolean booleanObjectProperty) {
            this.booleanObjectProperty = booleanObjectProperty;
        }

        public char getCharProperty() {
            return this.charProperty;
        }

        public void setCharProperty(char charProperty) {
            this.charProperty = charProperty;
        }

        public Character getCharacterProperty() {
            return this.characterProperty;
        }

        public void setCharacterProperty(Character characterProperty) {
            this.characterProperty = characterProperty;
        }

        public SomeEnum getEnumProperty() {
            return this.enumProperty;
        }

        public void setEnumProperty(SomeEnum enumProperty) {
            this.enumProperty = enumProperty;
        }
    }

    public static class ObjectWithOtherObjects {
        private ObjectWithSimpleTypes object1;
        private ObjectWithSimpleTypes object2;
        private SomeRecord record;

        public ObjectWithSimpleTypes getObject1() {
            return this.object1;
        }

        public void setObject1(ObjectWithSimpleTypes object1) {
            this.object1 = object1;
        }

        public ObjectWithSimpleTypes getObject2() {
            return this.object2;
        }

        public void setObject2(ObjectWithSimpleTypes object2) {
            this.object2 = object2;
        }

        public SomeRecord getRecord() {
            return this.record;
        }

        public void setRecord(SomeRecord record) {
            this.record = record;
        }
    }

    public record SomeRecord(String name, int age) {
    }

    public static class RecursiveObject {
        private RecursiveObject recursive;
        private int index;

        public RecursiveObject getRecursive() {
            return this.recursive;
        }

        public void setRecursive(RecursiveObject recursive) {
            this.recursive = recursive;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static class ObjectWithBasicCollections {
        private List<String> listOfStrings;
        private Set<Integer> setOfIntegers;
        private LinkedList<Boolean> linkedListOfBooleans;
        private List<Double> arrayListOfDoubles;

        public List<String> getListOfStrings() {
            return this.listOfStrings;
        }

        public void setListOfStrings(List<String> listOfStrings) {
            this.listOfStrings = listOfStrings;
        }

        public Set<Integer> getSetOfIntegers() {
            return this.setOfIntegers;
        }

        public void setSetOfIntegers(Set<Integer> setOfIntegers) {
            this.setOfIntegers = setOfIntegers;
        }

        public LinkedList<Boolean> getLinkedListOfBooleans() {
            return this.linkedListOfBooleans;
        }

        public void setLinkedListOfBooleans(LinkedList<Boolean> linkedListOfBooleans) {
            this.linkedListOfBooleans = linkedListOfBooleans;
        }

        public List<Double> getArrayListOfDoubles() {
            return this.arrayListOfDoubles;
        }

        public void setArrayListOfDoubles(List<Double> arrayListOfDoubles) {
            this.arrayListOfDoubles = arrayListOfDoubles;
        }
    }

    public record RecordWithRecordAndObject(SomeRecord record, ObjectWithSimpleTypes object) {
    }
}

