/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.DevBundleUtils;
import com.vaadin.flow.internal.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DevBundleUtilsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void compileDevBundle_uncompileDevBundle_filesHasSameHash() throws IOException {
        File projectBase = this.temporaryFolder.getRoot();
        File devFolder = new File(projectBase, "target/dev-bundle");
        devFolder.mkdirs();
        File configFolder = new File(devFolder, "config");
        configFolder.mkdir();
        File stats = new File(configFolder, "stats.json");
        File packages = new File(devFolder, "package.json");
        Files.write(stats.toPath(), Collections.singleton("{ \"stats\": 1 }"), new OpenOption[0]);
        Files.write(packages.toPath(), Collections.singleton("{ \"packages\": [] }"), new OpenOption[0]);
        String statsHash = StringUtil.getHash((String)Files.readString(stats.toPath()));
        String packagesHash = StringUtil.getHash((String)Files.readString(packages.toPath()));
        DevBundleUtils.compressBundle((File)projectBase, (File)devFolder);
        Assert.assertTrue((String)"Compressed bundle should have been created", (boolean)new File(projectBase, "src/main/bundles/dev.bundle").exists());
        FileUtils.deleteDirectory((File)devFolder);
        Assert.assertFalse((String)"Dev folder not deleted!", (boolean)devFolder.exists());
        DevBundleUtils.unpackBundle((File)projectBase, (File)devFolder);
        Assert.assertTrue((String)"Dev folder not created!", (boolean)devFolder.exists());
        Assert.assertTrue((String)"Config folder not created!", (boolean)configFolder.exists());
        Assert.assertTrue((String)"stats file not created!", (boolean)stats.exists());
        Assert.assertTrue((String)"packages file not created!", (boolean)packages.exists());
        Assert.assertEquals((Object)statsHash, (Object)StringUtil.getHash((String)Files.readString(stats.toPath())));
        Assert.assertEquals((Object)packagesHash, (Object)StringUtil.getHash((String)Files.readString(packages.toPath())));
    }
}

