/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.tests.util.MockUI;
import java.util.LinkedList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public abstract class SignalsUnitTest {
    private static MockVaadinServletService service;
    private MockedStatic<FeatureFlags> featureFlagStaticMock;
    protected LinkedList<ErrorEvent> events;

    @BeforeClass
    public static void init() {
        MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        SignalsUnitTest.featureFlagEnabled((MockedStatic<FeatureFlags>)featureFlagStaticMock);
        service = new MockVaadinServletService();
        SignalsUnitTest.close((MockedStatic<FeatureFlags>)featureFlagStaticMock);
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Before
    public void before() {
        this.featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        SignalsUnitTest.featureFlagEnabled(this.featureFlagStaticMock);
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @After
    public void after() {
        SignalsUnitTest.close(this.featureFlagStaticMock);
        this.events = null;
    }

    private static void featureFlagEnabled(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
        featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
    }

    private static void close(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        CurrentInstance.clearAll();
        featureFlagStaticMock.close();
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }
}

