/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ErrorStateRendererTest {
    @Test(expected=ErrorStateRenderer.ExceptionsTrace.class)
    public void handle_openNPEErrorTarget_infiniteReroute_noStackOverflow_throws() {
        UI ui = this.configureMocks();
        NavigationState state = new NavigationStateBuilder(ui.getInternals().getRouter()).withTarget(InfiniteLoopErrorTarget.class).build();
        ErrorStateRenderer renderer = new ErrorStateRenderer(state);
        RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry()).setAnnotatedRoute(InfiniteLoopNPEView.class);
        ErrorParameter parameter = new ErrorParameter(Exception.class, (Exception)new NullPointerException());
        ErrorNavigationEvent event = new ErrorNavigationEvent(ui.getInternals().getRouter(), new Location("error"), ui, NavigationTrigger.CLIENT_SIDE, parameter);
        renderer.handle((NavigationEvent)event);
    }

    @Test(expected=ErrorStateRenderer.ExceptionsTrace.class)
    public void handle_openNPEView_infiniteReroute_noStackOverflow_throws() {
        UI ui = this.configureMocks();
        NavigationState state = new NavigationStateBuilder(ui.getInternals().getRouter()).withTarget(InfiniteLoopNPEView.class).build();
        NavigationStateRenderer renderer = new NavigationStateRenderer(state);
        RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry()).setAnnotatedRoute(InfiniteLoopNPEView.class);
        ((ApplicationRouteRegistry)ui.getInternals().getRouter().getRegistry()).setErrorNavigationTargets(Collections.singleton(InfiniteLoopErrorTarget.class));
        NavigationEvent event = new NavigationEvent(ui.getInternals().getRouter(), new Location("npe"), ui, NavigationTrigger.CLIENT_SIDE);
        renderer.handle(event);
        ObjectNode routerLinkState = new ObjectMapper().createObjectNode();
        routerLinkState.put("href", "router_link");
        routerLinkState.put("scrollPositionX", 0.0);
        routerLinkState.put("scrollPositionY", 0.0);
        event = new NavigationEvent(ui.getInternals().getRouter(), new Location("npe"), ui, NavigationTrigger.ROUTER_LINK, (BaseJsonNode)routerLinkState, false);
        renderer.handle(event);
    }

    @Test
    public void handle_errorViewLayoutForwardsToAView_viewIsNavigated() {
        UI ui = this.configureMocks();
        NavigationState state = new NavigationStateBuilder(ui.getInternals().getRouter()).withTarget(HappyPathErrorTarget.class).build();
        ErrorStateRenderer renderer = new ErrorStateRenderer(state);
        RouteConfiguration.forRegistry((RouteRegistry)ui.getInternals().getRouter().getRegistry()).setAnnotatedRoute(HappyPathViewView.class);
        ErrorParameter parameter = new ErrorParameter(Exception.class, (Exception)new NullPointerException());
        ErrorNavigationEvent event = new ErrorNavigationEvent(ui.getInternals().getRouter(), new Location("error"), ui, NavigationTrigger.CLIENT_SIDE, parameter);
        Assert.assertEquals((long)200L, (long)renderer.handle((NavigationEvent)event));
        List chain = ui.getInternals().getActiveRouterTargetsChain();
        Assert.assertEquals((long)1L, (long)chain.size());
        Assert.assertEquals(HappyPathViewView.class, (Object)((HasElement)chain.get(0)).getClass());
    }

    private UI configureMocks() {
        MockVaadinServletService service = new MockVaadinServletService(){

            public VaadinContext getContext() {
                return new MockVaadinContext();
            }
        };
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)service);
        return new MockUI(session);
    }

    @Tag(value="a")
    @ParentLayout(value=InfiniteLoopErrorLayout.class)
    public static class InfiniteLoopErrorTarget
    extends Component
    implements HasErrorParameter<Exception> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<Exception> parameter) {
            return 500;
        }
    }

    @Tag(value="a")
    @Route(value="npe")
    public static class InfiniteLoopNPEView
    extends Component
    implements BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.rerouteToError(NullPointerException.class);
        }
    }

    @Tag(value="a")
    @ParentLayout(value=HappyPathErrorLayout.class)
    public static class HappyPathErrorTarget
    extends Component
    implements HasErrorParameter<Exception> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<Exception> parameter) {
            return 500;
        }
    }

    @Tag(value="a")
    @Route(value="happy")
    public static class HappyPathViewView
    extends Component {
    }

    @Tag(value="a")
    public static class HappyPathErrorLayout
    extends Component
    implements RouterLayout,
    BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.forwardTo(HappyPathViewView.class);
        }
    }

    @Tag(value="a")
    public static class InfiniteLoopErrorLayout
    extends Component
    implements RouterLayout,
    BeforeEnterObserver {
        public void beforeEnter(BeforeEnterEvent event) {
            event.forwardTo(InfiniteLoopNPEView.class);
        }
    }
}

