/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.webcomponent.PropertyConfigurationImpl;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.ObjectNode;

public class WebComponentBindingTest {
    private MyComponent component;
    private WebComponentBinding binding;

    @Before
    public void setUp() {
        this.component = new MyComponent();
        this.binding = new WebComponentBinding((Component)this.component);
        PropertyConfigurationImpl integerProperty = new PropertyConfigurationImpl(MyComponent.class, "int", Integer.class, (Serializable)Integer.valueOf(0));
        integerProperty.onChange(MyComponent::setInt);
        PropertyConfigurationImpl jsonProperty = new PropertyConfigurationImpl(MyComponent.class, "json", ObjectNode.class, null);
        jsonProperty.onChange(MyComponent::setJson);
        this.binding.bindProperty(integerProperty, false);
        this.binding.bindProperty(jsonProperty, false);
    }

    @Test
    public void getComponent() {
        Assert.assertEquals((Object)((Object)this.component), (Object)this.binding.getComponent());
    }

    @Test
    public void getPropertyType() {
        Assert.assertEquals(Integer.class, (Object)this.binding.getPropertyType("int"));
        Assert.assertEquals(ObjectNode.class, (Object)this.binding.getPropertyType("json"));
        Assert.assertNull((Object)this.binding.getPropertyType("not-a-property"));
    }

    @Test
    public void hasProperty() {
        Assert.assertTrue((boolean)this.binding.hasProperty("int"));
        Assert.assertTrue((boolean)this.binding.hasProperty("json"));
        Assert.assertFalse((boolean)this.binding.hasProperty("not-a-property"));
    }

    @Test
    public void updateValue() {
        this.binding.updateProperty("int", (Serializable)Integer.valueOf(5));
        Assert.assertEquals((long)5L, (long)this.component.integer);
        ObjectNode obj = JacksonUtils.createObjectNode();
        obj.put("String", "Value");
        this.binding.updateProperty("json", (BaseJsonNode)obj);
        Assert.assertEquals((Object)"{\"String\":\"Value\"}", (Object)this.component.jsonValue.toString());
    }

    @Test
    public void updateValueJackson() {
        this.binding.updateProperty("int", (Serializable)Integer.valueOf(5));
        Assert.assertEquals((long)5L, (long)this.component.integer);
        ObjectNode obj = JacksonUtils.createObjectNode();
        obj.put("String", "Value");
        this.binding.updateProperty("json", (BaseJsonNode)obj);
        Assert.assertEquals((Object)"{\"String\":\"Value\"}", (Object)this.component.jsonValue.toString());
    }

    @Tag(value="tag")
    private static class MyComponent
    extends Component {
        int integer;
        JsonNode jsonValue;

        private MyComponent() {
        }

        public void setInt(int v) {
            this.integer = v;
        }

        public void setJson(JsonNode v) {
            this.jsonValue = v;
        }
    }
}

