/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.tests.util.TestUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionCacheTest {
    @Test
    public void generateCachedValues() {
        AtomicInteger count = new AtomicInteger();
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> count.incrementAndGet());
        Assert.assertEquals((long)0L, (long)count.get());
        Assert.assertEquals((long)1L, (long)((Integer)cache.get(Object.class)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)cache.get(String.class)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)cache.get(Object.class)).intValue());
        Assert.assertEquals((long)2L, (long)count.get());
    }

    @Test
    public void cacheContains() {
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        Assert.assertFalse((boolean)cache.contains(Object.class));
        cache.get(Object.class);
        Assert.assertTrue((boolean)cache.contains(Object.class));
        Assert.assertFalse((boolean)cache.contains(String.class));
    }

    @Test
    public void cacheClear() {
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        cache.get(Object.class);
        Assert.assertTrue((boolean)cache.contains(Object.class));
        cache.clear();
        Assert.assertFalse((boolean)cache.contains(Object.class));
    }

    @Test
    public void cacheClearEntry() {
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        cache.get(Integer.class);
        cache.get(Double.class);
        cache.get(Long.class);
        Assert.assertTrue((boolean)cache.contains(Integer.class));
        Assert.assertTrue((boolean)cache.contains(Double.class));
        Assert.assertTrue((boolean)cache.contains(Long.class));
        cache.clear(Double.class);
        Assert.assertTrue((boolean)cache.contains(Integer.class));
        Assert.assertFalse((boolean)cache.contains(Double.class));
        Assert.assertTrue((boolean)cache.contains(Long.class));
        cache.clear(Integer.class);
        Assert.assertFalse((boolean)cache.contains(Integer.class));
        Assert.assertFalse((boolean)cache.contains(Double.class));
        Assert.assertTrue((boolean)cache.contains(Long.class));
        cache.clear(Long.class);
        Assert.assertFalse((boolean)cache.contains(Integer.class));
        Assert.assertFalse((boolean)cache.contains(Double.class));
        Assert.assertFalse((boolean)cache.contains(Long.class));
    }

    @Test
    public void clearAll() {
        ReflectionCache cache1 = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        ReflectionCache cache2 = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        cache1.get(Object.class);
        cache2.get(Object.class);
        ReflectionCache.clearAll();
        Assert.assertFalse((boolean)cache1.contains(Object.class));
        Assert.assertFalse((boolean)cache2.contains(Object.class));
    }

    @Test
    public void clearAllForGivenType() {
        ReflectionCache cache1 = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        ReflectionCache cache2 = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        cache1.get(Integer.class);
        cache1.get(Double.class);
        cache2.get(Float.class);
        cache2.get(Double.class);
        ReflectionCache.clearAll(Integer.class);
        Assert.assertFalse((boolean)cache1.contains(Integer.class));
        Assert.assertTrue((boolean)cache1.contains(Double.class));
        Assert.assertTrue((boolean)cache2.contains(Float.class));
        Assert.assertTrue((boolean)cache2.contains(Double.class));
        ReflectionCache.clearAll(Double.class);
        Assert.assertFalse((boolean)cache1.contains(Double.class));
        Assert.assertTrue((boolean)cache2.contains(Float.class));
        Assert.assertFalse((boolean)cache2.contains(Double.class));
    }

    @Test
    public void cacheIsGarbageCollected() throws InterruptedException {
        ReflectionCache cache1 = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        WeakReference<ReflectionCache> ref = new WeakReference<ReflectionCache>(cache1);
        cache1 = null;
        Assert.assertTrue((boolean)TestUtil.isGarbageCollected(ref));
    }

    @Test
    public void cacheIsClearedAfterGc() throws InterruptedException {
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> type);
        cache.get(Object.class);
        TestUtil.isGarbageCollected(new WeakReference<Object>(new Object()));
        ReflectionCache.clearAll();
        Assert.assertFalse((boolean)cache.contains(Object.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void currentInstancesNotAvailable() {
        String currentString = "My string";
        CurrentInstance.set(String.class, (Object)currentString);
        ReflectionCache cache = new ReflectionCache((SerializableFunction & Serializable)type -> type.getSimpleName() + ": " + (String)CurrentInstance.get(String.class));
        try {
            String result = (String)cache.get(Object.class);
            Assert.assertEquals((String)"Current instance should not be in the result", (Object)"Object: null", (Object)result);
            Assert.assertEquals((String)"Current instance should be preserved after running", (Object)currentString, (Object)CurrentInstance.get(String.class));
        }
        finally {
            CurrentInstance.set(String.class, null);
        }
    }
}

