/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.tests.util.MockUI;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class StylesheetRemovalTest {
    private UI ui;
    private Page page;
    private UIInternals internals;
    private DependencyList dependencyList;

    @Before
    public void setup() {
        this.ui = new MockUI();
        this.page = this.ui.getPage();
        this.internals = this.ui.getInternals();
        this.dependencyList = this.internals.getDependencyList();
    }

    @Test
    public void addStyleSheet_returnsNonNullRegistration() {
        Registration reg1 = this.page.addStyleSheet("styles.css");
        Registration reg2 = this.page.addStyleSheet("styles.css", LoadMode.LAZY);
        Assert.assertNotNull((String)"addStyleSheet should return a Registration", (Object)reg1);
        Assert.assertNotNull((String)"addStyleSheet with LoadMode should return a Registration", (Object)reg2);
    }

    @Test
    public void addStyleSheet_returnsRegistration_thatRemovesStylesheet() {
        String url = "http://example.com/style.css";
        Registration registration = this.page.addStyleSheet(url);
        Assert.assertNotNull((String)"Registration should not be null", (Object)registration);
        Collection dependencies = this.dependencyList.getPendingSendToClient();
        Assert.assertEquals((String)"Should have one dependency", (long)1L, (long)dependencies.size());
        Dependency dep = (Dependency)dependencies.iterator().next();
        Assert.assertEquals((String)"URL should match", (Object)url, (Object)dep.getUrl());
        Assert.assertNotNull((String)"Dependency should have ID", (Object)dep.getId());
        registration.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assert.assertEquals((String)"Should have one removal pending", (long)1L, (long)removals.size());
        Assert.assertEquals((String)"Removal ID should match dependency ID", (Object)dep.getId(), removals.iterator().next());
    }

    @Test
    public void stylesheetCanBeReAddedAfterRemoval() {
        String url = "http://example.com/reusable.css";
        Registration reg1 = this.page.addStyleSheet(url);
        Collection deps1 = this.dependencyList.getPendingSendToClient();
        Assert.assertEquals((long)1L, (long)deps1.size());
        Dependency firstDep = (Dependency)deps1.iterator().next();
        String firstId = firstDep.getId();
        this.dependencyList.clearPendingSendToClient();
        reg1.remove();
        Assert.assertTrue((boolean)this.internals.getPendingStyleSheetRemovals().contains(firstId));
        this.internals.clearPendingStyleSheetRemovals();
        Registration reg2 = this.page.addStyleSheet(url);
        Collection deps2 = this.dependencyList.getPendingSendToClient();
        Assert.assertEquals((long)1L, (long)deps2.size());
        Dependency secondDep = (Dependency)deps2.iterator().next();
        Assert.assertNotEquals((String)"IDs should differ", (Object)firstId, (Object)secondDep.getId());
        Assert.assertEquals((String)"URLs should match", (Object)url, (Object)secondDep.getUrl());
    }

    @Test
    public void stylesheetWithLoadMode_canBeReAddedWithDifferentMode() {
        String url = "http://example.com/lazy.css";
        Registration reg1 = this.page.addStyleSheet(url, LoadMode.LAZY);
        Dependency firstDep = (Dependency)this.dependencyList.getPendingSendToClient().iterator().next();
        String firstId = firstDep.getId();
        Assert.assertEquals((Object)LoadMode.LAZY, (Object)firstDep.getLoadMode());
        this.dependencyList.clearPendingSendToClient();
        reg1.remove();
        this.internals.clearPendingStyleSheetRemovals();
        Registration reg2 = this.page.addStyleSheet(url, LoadMode.EAGER);
        Dependency secondDep = (Dependency)this.dependencyList.getPendingSendToClient().iterator().next();
        Assert.assertNotEquals((String)"IDs should differ", (Object)firstId, (Object)secondDep.getId());
        Assert.assertEquals((String)"URLs should match", (Object)url, (Object)secondDep.getUrl());
        Assert.assertEquals((Object)LoadMode.EAGER, (Object)secondDep.getLoadMode());
    }

    @Test
    public void multipleStylesheets_removeOne_othersRemainIntact() {
        String url1 = "http://example.com/style1.css";
        String url2 = "http://example.com/style2.css";
        String url3 = "http://example.com/style3.css";
        Registration reg1 = this.page.addStyleSheet(url1);
        Registration reg2 = this.page.addStyleSheet(url2);
        Registration reg3 = this.page.addStyleSheet(url3);
        Collection allDeps = this.dependencyList.getPendingSendToClient();
        Assert.assertEquals((String)"Should have three dependencies", (long)3L, (long)allDeps.size());
        String idToRemove = null;
        for (Dependency dep : allDeps) {
            if (!url2.equals(dep.getUrl())) continue;
            idToRemove = dep.getId();
            break;
        }
        Assert.assertNotNull((String)"Should find dependency for url2", idToRemove);
        this.dependencyList.clearPendingSendToClient();
        reg2.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assert.assertEquals((String)"Should have one removal", (long)1L, (long)removals.size());
        Assert.assertEquals((String)"Should remove the correct stylesheet", (Object)idToRemove, removals.iterator().next());
    }

    @Test
    public void uidlWriter_includesStylesheetRemovals() {
        String url = "http://example.com/to-remove.css";
        Registration reg = this.page.addStyleSheet(url);
        Collection deps = this.dependencyList.getPendingSendToClient();
        String depId = ((Dependency)deps.iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        reg.remove();
        UidlWriter writer = new UidlWriter();
        ObjectNode response = writer.createUidl(this.ui, false);
        Assert.assertTrue((String)"Response should contain stylesheetRemovals", (boolean)response.has("stylesheetRemovals"));
        ArrayNode removalsArray = (ArrayNode)response.get("stylesheetRemovals");
        Assert.assertEquals((String)"Should have one removal", (long)1L, (long)removalsArray.size());
        Assert.assertEquals((String)"Removal ID should match", (Object)depId, (Object)removalsArray.get(0).asString());
        Set pendingRemovals = this.internals.getPendingStyleSheetRemovals();
        Assert.assertTrue((String)"Pending removals should be cleared after UIDL creation", (boolean)pendingRemovals.isEmpty());
    }

    @Test
    public void duplicateStylesheet_notAddedUntilRemovedFromCache() {
        String url = "http://example.com/cached-style.css";
        Registration reg = this.page.addStyleSheet(url);
        Assert.assertEquals((long)1L, (long)this.dependencyList.getPendingSendToClient().size());
        this.dependencyList.clearPendingSendToClient();
        this.page.addStyleSheet(url);
        Assert.assertEquals((long)0L, (long)this.dependencyList.getPendingSendToClient().size());
        reg.remove();
        this.page.addStyleSheet(url);
        Assert.assertEquals((long)1L, (long)this.dependencyList.getPendingSendToClient().size());
    }

    @Test
    public void duplicateStylesheet_firstRegistrationCanRemove() {
        String url = "http://example.com/duplicate.css";
        Registration reg1 = this.page.addStyleSheet(url);
        String firstDepId = ((Dependency)this.dependencyList.getPendingSendToClient().iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        Registration reg2 = this.page.addStyleSheet(url);
        Assert.assertEquals((String)"Second add should not create pending send", (long)0L, (long)this.dependencyList.getPendingSendToClient().size());
        reg1.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assert.assertEquals((String)"Should have one removal pending", (long)1L, (long)removals.size());
        Assert.assertEquals((String)"Should use the same dependency ID", (Object)firstDepId, removals.iterator().next());
    }

    @Test
    public void duplicateStylesheet_secondRegistrationCanRemove() {
        String url = "http://example.com/duplicate2.css";
        Registration reg1 = this.page.addStyleSheet(url);
        String firstDepId = ((Dependency)this.dependencyList.getPendingSendToClient().iterator().next()).getId();
        this.dependencyList.clearPendingSendToClient();
        Registration reg2 = this.page.addStyleSheet(url);
        Assert.assertEquals((String)"Second add should not create pending send", (long)0L, (long)this.dependencyList.getPendingSendToClient().size());
        reg2.remove();
        Set removals = this.internals.getPendingStyleSheetRemovals();
        Assert.assertEquals((String)"Should have one removal pending", (long)1L, (long)removals.size());
        String removedId = (String)removals.iterator().next();
        Assert.assertEquals((String)"Should use the same ID as the original", (Object)firstDepId, (Object)removedId);
    }
}

