/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.Tag;
import org.junit.Assert;
import org.junit.Test;

public class HasPlaceholderTest {
    @Test
    public void withoutPlaceholderComponent_getPlaceholderReturnsNull() {
        TestComponent component = new TestComponent();
        Assert.assertNull((Object)component.getPlaceholder());
    }

    @Test
    public void withNullPlaceholder_getPlaceholderReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setPlaceholder(null);
        Assert.assertEquals((Object)"", (Object)component.getPlaceholder());
    }

    @Test
    public void withEmptyPlaceholder_getPlaceholderReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setPlaceholder("");
        Assert.assertEquals((Object)"", (Object)component.getPlaceholder());
    }

    @Test
    public void setPlaceholder() {
        TestComponent component = new TestComponent();
        component.setPlaceholder("test Placeholder");
        Assert.assertEquals((Object)"test Placeholder", (Object)component.getPlaceholder());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasPlaceholder {
        private TestComponent() {
        }
    }
}

