/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.signals.Signal;
import java.io.Serializable;
import java.util.stream.Stream;

public abstract class AbstractPropertyMap
extends NodeMap {
    public AbstractPropertyMap(StateNode node) {
        super(node);
    }

    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (name != null);
        assert (AbstractPropertyMap.isValidValueType(value));
        if (this.hasSignal(name)) {
            NodeMap.SignalBinding b = (NodeMap.SignalBinding)super.get(name);
            this.put(name, new NodeMap.SignalBinding(b.signal(), b.registration(), value), emitChange);
        } else {
            this.put(name, value, emitChange);
        }
    }

    public boolean hasProperty(String name) {
        return this.contains(name);
    }

    public void removeProperty(String name) {
        super.remove(name);
    }

    public void removeAllProperties() {
        super.clear();
    }

    public Serializable getProperty(String name) {
        return this.get(name);
    }

    public Stream<String> getPropertyNames() {
        return this.keySet().stream();
    }

    public static boolean isValidValueType(Serializable value) {
        if (value == null) {
            return true;
        }
        Class<?> type = ReflectTools.convertPrimitiveType(value.getClass());
        return JacksonCodec.canEncodeWithoutTypeInfo(type) || StateNode.class.isAssignableFrom(type);
    }

    @Override
    public void updateFromClient(String key, Serializable value) {
        if (this.hasSignal(key)) {
            NodeMap.SignalBinding b = (NodeMap.SignalBinding)super.get(key);
            super.updateFromClient(key, new NodeMap.SignalBinding(b.signal(), b.registration(), value));
        } else {
            super.updateFromClient(key, value);
        }
    }

    public void bindSignal(Element owner, String name, Signal<?> signal) {
        this.bindSignal(owner, name, signal, (element, value) -> this.setPropertyFromSignal(name, value));
    }

    protected abstract void setPropertyFromSignal(String var1, Object var2);
}

