/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.TestNodeVisitor;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.IOException;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class JavaScriptBootstrapHandlerTest {
    private MockServletServiceSessionSetup mocks;
    private MockServletServiceSessionSetup.TestVaadinServletResponse response;
    private VaadinSession session;
    private JavaScriptBootstrapHandler jsInitHandler;

    @Before
    public void setup() throws Exception {
        this.mocks = new MockServletServiceSessionSetup();
        this.response = this.mocks.createResponse();
        this.session = this.mocks.getSession();
        this.jsInitHandler = new JavaScriptBootstrapHandler();
    }

    @After
    public void tearDown() {
        this.mocks.cleanup();
    }

    @Test
    public void should_handleRequest_when_initTypeRequest() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo");
        Assert.assertTrue((boolean)this.jsInitHandler.canHandleRequest(request));
    }

    @Test
    public void should_not_handleRequest_when_pathInfo_set() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/foo", "v-r=init&foo");
        Assert.assertFalse((boolean)this.jsInitHandler.canHandleRequest(request));
    }

    @Test
    public void should_not_handleRequest_if_not_initTypeRequest() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=bar");
        Assert.assertFalse((boolean)this.jsInitHandler.canHandleRequest(request));
    }

    @Test
    public void should_produceValidJsonResponse() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        Assert.assertEquals((long)200L, (long)this.response.getErrorCode());
        Assert.assertEquals((Object)"application/json", (Object)this.response.getContentType());
        ObjectNode json = JacksonUtils.readTree((String)this.response.getPayload());
        Assert.assertTrue((boolean)json.has("stats"));
        Assert.assertTrue((boolean)json.has("errors"));
        Assert.assertTrue((boolean)json.has("appConfig"));
        Assert.assertTrue((boolean)json.get("appConfig").has("appId"));
        Assert.assertTrue((boolean)json.get("appConfig").get("uidl").has("changes"));
        Assert.assertTrue((boolean)json.get("appConfig").get("debug").booleanValue());
        Assert.assertFalse((boolean)json.get("appConfig").has("webComponentMode"));
        Assert.assertEquals((Object)"./", (Object)json.get("appConfig").get("contextRootUrl").asString());
        Assert.assertNull((String)"ServiceUrl should not be set. It will be computed by flow-client", (Object)json.get("appConfig").get("serviceUrl"));
        Assert.assertEquals((Object)"http://localhost:8888/", (Object)json.get("appConfig").get("requestURL").asString());
        Assert.assertFalse((boolean)json.has("pushScript"));
    }

    @Test
    public void should_initialize_UI() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location=");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        Assert.assertNotNull((Object)UI.getCurrent());
        Assert.assertEquals(UI.class, UI.getCurrent().getClass());
    }

    @Test
    public void should_attachViewTo_UiContainer() throws Exception {
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location=");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        UI ui = UI.getCurrent();
        ui.browserNavigate(new UI.BrowserNavigateEvent(ui, true, "a-route", "", "", null, ""));
        TestNodeVisitor visitor = new TestNodeVisitor(true);
        BasicElementStateProvider.get().visit(ui.getElement().getNode(), (NodeVisitor)visitor);
        Assert.assertTrue((boolean)this.hasNodeTag(visitor, "^<body>.*", NodeVisitor.ElementType.REGULAR));
        Assert.assertTrue((boolean)this.hasNodeTag(visitor, "^<flow-container-.*>.*", NodeVisitor.ElementType.VIRTUAL_ATTACHED));
        Assert.assertTrue((boolean)this.hasNodeTag(visitor, "^<div>.*", NodeVisitor.ElementType.REGULAR));
        Assert.assertTrue((boolean)this.hasNodeTag(visitor, "^<div>.*No views found.*", NodeVisitor.ElementType.REGULAR));
    }

    @Test
    public void should_respondPushScript_when_enabledInDeploymentConfiguration() throws Exception {
        this.mocks.getDeploymentConfiguration().setPushMode(PushMode.AUTOMATIC);
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location=");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        Assert.assertEquals((long)200L, (long)this.response.getErrorCode());
        Assert.assertEquals((Object)"application/json", (Object)this.response.getContentType());
        ObjectNode json = JacksonUtils.readTree((String)this.response.getPayload());
        Assert.assertTrue((boolean)json.get("pushScript").asString().matches("^VAADIN/static/push/vaadinPush\\.js\\?v=[\\w\\.\\-]+$"));
    }

    @Test
    public void should_respondPushScript_when_nonRootServletPath() throws Exception {
        this.mocks.getDeploymentConfiguration().setPushMode(PushMode.AUTOMATIC);
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "/vaadin/", "v-r=init&foo&location=");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        Assert.assertEquals((long)200L, (long)this.response.getErrorCode());
        Assert.assertEquals((Object)"application/json", (Object)this.response.getContentType());
        ObjectNode json = JacksonUtils.readTree((String)this.response.getPayload());
        Assert.assertTrue((boolean)json.get("pushScript").asString().matches("^VAADIN/static/push/vaadinPush\\.js\\?v=[\\w\\.\\-]+$"));
    }

    @Test
    public void should_invoke_modifyPushConfiguration() throws Exception {
        AppShellRegistry registry = (AppShellRegistry)Mockito.mock(AppShellRegistry.class);
        this.mocks.setAppShellRegistry(registry);
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location=");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        ((AppShellRegistry)Mockito.verify((Object)registry)).modifyPushConfiguration((PushConfiguration)Mockito.any(PushConfiguration.class));
    }

    @Test
    public void should_respondPushScript_when_annotatedInAppShell() throws Exception {
        VaadinServletContext context = new VaadinServletContext(this.mocks.getServletContext());
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)context);
        registry.setShell(PushAppShell.class);
        this.mocks.setAppShellRegistry(registry);
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&foo&location");
        this.jsInitHandler.handleRequest(this.session, request, (VaadinResponse)this.response);
        Assert.assertEquals((long)200L, (long)this.response.getErrorCode());
        Assert.assertEquals((Object)"application/json", (Object)this.response.getContentType());
        ObjectNode json = JacksonUtils.readTree((String)this.response.getPayload());
        Assert.assertTrue((boolean)json.get("pushScript").asString().matches("^VAADIN/static/push/vaadinPush\\.js\\?v=[\\w\\.\\-]+$"));
    }

    @Test
    public void synchronizedHandleRequest_badLocation_noUiCreated() throws IOException {
        JavaScriptBootstrapHandler bootstrapHandler = new JavaScriptBootstrapHandler();
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=init&location=..**");
        MockServletServiceSessionSetup.TestVaadinServletResponse response = this.mocks.createResponse();
        boolean value = bootstrapHandler.synchronizedHandleRequest(this.mocks.getSession(), request, (VaadinResponse)response);
        Assert.assertTrue((String)"No further request handlers should be called", (boolean)value);
        Assert.assertEquals((String)"Invalid status code reported", (long)400L, (long)response.getErrorCode());
        Assert.assertEquals((String)"Invalid message reported", (Object)"Invalid location: Relative path cannot contain .. segments", (Object)response.getErrorMessage());
    }

    @Test
    public void synchronizedHandleRequest_noLocationParameter_noUiCreated() throws IOException {
        JavaScriptBootstrapHandler bootstrapHandler = new JavaScriptBootstrapHandler();
        VaadinRequest request = this.mocks.createRequest(this.mocks, "/", "v-r=ini&foobar");
        MockServletServiceSessionSetup.TestVaadinServletResponse response = this.mocks.createResponse();
        boolean value = bootstrapHandler.synchronizedHandleRequest(this.mocks.getSession(), request, (VaadinResponse)response);
        Assert.assertTrue((String)"No further request handlers should be called", (boolean)value);
        Assert.assertEquals((String)"Invalid status code reported", (long)400L, (long)response.getErrorCode());
        Assert.assertEquals((String)"Invalid message reported", (Object)"Invalid location: Location parameter missing from bootstrap request to server.", (Object)response.getErrorMessage());
    }

    private boolean hasNodeTag(TestNodeVisitor visitor, String htmContent, NodeVisitor.ElementType type) {
        Pattern regex = Pattern.compile(htmContent, 32);
        return visitor.getVisited().entrySet().stream().anyMatch(entry -> ((NodeVisitor.ElementType)entry.getValue()).equals((Object)type) && regex.matcher(((Node)entry.getKey()).toString()).find());
    }

    @Push
    public static class PushAppShell
    implements AppShellConfigurator {
    }
}

