/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractConfiguration;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AbstractConfigurationTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    AbstractConfiguration configuration = new AbstractConfiguration(){

        public boolean isProductionMode() {
            return false;
        }

        public String getStringProperty(String name, String defaultValue) {
            return null;
        }

        public boolean getBooleanProperty(String name, boolean defaultValue) {
            return false;
        }
    };

    @Test
    public void getProjectFolder_mavenProject_detected() throws IOException {
        this.assertProjectFolderDetected("pom.xml");
    }

    @Test
    public void getProjectFolder_gradleProject_detected() throws IOException {
        this.assertProjectFolderDetected("build.gradle");
    }

    @Test
    public void getProjectFolder_gradleKotlinProject_detected() throws IOException {
        this.assertProjectFolderDetected("build.gradle.kts");
    }

    @Test
    public void getProjectFolder_unknownProject_throws() throws IOException {
        this.withTemporaryUserDir(() -> {
            IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((AbstractConfiguration)this.configuration).getProjectFolder());
            Assert.assertTrue((boolean)exception.getMessage().contains("Failed to determine project directory for dev mode"));
            Assert.assertTrue((boolean)exception.getMessage().contains(this.temporaryFolder.getRoot().getAbsolutePath()));
        });
    }

    private void assertProjectFolderDetected(String projectFile) throws IOException {
        this.temporaryFolder.newFile(projectFile);
        this.withTemporaryUserDir(() -> {
            File projectFolder = this.configuration.getProjectFolder();
            Assert.assertEquals((Object)this.temporaryFolder.getRoot(), (Object)projectFolder);
        });
    }

    private void withTemporaryUserDir(Runnable test) throws IOException {
        String userDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", this.temporaryFolder.getRoot().getAbsolutePath());
            test.run();
        }
        finally {
            if (userDir != null) {
                System.setProperty("user.dir", userDir);
            } else {
                System.clearProperty("user.dir");
            }
        }
    }
}

