/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ElementListenersTest
extends AbstractNodeFeatureTest<ElementListenerMap> {
    private static final DomEventListener noOp = (DomEventListener & Serializable)e -> {};
    private ElementListenerMap ns;

    @Before
    public void init() {
        this.ns = (ElementListenerMap)this.createFeature();
    }

    @Test
    public void addedListenerGetsEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        DomListenerRegistration handle = this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assert.assertEquals((long)0L, (long)eventCount.get());
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assert.assertEquals((long)1L, (long)eventCount.get());
        handle.remove();
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assert.assertEquals((long)1L, (long)eventCount.get());
    }

    @Test
    public void eventNameInClientData() {
        Assert.assertFalse((boolean)this.ns.contains("foo"));
        DomListenerRegistration handle = this.ns.add("foo", noOp);
        Assert.assertEquals((long)0L, (long)this.getExpressions("foo").size());
        handle.remove();
        Assert.assertFalse((boolean)this.ns.contains("foo"));
    }

    @Test
    public void addAndRemoveEventData() {
        this.ns.add("eventType", noOp).addEventData("data1").addEventData("data2");
        Set<String> expressions = this.getExpressions("eventType");
        Assert.assertTrue((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        Assert.assertFalse((boolean)expressions.contains("data3"));
        DomListenerRegistration handle = this.ns.add("eventType", new DomEventListener(){

            public void handleEvent(DomEvent event) {
            }
        }).addEventData("data3");
        expressions = this.getExpressions("eventType");
        Assert.assertTrue((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        Assert.assertTrue((boolean)expressions.contains("data3"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assert.assertTrue((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        Assert.assertFalse((boolean)expressions.contains("data3"));
    }

    @Test
    public void settingsAreOnlyUpdated_should_ListenersSharingTheTypeOfRemovedListenerExist() {
        this.ns = (ElementListenerMap)Mockito.spy((Object)((ElementListenerMap)this.createFeature()));
        DomEventListener & Serializable del1 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del2 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del3 = (DomEventListener & Serializable)event -> {};
        DomListenerRegistration handle1 = this.ns.add("eventType", (DomEventListener)del1).addEventData("data1");
        DomListenerRegistration handle2 = this.ns.add("eventType", (DomEventListener)del2).addEventData("data2");
        DomListenerRegistration handle3 = this.ns.add("eventTypeOther", (DomEventListener)del3).addEventData("data3");
        Mockito.reset((Object[])new ElementListenerMap[]{this.ns});
        Set<String> expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assert.assertTrue((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        Assert.assertTrue((boolean)expressions.contains("data3"));
        handle1.remove();
        ((ElementListenerMap)Mockito.verify((Object)this.ns, (VerificationMode)Mockito.times((int)1))).put((String)ArgumentMatchers.eq((Object)"eventType"), (Serializable)ArgumentMatchers.any(Serializable.class));
        expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assert.assertFalse((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        Assert.assertTrue((boolean)expressions.contains("data3"));
        handle2.remove();
        ((ElementListenerMap)Mockito.verify((Object)this.ns, (VerificationMode)Mockito.times((int)1))).put((String)ArgumentMatchers.eq((Object)"eventType"), (Serializable)ArgumentMatchers.any(Serializable.class));
        expressions = this.getExpressions("eventType");
        expressions.addAll(this.getExpressions("eventTypeOther"));
        Assert.assertFalse((boolean)expressions.contains("data1"));
        Assert.assertFalse((boolean)expressions.contains("data2"));
        Assert.assertTrue((boolean)expressions.contains("data3"));
    }

    @Test
    public void addingRemovingAndAddingListenerOfTheSameType() {
        DomEventListener & Serializable del1 = (DomEventListener & Serializable)event -> {};
        DomEventListener & Serializable del2 = (DomEventListener & Serializable)event -> {};
        DomListenerRegistration handle = this.ns.add("eventType", (DomEventListener)del1).addEventData("data1");
        Set<String> expressions = this.getExpressions("eventType");
        Assert.assertTrue((boolean)expressions.contains("data1"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assert.assertFalse((boolean)expressions.contains("data1"));
        handle = this.ns.add("eventType", (DomEventListener)del2).addEventData("data2");
        expressions = this.getExpressions("eventType");
        Assert.assertFalse((boolean)expressions.contains("data1"));
        Assert.assertTrue((boolean)expressions.contains("data2"));
        handle.remove();
        expressions = this.getExpressions("eventType");
        Assert.assertFalse((boolean)expressions.contains("data1"));
        Assert.assertFalse((boolean)expressions.contains("data2"));
    }

    @Test
    public void eventDataInEvent() {
        AtomicReference eventDataReference = new AtomicReference();
        this.ns.add("foo", (DomEventListener & Serializable)e -> {
            Assert.assertNull(eventDataReference.get());
            eventDataReference.set(e.getEventData());
        });
        Assert.assertNull(eventDataReference.get());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("baz", true);
        this.ns.fireEvent(new DomEvent(new Element("element"), "foo", (JsonNode)eventData));
        JsonNode capturedJson = (JsonNode)eventDataReference.get();
        Assert.assertNotNull((Object)capturedJson);
        Assert.assertEquals((long)1L, (long)JacksonUtils.getKeys((JsonNode)capturedJson).size());
        Assert.assertEquals((Object)"true", (Object)capturedJson.get("baz").toString());
    }

    @Test
    public void disabledElement_listenerDoesntReceiveEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assert.assertEquals((long)0L, (long)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        event.getSource().setEnabled(false);
        this.ns.fireEvent(event);
        Assert.assertEquals((long)0L, (long)eventCount.get());
    }

    @Test
    public void implicitlyDisabledElement_listenerDoesntReceiveEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        Assert.assertEquals((long)0L, (long)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        Element parent = new Element("parent");
        parent.appendChild(new Element[]{event.getSource()});
        parent.setEnabled(false);
        this.ns.fireEvent(event);
        Assert.assertEquals((long)0L, (long)eventCount.get());
    }

    @Test
    public void disabledElement_listenerWithAlwaysUpdateModeReceivesEvent() {
        AtomicInteger eventCount = new AtomicInteger();
        this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet()).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        Assert.assertEquals((long)0L, (long)eventCount.get());
        DomEvent event = ElementListenersTest.createEvent("foo");
        event.getSource().setEnabled(false);
        this.ns.fireEvent(event);
        Assert.assertEquals((long)1L, (long)eventCount.get());
    }

    @Test
    public void serializable() {
        this.ns.add("click", noOp).addEventData("eventdata");
        ElementListenerMap roundtrip = (ElementListenerMap)SerializationUtils.roundtrip((Serializable)this.ns);
        Set expressions = roundtrip.getExpressions("click");
        Assert.assertEquals(Collections.singleton("eventdata"), (Object)expressions);
    }

    @Test
    public void synchronizeProperty_hasSynchronizedProperty() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assert.assertNull((Object)this.ns.getPropertySynchronizationMode("name"));
        registration.synchronizeProperty("anotherName");
        Assert.assertNull((Object)this.ns.getPropertySynchronizationMode("name"));
        registration.synchronizeProperty("name");
        Assert.assertSame((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    public void synchronizeProperty_alwaysMode() {
        DomListenerRegistration registration = this.ns.add("foo", noOp).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        registration.synchronizeProperty("name");
        Assert.assertSame((Object)DisabledUpdateMode.ALWAYS, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    public void synchronizeProperty_bothModes() {
        DomListenerRegistration registration1 = this.ns.add("foo", noOp).setDisabledUpdateMode(DisabledUpdateMode.ALWAYS);
        registration1.synchronizeProperty("name");
        DomListenerRegistration registration2 = this.ns.add("foo", noOp);
        registration2.synchronizeProperty("name");
        Assert.assertSame((Object)DisabledUpdateMode.ALWAYS, (Object)this.ns.getPropertySynchronizationMode("name"));
    }

    @Test
    public void synchronizeProperty_hasExpressionToken() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        Assert.assertEquals(Collections.emptySet(), this.getExpressions("foo"));
        registration.synchronizeProperty("name");
        Assert.assertEquals(Collections.singleton("}name"), this.getExpressions("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void synchronizeProperty_nullArgument_illegalArgumentException() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        registration.synchronizeProperty(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void synchronizeProperty_emptyArgument_illegalArgumentException() {
        DomListenerRegistration registration = this.ns.add("foo", noOp);
        registration.synchronizeProperty("");
    }

    @Test
    public void mapEventTargetToElement_targetNodeIdInJsonData_elementMapped() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        Element grandChild = new Element("grandChild");
        parent.appendChild(new Element[]{(Element)child.appendChild(new Element[]{grandChild})});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent});
        String eventType = "click";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", (DomEventListener & Serializable)e -> capturedTarget.set(e.getEventTarget().orElse(null)));
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assert.assertEquals((long)0L, (long)expressions.size());
        registration.mapEventTargetElement();
        expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assert.assertEquals((long)1L, (long)expressions.size());
        Assert.assertEquals((Object)"]", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertEquals((Object)child, capturedTarget.get());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)JacksonUtils.createObjectNode()));
        Assert.assertNull((String)"no element should be reported", capturedTarget.get());
        eventData.put("]", grandChild.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertEquals((Object)grandChild, capturedTarget.get());
        eventData.put("]", -1);
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertNull((String)"no element should be reported", capturedTarget.get());
    }

    @Test
    public void addEventDataElement_targetNodeInJsonData_elementMapped() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        Element sibling = new Element("sibling");
        parent.appendChild(new Element[]{child});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent, sibling});
        String eventType = "click";
        String expression = "expression";
        String key = "]expression";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", capturedTarget::set);
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assert.assertEquals((long)0L, (long)expressions.size());
        registration.addEventDataElement("expression");
        expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assert.assertEquals((long)1L, (long)expressions.size());
        Assert.assertEquals((Object)"]expression", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]expression", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventDataElement("expression").get());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)JacksonUtils.createObjectNode()));
        Assert.assertFalse((String)"no element should be reported", (boolean)((DomEvent)capturedTarget.get()).getEventDataElement("expression").isPresent());
        eventData.put("]expression", sibling.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertEquals((Object)sibling, ((DomEvent)capturedTarget.get()).getEventDataElement("expression").get());
    }

    @Test
    public void addEventDataElement_eventTarget_usesMapEventTargetInstead() {
        Element parent = new Element("parent");
        Element child = new Element("child");
        parent.appendChild(new Element[]{child});
        new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class}).getUI().getElement().appendChild(new Element[]{parent});
        String eventType = "click";
        AtomicReference capturedTarget = new AtomicReference();
        DomListenerRegistration registration = parent.addEventListener("click", capturedTarget::set);
        ElementListenerMap listenerMap = (ElementListenerMap)parent.getNode().getFeature(ElementListenerMap.class);
        registration.addEventDataElement("event.target");
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "click");
        Assert.assertEquals((long)1L, (long)expressions.size());
        Assert.assertEquals((Object)"]", (Object)expressions.iterator().next());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("]", child.getNode().getId());
        listenerMap.fireEvent(new DomEvent(parent, "click", (JsonNode)eventData));
        Assert.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventTarget().get());
        Assert.assertEquals((Object)child, ((DomEvent)capturedTarget.get()).getEventDataElement("event.target").get());
    }

    @Test
    public void eventDataKeyNotPresentNotFail() {
        AtomicInteger eventCount = new AtomicInteger();
        DomListenerRegistration registration = this.ns.add("foo", (DomEventListener & Serializable)e -> eventCount.incrementAndGet());
        registration.setFilter("filterKey");
        this.ns.fireEvent(ElementListenersTest.createEvent("foo"));
        Assert.assertEquals((long)0L, (long)eventCount.get());
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("filterKey", true);
        this.ns.fireEvent(new DomEvent(new Element("element"), "foo", (JsonNode)eventData));
        Assert.assertEquals((long)1L, (long)eventCount.get());
    }

    @Test
    public void testPreventDefaultWithFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === ' ' || event.key === 'Enter'");
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have the filter expression", (boolean)expressions.contains("event.key === ' ' || event.key === 'Enter'"));
        Assert.assertTrue((String)"Should have conditional preventDefault expression", (boolean)expressions.contains("(event.key === ' ' || event.key === 'Enter') && event.preventDefault()"));
        Assert.assertFalse((String)"Should NOT have unconditional preventDefault", (boolean)expressions.contains("event.preventDefault()"));
    }

    @Test
    public void testPreventDefaultWithoutFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have preventDefault expression", (boolean)expressions.contains("event.preventDefault()"));
        Assert.assertEquals((String)"Should only have preventDefault expression", (long)1L, (long)expressions.size());
    }

    @Test
    public void testPreventDefaultThenSetFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.preventDefault();
        registration.setFilter("event.key === 'Escape'");
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have conditional preventDefault expression", (boolean)expressions.contains("(event.key === 'Escape') && event.preventDefault()"));
        Assert.assertFalse((String)"Should NOT have unconditional preventDefault", (boolean)expressions.contains("event.preventDefault()"));
    }

    @Test
    public void testSetFilterThenPreventDefault() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === 'Delete'");
        registration.preventDefault();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have conditional preventDefault expression", (boolean)expressions.contains("(event.key === 'Delete') && event.preventDefault()"));
        Assert.assertFalse((String)"Should NOT have unconditional preventDefault", (boolean)expressions.contains("event.preventDefault()"));
    }

    @Test
    public void testStopPropagationWithFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === ' ' || event.key === 'Enter'");
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have the filter expression", (boolean)expressions.contains("event.key === ' ' || event.key === 'Enter'"));
        Assert.assertTrue((String)"Should have conditional stopPropagation expression", (boolean)expressions.contains("(event.key === ' ' || event.key === 'Enter') && event.stopPropagation()"));
        Assert.assertFalse((String)"Should NOT have unconditional stopPropagation", (boolean)expressions.contains("event.stopPropagation()"));
    }

    @Test
    public void testStopPropagationWithoutFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have stopPropagation expression", (boolean)expressions.contains("event.stopPropagation()"));
        Assert.assertEquals((String)"Should only have stopPropagation expression", (long)1L, (long)expressions.size());
    }

    @Test
    public void testStopPropagationThenSetFilter() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.stopPropagation();
        registration.setFilter("event.key === 'Escape'");
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have conditional stopPropagation expression", (boolean)expressions.contains("(event.key === 'Escape') && event.stopPropagation()"));
        Assert.assertFalse((String)"Should NOT have unconditional stopPropagation", (boolean)expressions.contains("event.stopPropagation()"));
    }

    @Test
    public void testSetFilterThenStopPropagation() {
        DomListenerRegistration registration = this.ns.add("keydown", noOp);
        registration.setFilter("event.key === 'Delete'");
        registration.stopPropagation();
        Set<String> expressions = this.getExpressions("keydown");
        Assert.assertTrue((String)"Should have conditional stopPropagation expression", (boolean)expressions.contains("(event.key === 'Delete') && event.stopPropagation()"));
        Assert.assertFalse((String)"Should NOT have unconditional stopPropagation", (boolean)expressions.contains("event.stopPropagation()"));
    }

    @Test
    public void testAddEventDataWithRecord() {
        DomListenerRegistration registration = this.ns.add("click", noOp);
        record MouseEventData(1EventDetails event, String type) {
            private final 1EventDetails event;

            MouseEventData {
                record EventDetails(int button, int clientX, int clientY) {
                }
            }

            public 1EventDetails event() {
                return this.event;
            }
        }
        registration.addEventData(MouseEventData.class);
        Set<String> expressions = this.getExpressions("click");
        Assert.assertTrue((String)"Should capture event.button", (boolean)expressions.contains("event.button"));
        Assert.assertTrue((String)"Should capture event.clientX", (boolean)expressions.contains("event.clientX"));
        Assert.assertTrue((String)"Should capture event.clientY", (boolean)expressions.contains("event.clientY"));
        Assert.assertTrue((String)"Should capture type", (boolean)expressions.contains("type"));
        Assert.assertEquals((String)"Should have 4 expressions", (long)4L, (long)expressions.size());
    }

    @Test
    public void testAddEventDataWithSimpleBean() {
        DomListenerRegistration registration = this.ns.add("custom", noOp);
        class SimpleEventData {
            private String message;
            private int code;

            SimpleEventData(ElementListenersTest this$0) {
            }

            public String getMessage() {
                return this.message;
            }

            public int getCode() {
                return this.code;
            }
        }
        registration.addEventData(SimpleEventData.class);
        Set<String> expressions = this.getExpressions("custom");
        Assert.assertTrue((String)"Should capture message", (boolean)expressions.contains("message"));
        Assert.assertTrue((String)"Should capture code", (boolean)expressions.contains("code"));
        Assert.assertEquals((String)"Should have 2 expressions", (long)2L, (long)expressions.size());
    }

    @Test
    public void testAddEventDetail() {
        DomListenerRegistration registration = this.ns.add("color-change", noOp);
        registration.addEventDetail();
        Set<String> expressions = this.getExpressions("color-change");
        Assert.assertTrue((String)"Should capture event.detail", (boolean)expressions.contains("event.detail"));
        Assert.assertEquals((String)"Should have 1 expression", (long)1L, (long)expressions.size());
    }

    @Test
    public void testAddEventDetailChaining() {
        DomListenerRegistration registration = this.ns.add("custom-event", noOp);
        registration.addEventDetail().addEventData("event.timestamp");
        Set<String> expressions = this.getExpressions("custom-event");
        Assert.assertTrue((String)"Should capture event.detail", (boolean)expressions.contains("event.detail"));
        Assert.assertTrue((String)"Should capture event.timestamp", (boolean)expressions.contains("event.timestamp"));
        Assert.assertEquals((String)"Should have 2 expressions", (long)2L, (long)expressions.size());
    }

    @Test
    public void testAddEventDetailWithClass() {
        DomListenerRegistration registration = this.ns.add("color-change", noOp);
        record RgbColor(int r, int g, int b) {
        }
        registration.addEventDetail(RgbColor.class);
        Set<String> expressions = this.getExpressions("color-change");
        Assert.assertTrue((String)"Should capture event.detail.r", (boolean)expressions.contains("event.detail.r"));
        Assert.assertTrue((String)"Should capture event.detail.g", (boolean)expressions.contains("event.detail.g"));
        Assert.assertTrue((String)"Should capture event.detail.b", (boolean)expressions.contains("event.detail.b"));
        Assert.assertFalse((String)"Should NOT capture entire event.detail", (boolean)expressions.contains("event.detail"));
        Assert.assertEquals((String)"Should have 3 expressions", (long)3L, (long)expressions.size());
    }

    @Test
    public void testAddEventDetailWithClassAndGetEventDetail() {
        Element element = new Element("div");
        AtomicReference capturedColor = new AtomicReference();
        record RgbColor(int r, int g, int b) {
        }
        element.addEventListener("color-change", (DomEventListener & Serializable)e -> capturedColor.set((RgbColor)e.getEventDetail(RgbColor.class))).addEventDetail(RgbColor.class);
        ElementListenerMap listenerMap = (ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class);
        Set<String> expressions = ElementListenersTest.getExpressions(listenerMap, "color-change");
        Assert.assertTrue((String)"Should capture event.detail.r", (boolean)expressions.contains("event.detail.r"));
        Assert.assertTrue((String)"Should capture event.detail.g", (boolean)expressions.contains("event.detail.g"));
        Assert.assertTrue((String)"Should capture event.detail.b", (boolean)expressions.contains("event.detail.b"));
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("event.detail.r", 255);
        eventData.put("event.detail.g", 128);
        eventData.put("event.detail.b", 64);
        listenerMap.fireEvent(new DomEvent(element, "color-change", (JsonNode)eventData));
        RgbColor result = (RgbColor)capturedColor.get();
        Assert.assertNotNull((String)"Should have captured color", (Object)result);
        Assert.assertEquals((String)"Red should be 255", (long)255L, (long)result.r());
        Assert.assertEquals((String)"Green should be 128", (long)128L, (long)result.g());
        Assert.assertEquals((String)"Blue should be 64", (long)64L, (long)result.b());
    }

    @Test
    public void testAddEventDetailWithNestedClass() {
        DomListenerRegistration registration = this.ns.add("drag", noOp);
        record DragDetail(1Position start, 1Position end) {
            private final 1Position start;
            private final 1Position end;

            DragDetail {
                record Position(int x, int y) {
                }
            }

            public 1Position start() {
                return this.start;
            }

            public 1Position end() {
                return this.end;
            }
        }
        registration.addEventDetail(DragDetail.class);
        Set<String> expressions = this.getExpressions("drag");
        Assert.assertTrue((String)"Should capture event.detail.start.x", (boolean)expressions.contains("event.detail.start.x"));
        Assert.assertTrue((String)"Should capture event.detail.start.y", (boolean)expressions.contains("event.detail.start.y"));
        Assert.assertTrue((String)"Should capture event.detail.end.x", (boolean)expressions.contains("event.detail.end.x"));
        Assert.assertTrue((String)"Should capture event.detail.end.y", (boolean)expressions.contains("event.detail.end.y"));
        Assert.assertEquals((String)"Should have 4 expressions", (long)4L, (long)expressions.size());
    }

    @Test
    public void testGetEventDetailWithRecord() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detailData = JacksonUtils.createObjectNode();
        detailData.put("r", 255);
        detailData.put("g", 128);
        detailData.put("b", 64);
        eventData.set("event.detail", (JsonNode)detailData);
        DomEvent event = new DomEvent(new Element("element"), "color-change", (JsonNode)eventData);
        record RgbColor(int r, int g, int b) {
        }
        RgbColor color = (RgbColor)event.getEventDetail(RgbColor.class);
        Assert.assertNotNull((String)"Color should not be null", (Object)color);
        Assert.assertEquals((String)"Red should be 255", (long)255L, (long)color.r());
        Assert.assertEquals((String)"Green should be 128", (long)128L, (long)color.g());
        Assert.assertEquals((String)"Blue should be 64", (long)64L, (long)color.b());
    }

    @Test
    public void testGetEventDetailWithBean() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ObjectNode detailData = JacksonUtils.createObjectNode();
        detailData.put("message", "Hello World");
        detailData.put("code", 42);
        eventData.set("event.detail", (JsonNode)detailData);
        DomEvent event = new DomEvent(new Element("element"), "custom-event", (JsonNode)eventData);
        EventPayload payload = (EventPayload)event.getEventDetail(EventPayload.class);
        Assert.assertNotNull((String)"Payload should not be null", (Object)payload);
        Assert.assertEquals((String)"Message should match", (Object)"Hello World", (Object)payload.getMessage());
        Assert.assertEquals((String)"Code should match", (long)42L, (long)payload.getCode());
    }

    @Test
    public void testGetEventDetailWithTypeReference() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        ArrayNode detailArray = JacksonUtils.createArrayNode();
        detailArray.add("first");
        detailArray.add("second");
        detailArray.add("third");
        eventData.set("event.detail", (JsonNode)detailArray);
        DomEvent event = new DomEvent(new Element("element"), "list-change", (JsonNode)eventData);
        List items = (List)event.getEventDetail((TypeReference)new TypeReference<List<String>>(this){});
        Assert.assertNotNull((String)"Items should not be null", (Object)items);
        Assert.assertEquals((String)"Should have 3 items", (long)3L, (long)items.size());
        Assert.assertEquals((String)"First item", (Object)"first", items.get(0));
        Assert.assertEquals((String)"Second item", (Object)"second", items.get(1));
        Assert.assertEquals((String)"Third item", (Object)"third", items.get(2));
    }

    @Test
    public void testGetEventDetailReturnsNullWhenNotPresent() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        DomEvent event = new DomEvent(new Element("element"), "event", (JsonNode)eventData);
        record SomeData(String value) {
        }
        SomeData data = (SomeData)event.getEventDetail(SomeData.class);
        Assert.assertNull((String)"Should return null when event.detail not present", (Object)data);
    }

    @Test
    public void testGetEventDetailReturnsNullWhenNull() {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.set("event.detail", (JsonNode)JacksonUtils.nullNode());
        DomEvent event = new DomEvent(new Element("element"), "event", (JsonNode)eventData);
        record SomeData(String value) {
        }
        SomeData data = (SomeData)event.getEventDetail(SomeData.class);
        Assert.assertNull((String)"Should return null when event.detail is null", (Object)data);
    }

    public static Set<String> getExpressions(ElementListenerMap elementListenerMap, String eventName) {
        return new HashSet<String>(elementListenerMap.getExpressions(eventName));
    }

    private Set<String> getExpressions(String name) {
        return ElementListenersTest.getExpressions(this.ns, name);
    }

    private static DomEvent createEvent(String type) {
        return new DomEvent(new Element("fake"), type, (JsonNode)JacksonUtils.createObjectNode());
    }

    public static class EventPayload {
        private String message;
        private int code;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }
    }
}

