/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BundleUtils;
import com.vaadin.flow.internal.JacksonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class BundleUtilsTest {
    private List<AutoCloseable> closeOnTearDown = new ArrayList<AutoCloseable>();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @After
    public void tearDown() {
        for (AutoCloseable closeable : this.closeOnTearDown) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void frontendImportVariantsIncluded() {
        this.mockStatsJson("Frontend/foo.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/foo.js"));
        Assert.assertTrue((boolean)bundleImports.contains("foo.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./foo.js"));
    }

    @Test
    public void jarImportVariantsIncluded() {
        this.mockStatsJson("Frontend/generated/jar-resources/my/addon.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/my/addon.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./my/addon.js"));
        Assert.assertTrue((boolean)bundleImports.contains("my/addon.js"));
    }

    @Test
    public void frontendInTheMiddleNotTouched() {
        this.mockStatsJson("my/Frontend/foo.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertEquals(Set.of("my/Frontend/foo.js"), (Object)bundleImports);
    }

    @Test
    public void themeVariantsHandled() {
        this.mockStatsJson("@foo/bar/theme/lumo/file.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("@foo/bar/theme/lumo/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("@foo/bar/src/file.js"));
    }

    @Test
    public void themeVariantsFromJarHandled() {
        this.mockStatsJson("Frontend/generated/jar-resources/theme/lumo/file.js", "Frontend/generated/jar-resources/theme/material/file.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/theme/lumo/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/theme/material/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./src/file.js"));
    }

    private void mockStatsJson(String ... imports) {
        ObjectNode statsJson = JacksonUtils.createObjectNode();
        ArrayNode importsArray = JacksonUtils.createArrayNode();
        for (String anImport : imports) {
            importsArray.add(anImport);
        }
        statsJson.set("bundleImports", (JsonNode)importsArray);
        this.mockStatsJsonLoading((JsonNode)statsJson);
    }

    private void mockStatsJsonLoading(JsonNode statsJson) {
        MockedStatic mock = Mockito.mockStatic(BundleUtils.class);
        mock.when(() -> BundleUtils.loadStatsJson()).thenReturn((Object)statsJson);
        mock.when(() -> BundleUtils.loadBundleImports()).thenCallRealMethod();
        this.closeOnTearDown.add((AutoCloseable)mock);
    }

    @Test
    public void loadStatsJson_cachesResult_returnsSameInstance() {
        ObjectNode first = BundleUtils.loadStatsJson();
        ObjectNode second = BundleUtils.loadStatsJson();
        Assert.assertSame((String)"Should return cached instance on second call", (Object)first, (Object)second);
    }

    @Test
    public void loadStatsJson_cachedResultIsConsistent() {
        ObjectNode first = BundleUtils.loadStatsJson();
        ObjectNode second = BundleUtils.loadStatsJson();
        Assert.assertEquals((String)"Cached result should be consistent", (Object)first.toString(), (Object)second.toString());
    }

    @Test
    public void isPreCompiledProductionBundle_usesCachedStats() {
        boolean first = BundleUtils.isPreCompiledProductionBundle();
        boolean second = BundleUtils.isPreCompiledProductionBundle();
        boolean third = BundleUtils.isPreCompiledProductionBundle();
        Assert.assertEquals((String)"Should return consistent results", (Object)first, (Object)second);
        Assert.assertEquals((String)"Should return consistent results", (Object)second, (Object)third);
    }
}

