/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.CompositeNestedTest;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.tests.util.TestUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@NotThreadSafe
public class CompositeTest {
    CompositeNestedTest.TestLayout layoutWithSingleComponentComposite;
    CompositeWithComponent compositeWithComponent;
    CompositeNestedTest.TestLayout layoutInsideComposite;
    Component componentInsideLayoutInsideComposite;

    protected Component createTestComponent() {
        return new ComponentTest.TestComponent(ElementFactory.createDiv((String)"Component in composite"));
    }

    protected CompositeNestedTest.TestLayout createTestLayout() {
        return new CompositeNestedTest.TestLayout(){

            @Override
            public String toString() {
                return "layoutInsideComposite";
            }
        };
    }

    @Before
    public void setup() {
        this.compositeWithComponent = new CompositeWithComponent(){

            public String toString() {
                return "Composite";
            }
        };
        this.layoutWithSingleComponentComposite = new CompositeNestedTest.TestLayout(){

            @Override
            public String toString() {
                return "Layout";
            }
        };
        this.layoutWithSingleComponentComposite.addComponent(new Component[]{this.compositeWithComponent});
        ((ComponentTest.TracksAttachDetach)this.componentInsideLayoutInsideComposite).track();
        this.compositeWithComponent.track();
        this.layoutInsideComposite.track();
        this.layoutWithSingleComponentComposite.track();
        Assert.assertNull((Object)VaadinService.getCurrent());
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)configuration);
        VaadinService.setCurrent((VaadinService)service);
    }

    @After
    public void tearDown() {
        VaadinService.setCurrent(null);
    }

    @Test
    public void getElement_compositeAndCompositeComponent() {
        Assert.assertEquals((Object)this.layoutInsideComposite.getElement(), (Object)this.compositeWithComponent.getElement());
    }

    @Test
    public void getParentElement_compositeInLayout() {
        Assert.assertEquals((Object)this.layoutWithSingleComponentComposite.getElement(), (Object)this.compositeWithComponent.getElement().getParent());
    }

    @Test
    public void getElementChildren_layoutWithComponentInComposite() {
        CompositeTest.assertElementChildren(this.layoutWithSingleComponentComposite.getElement(), this.layoutInsideComposite.getElement());
    }

    @Test
    public void getParent_compositeInLayout() {
        Assert.assertEquals((Object)this.layoutWithSingleComponentComposite, this.compositeWithComponent.getParent().get());
    }

    @Test
    public void getParent_componentInComposite() {
        Assert.assertEquals((Object)this.compositeWithComponent, this.layoutInsideComposite.getParent().get());
    }

    @Test
    public void getParent_componentInLayoutInComposite() {
        Assert.assertEquals((Object)this.layoutInsideComposite, this.componentInsideLayoutInsideComposite.getParent().get());
    }

    @Test
    public void getChildren_layoutWithComposite() {
        ComponentTest.assertChildren(this.layoutWithSingleComponentComposite, new Component[]{this.compositeWithComponent});
    }

    @Test
    public void getChildren_compositeWithComponent() {
        ComponentTest.assertChildren((Component)this.compositeWithComponent, this.layoutInsideComposite);
    }

    @Test
    public void getChildren_layoutInComposite() {
        ComponentTest.assertChildren(this.layoutInsideComposite, this.componentInsideLayoutInsideComposite);
    }

    @Test
    public void automaticCompositeContentType() {
        class CompositeWithGenericType
        extends Composite<ComponentTest.TestComponent> {
            CompositeWithGenericType() {
            }
        }
        CompositeWithGenericType instance = new CompositeWithGenericType();
        Assert.assertEquals(ComponentTest.TestComponent.class, ((ComponentTest.TestComponent)instance.getContent()).getClass());
    }

    @Test(expected=IllegalStateException.class)
    public void compositeContentTypeWithVariableTypeParameter() {
        class CompositeWithVariableType<C extends Component>
        extends Composite<C> {
            CompositeWithVariableType() {
            }
        }
        CompositeWithVariableType composite = new CompositeWithVariableType();
        composite.getContent();
    }

    @Test
    public void compositeContentTypeWithSpecifiedType() {
        class CompositeWithCustomComponent
        extends Composite<CustomComponent<List<String>>> {
            CompositeWithCustomComponent() {
            }
        }
        CompositeWithCustomComponent composite = new CompositeWithCustomComponent();
        Assert.assertEquals(CustomComponent.class, ((Object)((Object)((CustomComponent)composite.getContent()))).getClass());
    }

    @Test(expected=IllegalStateException.class)
    public void compositeContentTypeWithTypeVariable() {
        class CompositeWithComposite
        extends Composite<CompositeWithVariableType<ComponentTest.TestComponent>> {
            CompositeWithComposite() {
            }
        }
        CompositeWithComposite composite = new CompositeWithComposite();
        composite.getContent();
    }

    @Test(expected=IllegalStateException.class)
    public void rawContentType() {
        class CompositeWithRawType
        extends Composite {
            CompositeWithRawType() {
            }
        }
        CompositeWithRawType composite = new CompositeWithRawType();
        composite.getContent();
    }

    @Test(expected=IllegalArgumentException.class)
    public void noDefaultConstructor() {
        class NoDefaultConstructor
        extends Composite<Text> {
            NoDefaultConstructor() {
            }
        }
        NoDefaultConstructor composite = new NoDefaultConstructor();
        composite.getContent();
    }

    @Test
    public void compositeHierarchy() {
        class ComplexClass
        extends 1Class4<String, UI, Boolean> {
            ComplexClass() {
                class Class4<A, B extends Component, C>
                extends 1Class3<B> {
                    Class4() {
                        class Class3<E extends Component>
                        extends 1Class2<String, E> {
                            Class3() {
                                class Class2<T, V extends Component>
                                extends 1Class1<V> {
                                    Class2() {
                                        class Class1<T extends Component>
                                        extends Composite<T> {
                                            Class1() {
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ComplexClass composite = new ComplexClass();
        Assert.assertEquals(UI.class, ((UI)composite.getContent()).getClass());
    }

    @Test
    public void attachDetachEvents_compositeHierarchy_correctOrder() {
        UI ui = new UI();
        ArrayList attached = new ArrayList();
        ArrayList detached = new ArrayList();
        ComponentEventListener & Serializable attachListener = (ComponentEventListener & Serializable)event -> attached.add(event.getSource());
        ComponentEventListener & Serializable detachListener = (ComponentEventListener & Serializable)event -> detached.add(event.getSource());
        this.layoutInsideComposite.addAttachListener(attachListener);
        this.layoutWithSingleComponentComposite.addAttachListener(attachListener);
        this.compositeWithComponent.addAttachListener(attachListener);
        this.componentInsideLayoutInsideComposite.addAttachListener((ComponentEventListener)attachListener);
        this.layoutInsideComposite.addDetachListener(detachListener);
        this.layoutWithSingleComponentComposite.addDetachListener(detachListener);
        this.compositeWithComponent.addDetachListener(detachListener);
        this.componentInsideLayoutInsideComposite.addDetachListener((ComponentEventListener)detachListener);
        this.layoutInsideComposite.assertAttachEvents(0);
        this.layoutWithSingleComponentComposite.assertAttachEvents(0);
        this.compositeWithComponent.assertAttachEvents(0);
        ((ComponentTest.TracksAttachDetach)this.componentInsideLayoutInsideComposite).assertAttachEvents(0);
        ui.add(new Component[]{this.layoutWithSingleComponentComposite});
        this.layoutInsideComposite.assertAttachEvents(1);
        this.layoutWithSingleComponentComposite.assertAttachEvents(1);
        this.compositeWithComponent.assertAttachEvents(1);
        ((ComponentTest.TracksAttachDetach)this.componentInsideLayoutInsideComposite).assertAttachEvents(1);
        TestUtil.assertArrays(attached.toArray(), new Component[]{this.componentInsideLayoutInsideComposite, this.layoutInsideComposite, this.compositeWithComponent, this.layoutWithSingleComponentComposite});
        this.layoutInsideComposite.assertDetachEvents(0);
        this.layoutWithSingleComponentComposite.assertDetachEvents(0);
        this.compositeWithComponent.assertDetachEvents(0);
        ((ComponentTest.TracksAttachDetach)this.componentInsideLayoutInsideComposite).assertDetachEvents(0);
        ui.removeAll();
        this.layoutInsideComposite.assertDetachEvents(1);
        this.layoutWithSingleComponentComposite.assertDetachEvents(1);
        this.compositeWithComponent.assertDetachEvents(1);
        ((ComponentTest.TracksAttachDetach)this.componentInsideLayoutInsideComposite).assertDetachEvents(1);
        TestUtil.assertArrays(detached.toArray(), new Component[]{this.componentInsideLayoutInsideComposite, this.layoutInsideComposite, this.compositeWithComponent, this.layoutWithSingleComponentComposite});
    }

    @Test
    public void testOnAttachOnDetachAndEventsOrder() {
        final ArrayList triggered = new ArrayList();
        final Component component = new Component(new Element("div")){

            protected void onAttach(AttachEvent attachEvent) {
                triggered.add(1);
            }

            protected void onDetach(DetachEvent detachEvent) {
                triggered.add(-1);
            }
        };
        component.addAttachListener((ComponentEventListener & Serializable)event -> triggered.add(2));
        component.addDetachListener((ComponentEventListener & Serializable)event -> triggered.add(-2));
        Composite<Component> compositeInsideComposite = new Composite<Component>(){

            protected Component initContent() {
                return component;
            }

            protected void onAttach(AttachEvent attachEvent) {
                triggered.add(3);
            }

            protected void onDetach(DetachEvent detachEvent) {
                triggered.add(-3);
            }
        };
        compositeInsideComposite.addAttachListener((ComponentEventListener & Serializable)event -> triggered.add(4));
        compositeInsideComposite.addDetachListener((ComponentEventListener & Serializable)event -> triggered.add(-4));
        Composite<Component> composite = new Composite<Component>((Composite)compositeInsideComposite, triggered){
            final /* synthetic */ Composite val$compositeInsideComposite;
            final /* synthetic */ List val$triggered;
            {
                this.val$compositeInsideComposite = composite;
                this.val$triggered = list;
            }

            protected Component initContent() {
                return this.val$compositeInsideComposite;
            }

            protected void onAttach(AttachEvent attachEvent) {
                this.val$triggered.add(5);
            }

            protected void onDetach(DetachEvent detachEvent) {
                this.val$triggered.add(-5);
            }
        };
        composite.addAttachListener((ComponentEventListener & Serializable)event -> triggered.add(6));
        composite.addDetachListener((ComponentEventListener & Serializable)event -> triggered.add(-6));
        UI ui = new UI();
        ui.add(new Component[]{composite});
        TestUtil.assertArrays(triggered.toArray(), new Integer[]{1, 2, 3, 4, 5, 6});
        triggered.clear();
        ui.remove(new Component[]{composite});
        TestUtil.assertArrays(triggered.toArray(), new Integer[]{-1, -2, -3, -4, -5, -6});
        CompositeNestedTest.TestLayout container = this.createTestLayout();
        ui.add(new Component[]{container, composite});
        triggered.clear();
        container.addComponent(new Component[]{composite});
        TestUtil.assertArrays(triggered.toArray(), new Integer[]{-1, -2, -3, -4, -5, -6, 1, 2, 3, 4, 5, 6});
    }

    public static void assertElementChildren(Element parent, Element ... expected) {
        Assert.assertEquals((long)expected.length, (long)parent.getChildCount());
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Assert.assertEquals((Object)expected[i], (Object)parent.getChild(i));
        }
    }

    public class CompositeWithComponent
    extends Composite<Component>
    implements ComponentTest.TracksAttachDetach {
        private AtomicInteger attachEvents = new AtomicInteger();
        private AtomicInteger detachEvents = new AtomicInteger();

        protected Component initContent() {
            CompositeTest.this.layoutInsideComposite = CompositeTest.this.createTestLayout();
            CompositeTest.this.componentInsideLayoutInsideComposite = CompositeTest.this.createTestComponent();
            CompositeTest.this.layoutInsideComposite.addComponent(CompositeTest.this.componentInsideLayoutInsideComposite);
            return CompositeTest.this.layoutInsideComposite;
        }

        @Override
        public AtomicInteger getAttachEvents() {
            return this.attachEvents;
        }

        @Override
        public AtomicInteger getDetachEvents() {
            return this.detachEvents;
        }
    }

    public static class CustomComponent<T>
    extends UI {
    }

    public static class CompositeWithVariableType<C extends Component>
    extends Composite<C> {
    }
}

