/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.PollNotifier;
import com.vaadin.flow.component.ScrollIntoViewOption;
import com.vaadin.flow.component.ScrollOptions;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.MockUI;
import com.vaadin.tests.util.TestUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;

public class ComponentTest {
    private UI testUI;
    private Component divWithTextComponent;
    private Component parentDivComponent;
    private Component child1SpanComponent;
    private Component child2InputComponent;
    private Component shadowRootParent;
    private Component shadowChild;
    private MockServletServiceSessionSetup mocks;
    private VaadinSession session;

    @After
    public void checkThreadLocal() {
        Assert.assertNull(Component.elementToMapTo.get());
    }

    private UI createMockedUI() {
        UI mockUI = new UI(){

            public VaadinSession getSession() {
                return ComponentTest.this.session;
            }
        };
        mockUI.getInternals().setSession(this.session);
        return mockUI;
    }

    @Before
    public void setup() throws Exception {
        this.resetComponentTrackerProductionMode();
        this.divWithTextComponent = new TestComponent(ElementFactory.createDiv((String)"Test component"));
        this.parentDivComponent = new TestComponent(ElementFactory.createDiv());
        this.child1SpanComponent = new TestComponent(ElementFactory.createSpan((String)"Span"));
        this.child2InputComponent = new TestComponent(ElementFactory.createInput());
        this.parentDivComponent.getElement().appendChild(new Element[]{this.child1SpanComponent.getElement(), this.child2InputComponent.getElement()});
        this.mocks = new MockServletServiceSessionSetup();
        this.session = this.mocks.getSession();
        this.testUI = this.createMockedUI();
        UI.setCurrent((UI)this.testUI);
    }

    @After
    public void tearDown() throws Exception {
        UI.setCurrent(null);
        this.mocks.cleanup();
        this.resetComponentTrackerProductionMode();
    }

    @Test
    public void getComponentLocale_noCurrentUI_returnsDefaultLocale() {
        UI.setCurrent(null);
        Instantiator instantiator = this.mocks.getService().getInstantiator();
        Mockito.when((Object)instantiator.getI18NProvider()).thenReturn(null);
        TestButton test = new TestButton();
        Locale locale = test.getLocale();
        Assert.assertEquals((String)"System default locale should be returned", (Object)Locale.getDefault(), (Object)locale);
    }

    @Test
    public void getComponentLocale_hasCurrentUI_returnsUILocale() {
        UI ui = new UI();
        ui.setLocale(Locale.CANADA_FRENCH);
        UI.setCurrent((UI)ui);
        TestButton test = new TestButton();
        Locale locale = test.getLocale();
        Assert.assertEquals((String)"Component getLocale returns the UI locale", (Object)Locale.CANADA_FRENCH, (Object)locale);
    }

    @Test
    public void getComponentLocale_noCurrentUI_returnsFirstLocaleFromProvidedLocales() {
        UI.setCurrent(null);
        Instantiator instantiator = this.mocks.getService().getInstantiator();
        final ArrayList<Locale> providedLocales = new ArrayList<Locale>(List.of(Locale.US, Locale.CANADA_FRENCH, Locale.FRANCE));
        providedLocales.remove(Locale.getDefault());
        Mockito.when((Object)instantiator.getI18NProvider()).thenReturn((Object)new I18NProvider(){

            public List<Locale> getProvidedLocales() {
                return providedLocales;
            }

            public String getTranslation(String key, Locale locale, Object ... params) {
                return null;
            }
        });
        TestButton test = new TestButton();
        Locale locale = test.getLocale();
        Assert.assertEquals((String)"First provided locale should be returned", providedLocales.get(0), (Object)locale);
    }

    @Test
    public void getComponentLocale_noCurrentUI_returnsDefaultLocale_ifNoProvidedLocale() {
        UI.setCurrent(null);
        Instantiator instantiator = this.mocks.getService().getInstantiator();
        Mockito.when((Object)instantiator.getI18NProvider()).thenReturn((Object)new I18NProvider(){

            public List<Locale> getProvidedLocales() {
                return List.of();
            }

            public String getTranslation(String key, Locale locale, Object ... params) {
                return null;
            }
        });
        TestButton test = new TestButton();
        Locale locale = test.getLocale();
        Assert.assertEquals((String)"System default locale should be returned", (Object)Locale.getDefault(), (Object)locale);
    }

    @Test
    public void getElement() {
        Assert.assertEquals((Object)"div", (Object)this.divWithTextComponent.getElement().getTag());
        Assert.assertEquals((Object)"Test component", (Object)this.divWithTextComponent.getElement().getTextRecursively());
    }

    @Test
    public void getParentForAttachedComponent() {
        Assert.assertEquals((Object)this.parentDivComponent, this.child1SpanComponent.getParent().get());
        Assert.assertEquals((Object)this.parentDivComponent, this.child2InputComponent.getParent().get());
    }

    @Test
    public void getUIForAttachedComponentInShadowRoot() {
        this.shadowRootParent = new TestComponent(ElementFactory.createDiv());
        this.shadowRootParent.getElement().attachShadow();
        this.shadowChild = new TestComponent(ElementFactory.createSpan());
        ((ShadowRoot)this.shadowRootParent.getElement().getShadowRoot().get()).appendChild(new Element[]{this.shadowChild.getElement()});
        this.testUI = new UI();
        this.testUI.add(new Component[]{this.shadowRootParent});
        Assert.assertEquals((Object)this.testUI, this.shadowChild.getUI().get());
    }

    @Test
    public void getParentForDetachedComponent() {
        Assert.assertFalse((boolean)this.parentDivComponent.getParent().isPresent());
    }

    @Test
    public void defaultGetChildrenDirectlyAttached() {
        ComponentTest.assertChildren(this.parentDivComponent, this.child1SpanComponent, this.child2InputComponent);
    }

    public static void assertChildren(Component parent, Component ... expectedChildren) {
        List children = parent.getChildren().toList();
        Assert.assertArrayEquals((Object[])expectedChildren, (Object[])children.toArray());
        for (Component c : children) {
            Assert.assertEquals(c.getParent().get(), (Object)parent);
        }
    }

    @Test
    public void defaultGetChildrenMultiple() {
        Element level1 = ElementFactory.createDiv((String)"Level1");
        this.parentDivComponent.getElement().appendChild(new Element[]{level1});
        level1.appendChild(new Element[]{this.child1SpanComponent.getElement()});
        level1.appendChild(new Element[]{this.child2InputComponent.getElement()});
        ComponentTest.assertChildren(this.parentDivComponent, this.child1SpanComponent, this.child2InputComponent);
    }

    @Test
    public void defaultGetChildrenDirectlyDeepElementHierarchy() {
        TestComponent parent = new TestComponent(ElementFactory.createDiv());
        TestComponent child1 = new TestComponent(ElementFactory.createDiv((String)"Child1"));
        TestComponent child2 = new TestComponent(ElementFactory.createDiv((String)"Child2"));
        TestComponent child3 = new TestComponent(ElementFactory.createDiv((String)"Child2"));
        Element parentElement = parent.getElement();
        parentElement.appendChild(new Element[]{(Element)new Element("level1").appendChild(new Element[]{(Element)new Element("level2").appendChild(new Element[]{child1.getElement()})}), child2.getElement(), (Element)new Element("level1b").appendChild(new Element[]{child3.getElement()})});
        Assert.assertArrayEquals((Object[])new Component[]{child1, child2, child3}, (Object[])parent.getChildren().toArray());
    }

    @Test
    public void defaultGetChildrenNoChildren() {
        Assert.assertArrayEquals((Object[])new Component[]{this.child1SpanComponent, this.child2InputComponent}, (Object[])this.parentDivComponent.getChildren().toArray());
    }

    @Test(expected=AssertionError.class)
    public void attachBrokenComponent() {
        BrokenComponent c = new BrokenComponent();
        TestComponentContainer tc = new TestComponentContainer();
        tc.add(c);
    }

    @Test
    public void setElement() {
        Component c = new Component(null){};
        Element element = ElementFactory.createDiv();
        Component.setElement((Component)c, (Element)element);
        Assert.assertEquals((Object)c, element.getComponent().get());
        Assert.assertEquals((Object)element, (Object)c.getElement());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setElementNull() {
        Component c = new Component(null){};
        Component.setElement((Component)c, null);
    }

    @Test(expected=IllegalStateException.class)
    public void setElementTwice() {
        Component c = new Component(null){};
        Element element = ElementFactory.createDiv();
        Component.setElement((Component)c, (Element)element);
        Component.setElement((Component)c, (Element)element);
    }

    @Test
    public void createComponentWithTag() {
        TestComponentWithTag component = new TestComponentWithTag();
        Assert.assertEquals((Object)"div", (Object)component.getElement().getTag());
    }

    @Test
    public void createComponentWithInheritedTag() {
        TestComponentWithInheritedTag component = new TestComponentWithInheritedTag();
        Assert.assertEquals((Object)"div", (Object)component.getElement().getTag());
    }

    @Test(expected=IllegalStateException.class)
    public void createComponentWithEmptyTag() {
        new TestComponentWithEmptyTag();
    }

    @Test(expected=IllegalStateException.class)
    public void createComponentWithoutTag() {
        new TestComponentWithoutTag();
    }

    @Test
    public void getUI_noParent() {
        TestComponent c = new TestComponent();
        this.assertEmpty(c.getUI());
    }

    @Test
    public void getUI_detachedParent() {
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child = new TestComponent();
        parent.add(child);
        this.assertEmpty(child.getUI());
    }

    @Test
    public void getUI_attachedToUI() {
        TestComponent child = new TestComponent();
        UI ui = new UI();
        ui.add(new Component[]{child});
        Assert.assertEquals((Object)ui, child.getUI().get());
    }

    @Test
    public void getUI_attachedThroughParent() {
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child = new TestComponent();
        parent.add(child);
        UI ui = new UI();
        ui.add(new Component[]{parent});
        Assert.assertEquals((Object)ui, child.getUI().get());
    }

    private void assertEmpty(Optional<?> optional) {
        Assert.assertEquals((String)("Optional should be empty but is " + String.valueOf(optional)), Optional.empty(), optional);
    }

    @Test
    public void testAttachDetachListeners_parentAttachDetach_childListenersTriggered() {
        UI ui = new UI();
        TestComponentContainer parent = new TestComponentContainer();
        TestComponentContainer child = new TestComponentContainer();
        TestComponent grandChild = new TestComponent();
        child.track();
        Registration attachRegistrationHandle = grandChild.addAttachListener((ComponentEventListener & Serializable)event -> grandChild.getAttachEvents().incrementAndGet());
        Registration detachRegistrationHandle = grandChild.addDetachListener((ComponentEventListener & Serializable)event -> grandChild.getDetachEvents().incrementAndGet());
        parent.add(child);
        child.add(grandChild);
        child.assertAttachEvents(0);
        grandChild.assertAttachEvents(0);
        ui.add(new Component[]{parent});
        child.assertAttachEvents(1);
        grandChild.assertAttachEvents(1);
        child.assertDetachEvents(0);
        grandChild.assertDetachEvents(0);
        ui.remove(new Component[]{parent});
        parent.remove(child);
        child.assertAttachEvents(1);
        grandChild.assertAttachEvents(1);
        child.assertDetachEvents(1);
        grandChild.assertDetachEvents(1);
        ui.add(new Component[]{parent});
        parent.add(child);
        child.assertAttachEvents(2);
        grandChild.assertAttachEvents(2);
        child.assertDetachEvents(1);
        grandChild.assertDetachEvents(1);
        ui.remove(new Component[]{parent});
        child.assertAttachEvents(2);
        grandChild.assertAttachEvents(2);
        child.assertDetachEvents(2);
        grandChild.assertDetachEvents(2);
        attachRegistrationHandle.remove();
        detachRegistrationHandle.remove();
        ui.add(new Component[]{child});
        child.assertAttachEvents(3);
        grandChild.assertAttachEvents(2);
        ui.remove(new Component[]{child});
        child.assertDetachEvents(3);
        grandChild.assertDetachEvents(2);
    }

    @Test
    public void testAttachListener_eventOrder_childFirst() {
        UI ui = new UI();
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child = new TestComponent();
        child.track();
        parent.track();
        child.addAttachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)0L, (long)parent.getAttachEvents().get()));
        parent.addAttachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)1L, (long)child.getAttachEvents().get()));
        parent.add(child);
        child.assertAttachEvents(0);
        parent.assertAttachEvents(0);
        ui.add(new Component[]{parent});
        child.assertAttachEvents(1);
        parent.assertAttachEvents(1);
    }

    @Test
    public void testAttachDetach_children() {
        UI ui = new UI();
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child1 = new TestComponent();
        TestComponent child2 = new TestComponent();
        TestComponent child3 = new TestComponent();
        parent.addAttachListener((ComponentEventListener & Serializable)e -> ui.add(new Component[]{child1, child2, child3}));
        parent.addDetachListener((ComponentEventListener & Serializable)e -> ui.remove(new Component[]{child1, child2, child3}));
        ui.add(new Component[]{parent});
        Assert.assertEquals((long)4L, (long)ui.getChildren().count());
        ui.add(new Component[]{parent});
        Assert.assertEquals((long)4L, (long)ui.getChildren().count());
    }

    @Test
    public void testDetachListener_eventOrder_childFirst() {
        UI ui = new UI();
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child = new TestComponent();
        child.track();
        parent.track();
        child.addDetachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)0L, (long)parent.getDetachEvents().get()));
        parent.addDetachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)1L, (long)child.getDetachEvents().get()));
        parent.add(child);
        ui.add(new Component[]{parent});
        child.assertDetachEvents(0);
        parent.assertDetachEvents(0);
        ui.remove(new Component[]{parent});
        child.assertDetachEvents(1);
        parent.assertDetachEvents(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDetach_failingListeners_allListenersInvokedAndExceptionHandled() {
        final HashSet expectedExceptions = new HashSet();
        HashSet handledExceptions = new HashSet();
        this.session = new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService());
        this.session.setErrorHandler((ErrorHandler & Serializable)event -> handledExceptions.add(event.getThrowable()));
        VaadinSession.setCurrent((VaadinSession)this.session);
        try {
            UI ui = new UI();
            TestComponentContainer parent = new TestComponentContainer(){

                protected void onDetach(DetachEvent detachEvent) {
                    this.getDetachEvents().incrementAndGet();
                    UnsupportedOperationException exception = new UnsupportedOperationException("ON-DETACH-1");
                    expectedExceptions.add(exception);
                    throw exception;
                }
            };
            TestComponent child = new TestComponent(){

                protected void onDetach(DetachEvent detachEvent) {
                    this.getDetachEvents().incrementAndGet();
                    UnsupportedOperationException exception = new UnsupportedOperationException("ON-DETACH-2");
                    expectedExceptions.add(exception);
                    throw exception;
                }
            };
            child.track();
            parent.track();
            child.addDetachListener((ComponentEventListener & Serializable)event -> {
                Component patt0$temp = event.getSource();
                if (patt0$temp instanceof TracksAttachDetach) {
                    TracksAttachDetach track = (TracksAttachDetach)patt0$temp;
                    track.getDetachEvents().incrementAndGet();
                }
                UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-LISTENER-1");
                expectedExceptions.add(exception);
                throw exception;
            });
            parent.addDetachListener((ComponentEventListener & Serializable)event -> {
                Component patt0$temp = event.getSource();
                if (patt0$temp instanceof TracksAttachDetach) {
                    TracksAttachDetach track = (TracksAttachDetach)patt0$temp;
                    track.getDetachEvents().incrementAndGet();
                }
                UnsupportedOperationException exception = new UnsupportedOperationException("DETACH-LISTENER-2");
                expectedExceptions.add(exception);
                throw exception;
            });
            parent.add(child);
            ui.add(new Component[]{parent});
            child.assertDetachEvents(0);
            parent.assertDetachEvents(0);
            ui.remove(new Component[]{parent});
            child.assertDetachEvents(3);
            parent.assertDetachEvents(3);
            Assert.assertEquals(expectedExceptions, handledExceptions);
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    @Test
    public void testAttachDetach_elementMoved_bothEventsTriggered() {
        UI ui = new UI();
        TestComponentContainer parent = new TestComponentContainer();
        TestComponent child = new TestComponent();
        parent.add(child);
        ui.add(new Component[]{parent});
        child.track();
        child.addAttachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)1L, (long)child.getDetachEvents().get()));
        child.addDetachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((long)0L, (long)child.getAttachEvents().get()));
        ui.add(new Component[]{child});
        child.assertAttachEvents(1);
        child.assertDetachEvents(1);
    }

    @Test
    public void testAttachDetachEvent_uiCanBeFound() {
        UI ui = new UI();
        TestComponent testComponent = new TestComponent();
        testComponent.track();
        testComponent.addAttachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((Object)ui, event.getSource().getUI().get()));
        testComponent.addDetachListener((ComponentEventListener & Serializable)event -> Assert.assertEquals((Object)ui, event.getSource().getUI().get()));
        testComponent.assertAttachEvents(0);
        ui.add(new Component[]{testComponent});
        testComponent.assertAttachEvents(1);
        testComponent.assertDetachEvents(0);
        ui.remove(new Component[]{testComponent});
        testComponent.assertDetachEvents(1);
    }

    @Test
    public void testOnAttachOnDetachAndEventsOrder() {
        final ArrayList triggered = new ArrayList();
        Component customComponent = new Component(new Element("div")){

            protected void onAttach(AttachEvent attachEvent) {
                triggered.add("onAttach");
            }

            protected void onDetach(DetachEvent detachEvent) {
                triggered.add("onDetach");
            }
        };
        customComponent.addAttachListener((ComponentEventListener & Serializable)event -> triggered.add("attachEvent"));
        customComponent.addDetachListener((ComponentEventListener & Serializable)event -> triggered.add("detachEvent"));
        UI ui = new UI();
        ui.add(new Component[]{customComponent});
        TestUtil.assertArrays(triggered.toArray(), new String[]{"onAttach", "attachEvent"});
        triggered.clear();
        ui.remove(new Component[]{customComponent});
        TestUtil.assertArrays(triggered.toArray(), new String[]{"onDetach", "detachEvent"});
        TestComponentContainer container = new TestComponentContainer();
        ui.add(new Component[]{customComponent, container});
        triggered.clear();
        container.add(customComponent);
        TestUtil.assertArrays(triggered.toArray(), new String[]{"onDetach", "detachEvent", "onAttach", "attachEvent"});
    }

    @Test
    public void testUIInitialAttach() {
        AtomicBoolean initialAttach = new AtomicBoolean(false);
        UI ui = new UI();
        ui.addAttachListener((ComponentEventListener & Serializable)e -> initialAttach.set(e.isInitialAttach()));
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        this.session = new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService((DeploymentConfiguration)config));
        ui.getInternals().setSession(this.session);
        Assert.assertTrue((boolean)initialAttach.get());
    }

    @Test
    public void testInitialAttach() {
        AtomicBoolean initialAttach = new AtomicBoolean(false);
        TestComponent c = new TestComponent();
        c.addAttachListener((ComponentEventListener & Serializable)e -> initialAttach.set(e.isInitialAttach()));
        UI ui = new UI();
        ui.add(new Component[]{c});
        Assert.assertTrue((boolean)initialAttach.get());
    }

    @Test
    public void testSecondAttach() {
        AtomicBoolean initialAttach = new AtomicBoolean(false);
        TestComponent c = new TestComponent();
        c.addAttachListener((ComponentEventListener & Serializable)e -> initialAttach.set(e.isInitialAttach()));
        UI ui = new UI();
        ui.add(new Component[]{c});
        ui.remove(new Component[]{c});
        ui.add(new Component[]{c});
        Assert.assertFalse((boolean)initialAttach.get());
    }

    @Test
    public void testIsAttached() {
        UI ui = new UI();
        Assert.assertTrue((boolean)ui.isAttached());
        TestComponentContainer parent = new TestComponentContainer();
        TestComponentContainer child = new TestComponentContainer();
        TestComponent grandChild = new TestComponent();
        child.track();
        grandChild.addAttachListener((ComponentEventListener & Serializable)event -> Assert.assertTrue((boolean)grandChild.isAttached()));
        grandChild.addDetachListener((ComponentEventListener & Serializable)event -> grandChild.getDetachEvents().incrementAndGet());
        parent.add(child);
        child.add(grandChild);
        Assert.assertFalse((boolean)parent.isAttached());
        Assert.assertFalse((boolean)child.isAttached());
        Assert.assertFalse((boolean)grandChild.isAttached());
        ui.add(new Component[]{parent});
        Assert.assertTrue((boolean)parent.isAttached());
        Assert.assertTrue((boolean)child.isAttached());
        Assert.assertTrue((boolean)grandChild.isAttached());
        ui.remove(new Component[]{parent});
        Assert.assertFalse((boolean)parent.isAttached());
        Assert.assertFalse((boolean)child.isAttached());
        Assert.assertFalse((boolean)grandChild.isAttached());
        ui.add(new Component[]{parent});
        Assert.assertTrue((boolean)parent.isAttached());
        Assert.assertTrue((boolean)child.isAttached());
        Assert.assertTrue((boolean)grandChild.isAttached());
        ui.getInternals().setSession((VaadinSession)Mockito.mock(VaadinSession.class));
        ui.close();
        ui.getInternals().setSession(null);
        Assert.assertFalse((boolean)parent.isAttached());
        Assert.assertFalse((boolean)child.isAttached());
        Assert.assertFalse((boolean)grandChild.isAttached());
        Assert.assertFalse((boolean)ui.isAttached());
    }

    @Test(expected=IllegalArgumentException.class)
    public void wrapNullComponentType() {
        new Element("div").as(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void wrapWrongTag() {
        Element foo = new Element("foo");
        foo.as(TestDiv.class);
    }

    @Test(expected=IllegalStateException.class)
    public void wrappedComponentGetParent() {
        Element div = new Element("div");
        Element button = new Element("button");
        div.appendChild(new Element[]{button});
        div.as(TestDiv.class);
        ((TestButton)button.as(TestButton.class)).getParent();
    }

    @Test(expected=IllegalStateException.class)
    public void wrappedComponentGetChildren() {
        Element div = new Element("div");
        Element button = new Element("button");
        div.appendChild(new Element[]{button});
        button.as(TestButton.class);
        ((TestDiv)div.as(TestDiv.class)).getChildren();
    }

    @Test
    public void componentFromHierarchy() {
        Element div = new Element("div");
        Element button = new Element("button");
        div.appendChild(new Element[]{button});
        TestDiv testDiv = (TestDiv)Component.from((Element)div, TestDiv.class);
        TestButton testButton = (TestButton)Component.from((Element)button, TestButton.class);
        Assert.assertEquals(testButton.getParent().get(), (Object)((Object)testDiv));
        Assert.assertTrue((boolean)testDiv.getChildren().anyMatch(c -> c == testButton));
    }

    @Test
    public void wrappedComponentUsesElement() {
        Element div = new Element("div");
        div.setAttribute("id", "foo");
        Assert.assertEquals(Optional.of("foo"), (Object)((TestDiv)div.as(TestDiv.class)).getId());
    }

    @Test
    public void wrappedComponentModifyElement() {
        Element div = new Element("div");
        ((TestDiv)div.as(TestDiv.class)).setId("foo");
        Assert.assertEquals((Object)"foo", (Object)div.getAttribute("id"));
    }

    @Test
    public void wrapToExistingComponent() {
        TestButton button = new TestButton();
        TestButton button2 = (TestButton)button.getElement().as(TestButton.class);
        button.setId("id1");
        Assert.assertEquals(Optional.of("id1"), (Object)button2.getId());
        Assert.assertEquals(Optional.of("id1"), (Object)button.getId());
    }

    @Test
    public void wrapDifferentTypeToExistingComponent() {
        TestButton button = new TestButton();
        TestOtherButton button2 = (TestOtherButton)button.getElement().as(TestOtherButton.class);
        button.setId("id1");
        Assert.assertEquals(Optional.of("id1"), (Object)button2.getId());
        Assert.assertEquals(Optional.of("id1"), (Object)button.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mapToExistingComponent() {
        TestButton button = new TestButton();
        Component.from((Element)button.getElement(), TestButton.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void mapToNullComponentType() {
        Component.from((Element)new Element("div"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void mapFromNullElement() {
        Component.from(null, TestButton.class);
    }

    @Test
    public void mapToComponentWhichCreatesComponentInConstructor() {
        Element e = new Element("div");
        TestComponentWhichCreatesComponentInConstructor c = (TestComponentWhichCreatesComponentInConstructor)Component.from((Element)e, TestComponentWhichCreatesComponentInConstructor.class);
        Element buttonElement = c.getElement().getChild(0);
        Assert.assertEquals((Object)e, (Object)c.getElement());
        Assert.assertNotEquals((Object)e, (Object)buttonElement);
        Assert.assertEquals((Object)"button", (Object)buttonElement.getTag());
    }

    @Test
    public void mapToComponentWhichHasComponentField() {
        Element e = new Element("div");
        TestComponentWhichHasComponentField c = (TestComponentWhichHasComponentField)Component.from((Element)e, TestComponentWhichHasComponentField.class);
        Element buttonElement = c.getElement().getChild(0);
        Assert.assertEquals((Object)e, (Object)c.getElement());
        Assert.assertNotEquals((Object)e, (Object)buttonElement);
        Assert.assertEquals((Object)"button", (Object)buttonElement.getTag());
    }

    @Test
    public void mapToComponentWithElementConstructor() {
        Element e = new Element("my-element");
        TestComponentWhichUsesElementConstructor c = (TestComponentWhichUsesElementConstructor)Component.from((Element)e, TestComponentWhichUsesElementConstructor.class);
        Assert.assertSame((Object)e, (Object)c.getElement());
        Assert.assertSame((Object)((Object)c), e.getComponent().get());
    }

    @Test
    public void mapToComponentWithNullElementConstructor() {
        Element e = new Element("div");
        TestComponentWhichUsesNullElementConstructor c = (TestComponentWhichUsesNullElementConstructor)Component.from((Element)e, TestComponentWhichUsesNullElementConstructor.class);
        Assert.assertSame((Object)e, (Object)c.getElement());
        Assert.assertSame((Object)((Object)c), e.getComponent().get());
    }

    private void assertSynchronizedProperties(String domEventName, Element element, String ... properties) {
        Set expected = Stream.of(properties).collect(Collectors.toSet());
        Set expressions = ((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).getExpressions(domEventName);
        Assert.assertEquals(expected, (Object)expressions);
    }

    @Test
    public void synchronizePropertyBasedOnGetterName() {
        SynchronizePropertyOnChangeComponent component = new SynchronizePropertyOnChangeComponent();
        Element element = component.getElement();
        this.assertSynchronizedProperties("change", element, "}foo");
    }

    @Test
    public void synchronizePropertyElementConstructor() {
        SynchronizePropertyUsingElementConstructor component = new SynchronizePropertyUsingElementConstructor();
        component.customInit();
        Element element = component.getElement();
        this.assertSynchronizedProperties("change", element, "}foo");
    }

    @Test
    public void componentMetaDataCached() {
        ComponentUtil.componentMetaDataCache.clear();
        Assert.assertFalse((boolean)ComponentUtil.componentMetaDataCache.contains(Text.class));
        new Text("foobar");
        Assert.assertTrue((boolean)ComponentUtil.componentMetaDataCache.contains(Text.class));
    }

    @Test
    public void synchronizePropertyWithPropertyName() {
        SynchronizePropertyOnChangeGivenPropertyComponent component = new SynchronizePropertyOnChangeGivenPropertyComponent();
        Element element = component.getElement();
        this.assertSynchronizedProperties("change", element, "}bar");
    }

    @Test
    public void synchronizePropertyWithMultipleEvents() {
        SynchronizePropertyOnMultipleEventsComponent component = new SynchronizePropertyOnMultipleEventsComponent();
        Element element = component.getElement();
        this.assertSynchronizedProperties("input", element, "}foo");
        this.assertSynchronizedProperties("blur", element, "}foo");
    }

    @Test(expected=IllegalStateException.class)
    public void synchronizeOnNonGetter() {
        new SynchronizeOnNonGetterComponent();
    }

    @Test
    public void usesComponent() {
        UI ui = UI.getCurrent();
        ui.getInternals().addComponentDependencies(UsesComponentWithDependencies.class);
        Map<String, Dependency> pendingDependencies = this.getDependenciesMap(ui.getInternals().getDependencyList().getPendingSendToClient());
        Assert.assertEquals((long)1L, (long)pendingDependencies.size());
        this.assertDependency(Dependency.Type.STYLESHEET, "css.css", pendingDependencies);
    }

    @Test
    public void usesChain() {
        UIInternals internals = UI.getCurrent().getInternals();
        internals.addComponentDependencies(UsesUsesComponentWithDependencies.class);
        Map<String, Dependency> pendingDependencies = this.getDependenciesMap(internals.getDependencyList().getPendingSendToClient());
        Assert.assertEquals((long)1L, (long)pendingDependencies.size());
        this.assertDependency(Dependency.Type.STYLESHEET, "css.css", pendingDependencies);
    }

    @Test
    public void circularDependencies() {
        UIInternals internals = new MockUI().getInternals();
        DependencyList dependencyList = internals.getDependencyList();
        internals.addComponentDependencies(CircularDependencies1.class);
        Map<String, Dependency> pendingDependencies = this.getDependenciesMap(dependencyList.getPendingSendToClient());
        Assert.assertEquals((long)2L, (long)pendingDependencies.size());
        this.assertDependency(Dependency.Type.STYLESHEET, "css1.css", pendingDependencies);
        this.assertDependency(Dependency.Type.STYLESHEET, "css2.css", pendingDependencies);
        internals = new MockUI().getInternals();
        dependencyList = internals.getDependencyList();
        internals.addComponentDependencies(CircularDependencies2.class);
        pendingDependencies = this.getDependenciesMap(dependencyList.getPendingSendToClient());
        Assert.assertEquals((long)2L, (long)pendingDependencies.size());
        this.assertDependency(Dependency.Type.STYLESHEET, "css1.css", pendingDependencies);
        this.assertDependency(Dependency.Type.STYLESHEET, "css2.css", pendingDependencies);
    }

    public static <T> Map<String, T> filterLazyLoading(Map<String, T> dependenciesMap) {
        dependenciesMap.entrySet().removeIf(entry -> ((String)entry.getKey()).contains("Flow.loadOnDemand"));
        return dependenciesMap;
    }

    @Test
    public void noJsDependenciesAreAdded() {
        UIInternals internals = new MockUI().getInternals();
        DependencyList dependencyList = internals.getDependencyList();
        internals.addComponentDependencies(ComponentWithDependencies.class);
        Map<String, Dependency> pendingDependencies = this.getDependenciesMap(dependencyList.getPendingSendToClient());
        Assert.assertEquals((long)1L, (long)pendingDependencies.size());
        this.assertDependency(Dependency.Type.STYLESHEET, "css.css", pendingDependencies);
    }

    @Test
    public void declarativeSyncProperties_propertiesAreRegisteredWithProperDisabledUpdateMode() {
        TestDiv div = new TestDiv();
        ElementListenerMap feature = (ElementListenerMap)div.getElement().getNode().getFeature(ElementListenerMap.class);
        Set props = feature.getExpressions("bar");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertTrue((boolean)props.contains("}baz"));
        Assert.assertEquals((Object)DisabledUpdateMode.ALWAYS, (Object)feature.getPropertySynchronizationMode("baz"));
        props = feature.getExpressions("foo");
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertTrue((boolean)props.contains("}bar"));
        Assert.assertEquals((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)feature.getPropertySynchronizationMode("bar"));
    }

    @Test
    public void enabledComponent_fireDomEvent_listenerReceivesEvent() {
        TestDiv div = new TestDiv();
        AtomicInteger count = new AtomicInteger();
        div.addListener(TestDomEvent.class, (ComponentEventListener & Serializable)vent -> count.incrementAndGet());
        ((ElementListenerMap)div.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(this.createEvent("foo", div));
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void disabledComponent_fireDomEvent_listenerDoesntReceivesEvent() {
        TestDiv div = new TestDiv();
        div.getElement().setEnabled(false);
        AtomicInteger count = new AtomicInteger();
        div.addListener(TestDomEvent.class, (ComponentEventListener & Serializable)vent -> count.incrementAndGet());
        ((ElementListenerMap)div.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(this.createEvent("foo", div));
        Assert.assertEquals((long)0L, (long)count.get());
    }

    @Test
    public void implicityDisabledComponent_fireDomEvent_listenerDoesntReceivesEvent() {
        TestDiv div = new TestDiv();
        UI ui = new UI();
        ui.add(new Component[]{div});
        ui.setEnabled(false);
        AtomicInteger count = new AtomicInteger();
        div.addListener(TestDomEvent.class, (ComponentEventListener & Serializable)event -> count.incrementAndGet());
        ((ElementListenerMap)div.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(this.createEvent("foo", div));
        Assert.assertEquals((long)0L, (long)count.get());
    }

    @Test
    public void disabledComponent_fireAlwaysEnabledDomEvent_listenerReceivesEvent() {
        TestDiv div = new TestDiv();
        div.getElement().setEnabled(false);
        AtomicInteger count = new AtomicInteger();
        div.addListener(EnabledDomEvent.class, (ComponentEventListener & Serializable)event -> count.incrementAndGet());
        ((ElementListenerMap)div.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(this.createEvent("foo", div));
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void removeOnRegistration_registrationIsIdempotent() {
        TestDiv div = new TestDiv();
        Registration registration = div.addListener(ComponentEvent.class, (ComponentEventListener & Serializable)event -> {});
        registration.remove();
        registration.remove();
    }

    private com.vaadin.flow.dom.DomEvent createEvent(String type, Component component) {
        return new com.vaadin.flow.dom.DomEvent(component.getElement(), type, (JsonNode)JacksonUtils.createObjectNode());
    }

    private void assertDependency(Dependency.Type type, String url, Map<String, Dependency> pendingDependencies) {
        Dependency dependency = pendingDependencies.get(url);
        Assert.assertNotNull((String)("Could not locate a dependency object for url=" + url), (Object)dependency);
        Assert.assertEquals((Object)type, (Object)dependency.getType());
        Assert.assertEquals((Object)url, (Object)dependency.getUrl());
    }

    private Map<String, Dependency> getDependenciesMap(Collection<Dependency> dependencies) {
        return ComponentTest.filterLazyLoading(dependencies.stream().collect(Collectors.toMap(Dependency::getUrl, Function.identity())));
    }

    @Test
    public void enabledStateChangeOnAttachCalledForParentState() {
        this.enabledStateChangeOnAttachCalledForParentState(false, (rec$, xva$0) -> ((HasComponents)rec$).add(new Component[]{xva$0}));
    }

    @Test
    public void enabledStateChangeOnDisableParent() {
        this.enabledStateChangeOnAttachCalledForParentState(true, (parent, child) -> {
            parent.add(new Component[]{child});
            parent.setEnabled(false);
        });
    }

    @Test
    public void enabledStateChangeOnAttachCalledForParentOfVirtualChildState() {
        this.enabledStateChangeOnAttachCalledForParentState(false, (parent, child) -> {
            Element wrapper = ElementFactory.createAnchor();
            parent.getElement().appendVirtualChild(new Element[]{wrapper});
            wrapper.appendChild(new Element[]{child.getElement()});
        });
    }

    @Test
    public void enabledStateChangeOnDisableParentOfVirtualChild() {
        this.enabledStateChangeOnAttachCalledForParentState(true, (parent, child) -> {
            Element wrapper = ElementFactory.createAnchor();
            parent.getElement().appendVirtualChild(new Element[]{wrapper});
            wrapper.appendChild(new Element[]{child.getElement()});
            parent.setEnabled(false);
        });
    }

    @Test
    public void enabledStateChangeOnDetachReturnsOldState() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(false);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        parent.add(new Component[]{child});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        parent.remove(new Component[]{child});
        Assert.assertTrue((String)"After detach child should be enabled", (boolean)child.isEnabled());
        Assert.assertTrue((String)"Enable event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
    }

    @Test
    public void enabledStateChangeOnParentDetachReturnsOldState() {
        this.enabledStateChangeOnParentDetachReturnsOldState((rec$, xva$0) -> ((HasComponents)rec$).add(new Component[]{xva$0}));
    }

    @Test
    public void enabledStateChangeOnParentOfVirtualChildDetachReturnsOldState() {
        this.enabledStateChangeOnParentDetachReturnsOldState((parent, child) -> {
            Element wrapper = ElementFactory.createAnchor();
            parent.getElement().appendVirtualChild(new Element[]{wrapper});
            wrapper.appendChild(new Element[]{child.getElement()});
        });
    }

    @Test
    public void enabledStateChangeOnDetachChildKeepsDisabledState() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(false);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        child.setEnabled(false);
        stateChange.set(null);
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertFalse((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        parent.add(new Component[]{child});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertNull((String)"No change event should have fired", stateChange.get());
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        parent.remove(new Component[]{child});
        Assert.assertFalse((String)"After detach child should still be disabled", (boolean)child.isEnabled());
        Assert.assertNull((String)"No change event should have fired", stateChange.get());
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
    }

    @Test
    public void enabledStateChangeOnAttachAndDetachChildAndGrandChildrenAreNotified() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(false);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        final AtomicReference grandStateChange = new AtomicReference();
        EnabledDiv grandChild = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                grandStateChange.set(enabled);
            }
        };
        child.add(new Component[]{grandChild});
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertTrue((String)"GrandChild should be enabled.", (boolean)grandChild.isEnabled());
        Assert.assertNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.add(new Component[]{child});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"After attach GrandChild should be disabled", (boolean)grandChild.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)grandStateChange.get()));
        Assert.assertNotNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.remove(new Component[]{child});
        Assert.assertTrue((String)"After detach child should be enabled", (boolean)child.isEnabled());
        Assert.assertTrue((String)"Enable event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertTrue((String)"After detach GrandChild should be enabled", (boolean)grandChild.isEnabled());
        Assert.assertTrue((String)"GrandChild should have gotten true event", (boolean)((Boolean)grandStateChange.get()));
        Assert.assertNull((Object)grandChild.getElement().getAttribute("disabled"));
    }

    @Test
    public void enabledStateChangeOnAttachAndDetachDisabledChildAndGrandChildAreDisabled() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(false);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        child.setEnabled(false);
        stateChange.set(null);
        final AtomicReference grandStateChange = new AtomicReference();
        EnabledDiv grandChild = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                grandStateChange.set(enabled);
            }
        };
        child.add(new Component[]{grandChild});
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertFalse((String)"Child should be disabled.", (boolean)child.isEnabled());
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"GrandChild should be disabled.", (boolean)grandChild.isEnabled());
        Assert.assertNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.add(new Component[]{child});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertNull((String)"Disabled event should have triggered", stateChange.get());
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"After attach GrandChild should be disabled", (boolean)grandChild.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)grandStateChange.get()));
        Assert.assertNotNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.remove(new Component[]{child});
        Assert.assertFalse((String)"After detach child should be disabled", (boolean)child.isEnabled());
        Assert.assertNull((String)"No change event should have been sent", stateChange.get());
        Assert.assertFalse((String)"After detach GrandChild should be disabled", (boolean)grandChild.isEnabled());
        Assert.assertFalse((String)"Latest state change should have been disabled", (boolean)((Boolean)grandStateChange.get()));
    }

    @Test
    public void enabledStateChangeOnAttachAndDetachDisabledGrandChildAreDisabled() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(false);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        final AtomicReference grandStateChange = new AtomicReference();
        EnabledDiv grandChild = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                grandStateChange.set(enabled);
            }
        };
        grandChild.setEnabled(false);
        child.add(new Component[]{grandChild});
        Assert.assertFalse((String)"Parent should be disabled", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"GrandChild should be disabled.", (boolean)grandChild.isEnabled());
        Assert.assertNotNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.add(new Component[]{child});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"After attach GrandChild should be disabled", (boolean)grandChild.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)grandStateChange.get()));
        Assert.assertNotNull((Object)grandChild.getElement().getAttribute("disabled"));
        parent.remove(new Component[]{child});
        Assert.assertTrue((String)"After detach child should be enabled", (boolean)child.isEnabled());
        Assert.assertTrue((String)"Enable event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        Assert.assertFalse((String)"After detach GrandChild should be disabled", (boolean)grandChild.isEnabled());
        Assert.assertFalse((String)"Latest state change should have been disabled", (boolean)((Boolean)grandStateChange.get()));
        Assert.assertNotNull((Object)grandChild.getElement().getAttribute("disabled"));
    }

    @Test
    public void enabledPassesThroughAllChildensChildrenAndAttributeShouldBeSet() {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        EnabledDiv child = new EnabledDiv();
        EnabledDiv subChild = new EnabledDiv();
        EnabledDiv subSubChild = new EnabledDiv();
        parent.add(new Component[]{child});
        child.add(new Component[]{subChild});
        subChild.add(new Component[]{subSubChild});
        ui.add(new Component[]{parent});
        Assert.assertTrue((String)"Parent should be enabled.", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertTrue((String)"SubChild should be enabled.", (boolean)subChild.isEnabled());
        Assert.assertTrue((String)"SubsubChild should be enabled.", (boolean)subSubChild.isEnabled());
        Assert.assertNull((String)"No disabled attribute should not exist for parent", (Object)parent.getElement().getAttribute("disabled"));
        Assert.assertNull((String)"No disabled attribute should not exist for child", (Object)child.getElement().getAttribute("disabled"));
        Assert.assertNull((String)"No disabled attribute should not exist for subChild", (Object)subChild.getElement().getAttribute("disabled"));
        Assert.assertNull((String)"No disabled attribute should not exist for subSubChild", (Object)subSubChild.getElement().getAttribute("disabled"));
        parent.setEnabled(false);
        Assert.assertFalse((String)"Parent should be disabled.", (boolean)parent.isEnabled());
        Assert.assertFalse((String)"Child should be disabled.", (boolean)child.isEnabled());
        Assert.assertFalse((String)"SubChild should be disabled.", (boolean)subChild.isEnabled());
        Assert.assertFalse((String)"SubsubChild should be disabled.", (boolean)subSubChild.isEnabled());
        Assert.assertNotNull((String)"Disabled attribute should exist for parent", (Object)parent.getElement().getAttribute("disabled"));
        Assert.assertNotNull((String)"Disabled attribute should exist for child", (Object)child.getElement().getAttribute("disabled"));
        Assert.assertNotNull((String)"Disabled attribute should exist for subChild", (Object)subChild.getElement().getAttribute("disabled"));
        Assert.assertNotNull((String)"Disabled attribute should exist for subSubChild", (Object)subSubChild.getElement().getAttribute("disabled"));
    }

    @Test(expected=IllegalStateException.class)
    public void add_componentIsAttachedToAnotherUI_throwsIllegalStateException() {
        TestComponent child = new TestComponent();
        UI ui1 = new UI();
        ui1.add(new Component[]{child});
        UI ui2 = new UI();
        ui2.add(new Component[]{child});
    }

    @Test
    public void findAncestorTest() {
        UI ui = new UI();
        TestComponentContainer componentContainer = new TestComponentContainer();
        TestComponent component = new TestComponent();
        componentContainer.add(component);
        ui.add(new Component[]{componentContainer});
        Assert.assertEquals((Object)componentContainer, (Object)component.findAncestor(TestComponentContainer.class));
        Assert.assertEquals((Object)ui, (Object)component.findAncestor(UI.class));
        Assert.assertEquals((Object)ui, (Object)component.findAncestor(PollNotifier.class));
        Assert.assertNull((Object)component.findAncestor(TestButton.class));
    }

    @Test
    public void removeFromParentTest() {
        UI ui = new UI();
        TestComponentContainer componentContainer = new TestComponentContainer();
        TestComponent component = new TestComponent();
        componentContainer.add(component);
        ui.add(new Component[]{componentContainer});
        Assert.assertEquals((Object)componentContainer, component.getParent().get());
        Assert.assertEquals((long)1L, (long)componentContainer.getChildren().count());
        Assert.assertEquals((Object)ui, componentContainer.getParent().get());
        Assert.assertEquals((long)1L, (long)ui.getChildren().count());
        component.removeFromParent();
        Assert.assertTrue((boolean)component.getParent().isEmpty());
        Assert.assertEquals((long)0L, (long)componentContainer.getChildren().count());
        componentContainer.removeFromParent();
        Assert.assertTrue((boolean)componentContainer.getParent().isEmpty());
        Assert.assertEquals((long)0L, (long)ui.getChildren().count());
    }

    private void enabledStateChangeOnAttachCalledForParentState(boolean initiallyEnabled, BiConsumer<EnabledDiv, Component> modificationStartegy) {
        UI ui = new UI();
        EnabledDiv parent = new EnabledDiv();
        parent.setEnabled(initiallyEnabled);
        ui.add(new Component[]{parent});
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                Assert.assertTrue((String)"Expected empty state for enabled change", (boolean)stateChange.compareAndSet(null, enabled));
            }
        };
        Assert.assertEquals((String)"Parent should be disabled", (Object)initiallyEnabled, (Object)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        modificationStartegy.accept(parent, child);
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
    }

    private void enabledStateChangeOnParentDetachReturnsOldState(BiConsumer<EnabledDiv, Component> modificationStartegy) {
        UI ui = new UI();
        EnabledDiv grandParent = new EnabledDiv();
        grandParent.setEnabled(false);
        ui.add(new Component[]{grandParent});
        EnabledDiv parent = new EnabledDiv();
        final AtomicReference stateChange = new AtomicReference();
        EnabledDiv child = new EnabledDiv(){

            public void onEnabledStateChanged(boolean enabled) {
                super.onEnabledStateChanged(enabled);
                stateChange.set(enabled);
            }
        };
        Assert.assertTrue((String)"Parent should be enabled", (boolean)parent.isEnabled());
        Assert.assertTrue((String)"Child should be enabled.", (boolean)child.isEnabled());
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
        modificationStartegy.accept(parent, child);
        grandParent.add(new Component[]{parent});
        Assert.assertFalse((String)"After attach child should be disabled", (boolean)child.isEnabled());
        Assert.assertFalse((String)"Disabled event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNotNull((Object)child.getElement().getAttribute("disabled"));
        grandParent.remove(new Component[]{parent});
        Assert.assertTrue((String)"After detach child should be enabled", (boolean)child.isEnabled());
        Assert.assertTrue((String)"Enable event should have triggered", (boolean)((Boolean)stateChange.get()));
        Assert.assertNull((Object)child.getElement().getAttribute("disabled"));
    }

    @Test
    public void scrollIntoView() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollIntoViewOption[0]);
        this.assertPendingJs("scrollIntoView()");
    }

    private void assertPendingJs(String expectedJs) {
        this.testUI.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List pendingJs = this.testUI.getInternals().dumpPendingJavaScriptInvocations();
        Assert.assertEquals((long)1L, (long)pendingJs.size());
        UIInternals.JavaScriptInvocation inv = ((PendingJavaScriptInvocation)pendingJs.get(0)).getInvocation();
        MatcherAssert.assertThat((Object)inv.getExpression(), (Matcher)CoreMatchers.containsString((String)expectedJs));
    }

    @Test
    public void scrollIntoViewSmooth() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollOptions(ScrollOptions.Behavior.SMOOTH));
        this.assertPendingJs("scrollIntoView({\"behavior\":\"smooth\"})");
    }

    @Test
    public void scrollIntoViewAllParams() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollOptions(ScrollOptions.Behavior.SMOOTH, ScrollOptions.Alignment.END, ScrollOptions.Alignment.CENTER));
        this.assertPendingJs("scrollIntoView({\"behavior\":\"smooth\",\"block\":\"end\",\"inline\":\"center\"})");
    }

    @Test
    public void scrollIntoView_withBehaviorEnum() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollIntoViewOption[]{ScrollIntoViewOption.Behavior.SMOOTH});
        this.assertScrollIntoViewWithParams("\"behavior\":\"smooth\"");
    }

    @Test
    public void scrollIntoView_withBlockEnum() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollIntoViewOption[]{ScrollIntoViewOption.Block.END});
        this.assertScrollIntoViewWithParams("\"block\":\"end\"");
    }

    @Test
    public void scrollIntoView_withInlineEnum() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollIntoViewOption[]{ScrollIntoViewOption.Inline.CENTER});
        this.assertScrollIntoViewWithParams("\"inline\":\"center\"");
    }

    @Test
    public void scrollIntoView_withMultipleOptions() {
        EnabledDiv div = new EnabledDiv();
        this.testUI.add(new Component[]{div});
        div.scrollIntoView(new ScrollIntoViewOption[]{ScrollIntoViewOption.Behavior.SMOOTH, ScrollIntoViewOption.Block.END, ScrollIntoViewOption.Inline.CENTER});
        this.assertScrollIntoViewWithParams("\"behavior\":\"smooth\"", "\"block\":\"end\"", "\"inline\":\"center\"");
    }

    private void assertScrollIntoViewWithParams(String ... expectedJsonParts) {
        this.testUI.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        List pendingJs = this.testUI.getInternals().dumpPendingJavaScriptInvocations();
        Assert.assertEquals((long)1L, (long)pendingJs.size());
        UIInternals.JavaScriptInvocation inv = ((PendingJavaScriptInvocation)pendingJs.get(0)).getInvocation();
        String expression = inv.getExpression();
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.containsString((String)"$0.scrollIntoView($1)"));
        List params = inv.getParameters();
        Assert.assertTrue((String)"Should have at least 2 parameters", (params.size() >= 2 ? 1 : 0) != 0);
        String paramJson = params.get(1).toString();
        for (String expectedPart : expectedJsonParts) {
            MatcherAssert.assertThat((Object)paramJson, (Matcher)CoreMatchers.containsString((String)expectedPart));
        }
    }

    @Test
    public void cannotMoveComponentsToOtherUI() {
        UI otherUI = this.createMockedUI();
        TestButton button = new TestButton();
        otherUI.add(new Component[]{button});
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.testUI.add(new Component[]{button}));
        Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().startsWith("Can't move a node from one state tree to another. If this is intentional, first remove the node from its current state tree by calling removeFromTree. This usually happens when a component is moved from one UI to another, which is not recommended. This may be caused by assigning components to static members or spring singleton scoped beans and referencing them from multiple UIs. Offending component: com.vaadin.flow.component.ComponentTest$TestButton@"));
    }

    private void resetComponentTrackerProductionMode() throws Exception {
        Field disabled = ComponentTracker.class.getDeclaredField("disabled");
        disabled.setAccessible(true);
        disabled.set(null, null);
        disabled.setAccessible(false);
    }

    public static class TestComponent
    extends TracksAttachDetachComponent {
        public TestComponent() {
            this(ElementFactory.createDiv());
        }

        public TestComponent(Element element) {
            super(element);
        }

        public String toString() {
            return this.getElement().getText();
        }

        public void fireEvent(ComponentEvent<?> componentEvent) {
            super.fireEvent(componentEvent);
        }

        public <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener) {
            return super.addListener(eventType, listener);
        }

        public ComponentEventBus getEventBus() {
            return super.getEventBus();
        }
    }

    @Tag(value="button")
    public static class TestButton
    extends Component {
    }

    private static class BrokenComponent
    extends Component {
        public BrokenComponent() {
            super(null);
        }
    }

    static class TestComponentContainer
    extends TestComponent {
        TestComponentContainer() {
        }

        public void add(Component c) {
            this.getElement().appendChild(new Element[]{c.getElement()});
        }

        public void remove(Component c) {
            this.getElement().removeChild(new Element[]{c.getElement()});
        }
    }

    @Tag(value="div")
    private static class TestComponentWithTag
    extends Component {
        private TestComponentWithTag() {
        }
    }

    private static class TestComponentWithInheritedTag
    extends TestComponentWithTag {
        private TestComponentWithInheritedTag() {
        }
    }

    @Tag(value="")
    private static class TestComponentWithEmptyTag
    extends Component {
        private TestComponentWithEmptyTag() {
        }
    }

    private static class TestComponentWithoutTag
    extends Component {
        private TestComponentWithoutTag() {
        }
    }

    @Tag(value="div")
    public static class TestDiv
    extends Component {
        @Synchronize(value={"bar"}, property="baz", allowUpdates=DisabledUpdateMode.ALWAYS)
        public String getFoo() {
            return null;
        }

        @Synchronize(value={"foo"}, property="bar")
        public String getBaz() {
            return null;
        }
    }

    @Tag(value="button")
    public static class TestOtherButton
    extends Component {
    }

    @Tag(value="div")
    public static class TestComponentWhichCreatesComponentInConstructor
    extends Component {
        public TestComponentWhichCreatesComponentInConstructor() {
            this.getElement().appendChild(new Element[]{new TestButton().getElement()});
        }
    }

    @Tag(value="div")
    public static class TestComponentWhichHasComponentField
    extends Component {
        private TestButton button = new TestButton();

        public TestComponentWhichHasComponentField() {
            this.getElement().appendChild(new Element[]{this.button.getElement()});
        }
    }

    public static class TestComponentWhichUsesElementConstructor
    extends Component {
        public TestComponentWhichUsesElementConstructor() {
            super(new Element("my-element"));
        }
    }

    public static class TestComponentWhichUsesNullElementConstructor
    extends Component {
        public TestComponentWhichUsesNullElementConstructor() {
            super(null);
        }
    }

    @Tag(value="div")
    public static class SynchronizePropertyOnChangeComponent
    extends Component {
        @Synchronize(value={"change"})
        public String getFoo() {
            return "";
        }
    }

    public static class SynchronizePropertyUsingElementConstructor
    extends Component {
        public SynchronizePropertyUsingElementConstructor() {
            super(null);
        }

        @Synchronize(value={"change"})
        public String getFoo() {
            return "";
        }

        public void customInit() {
            SynchronizePropertyUsingElementConstructor.setElement((Component)this, (Element)new Element("Span"));
        }
    }

    @Tag(value="div")
    public static class SynchronizePropertyOnChangeGivenPropertyComponent
    extends Component {
        @Synchronize(value={"change"}, property="bar")
        public String getFoo() {
            return "";
        }
    }

    @Tag(value="div")
    public static class SynchronizePropertyOnMultipleEventsComponent
    extends Component {
        @Synchronize(value={"input", "blur"})
        public String getFoo() {
            return "";
        }
    }

    @Tag(value="div")
    public static class SynchronizeOnNonGetterComponent
    extends Component {
        @Synchronize(value={"change"})
        public String doWork() {
            return "";
        }
    }

    @Tag(value="span")
    @Uses(value=ComponentWithDependencies.class)
    @JavaScript(value="uses.js")
    public static class UsesComponentWithDependencies
    extends Component {
    }

    @Tag(value="span")
    @Uses(value=UsesComponentWithDependencies.class)
    public static class UsesUsesComponentWithDependencies
    extends Component {
    }

    @Tag(value="div")
    @StyleSheet(value="css1.css")
    @Uses(value=CircularDependencies2.class)
    public static class CircularDependencies1
    extends Component {
    }

    @Tag(value="div")
    @StyleSheet(value="css2.css")
    @Uses(value=CircularDependencies1.class)
    public static class CircularDependencies2
    extends Component {
    }

    @Tag(value="div")
    @JavaScript(value="js.js")
    @StyleSheet(value="css.css")
    public static class ComponentWithDependencies
    extends Component {
    }

    @DomEvent(value="foo")
    public static class TestDomEvent
    extends ComponentEvent<Component> {
        public TestDomEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="foo", allowUpdates=DisabledUpdateMode.ALWAYS)
    public static class EnabledDomEvent
    extends ComponentEvent<Component> {
        public EnabledDomEvent(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @Tag(value="div")
    public static class EnabledDiv
    extends Component
    implements HasComponents {
    }

    public static interface TracksAttachDetach {
        default public void track() {
            if (!(this instanceof Component)) {
                throw new IllegalStateException("Cannot track a non-component");
            }
            ((Component)this).addAttachListener((ComponentEventListener & Serializable)event -> this.getAttachEvents().incrementAndGet());
            ((Component)this).addDetachListener((ComponentEventListener & Serializable)event -> this.getDetachEvents().incrementAndGet());
        }

        public AtomicInteger getAttachEvents();

        public AtomicInteger getDetachEvents();

        default public void assertAttachEvents(int attachEvents) {
            Assert.assertEquals((long)attachEvents, (long)this.getAttachEvents().get());
        }

        default public void assertDetachEvents(int detachEvents) {
            Assert.assertEquals((long)detachEvents, (long)this.getDetachEvents().get());
        }
    }

    public static abstract class TracksAttachDetachComponent
    extends Component
    implements TracksAttachDetach {
        private AtomicInteger attachEvents = new AtomicInteger();
        private AtomicInteger detachEvents = new AtomicInteger();

        public TracksAttachDetachComponent() {
        }

        public TracksAttachDetachComponent(Element element) {
            super(element);
        }

        @Override
        public AtomicInteger getAttachEvents() {
            return this.attachEvents;
        }

        @Override
        public AtomicInteger getDetachEvents() {
            return this.detachEvents;
        }
    }
}

