/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.router.RoutingTestBase;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

@NotThreadSafe
public class RouterConfigurationUrlResolvingTest
extends RoutingTestBase {
    private RouteConfiguration routeConfiguration;
    private UI ui;
    private VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
    private DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Override
    @Before
    public void init() throws NoSuchFieldException, IllegalAccessException {
        super.init();
        this.ui = new RoutingTestBase.RouterTestMockUI(this.router);
        this.ui.getSession().lock();
        VaadinService.setCurrent((VaadinService)this.service);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)this.service.getRouter()).thenReturn((Object)this.router);
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)true);
        this.routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.router.getRegistry());
    }

    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    private void setNavigationTargets(Class<? extends Component> ... navigationTargets) throws InvalidRouteConfigurationException {
        this.routeConfiguration.update((Command & Serializable)() -> {
            this.routeConfiguration.getHandledRegistry().clean();
            Arrays.asList(navigationTargets).forEach(arg_0 -> ((RouteConfiguration)this.routeConfiguration).setAnnotatedRoute(arg_0));
        });
    }

    @Test
    public void basic_url_resolving() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.RootNavigationTarget.class, RoutingTestBase.FooNavigationTarget.class, RoutingTestBase.FooBarNavigationTarget.class);
        Assert.assertEquals((Object)"", (Object)this.routeConfiguration.getUrl(RoutingTestBase.RootNavigationTarget.class));
        Assert.assertEquals((Object)"foo", (Object)this.routeConfiguration.getUrl(RoutingTestBase.FooNavigationTarget.class));
        Assert.assertEquals((Object)"foo/bar", (Object)this.routeConfiguration.getUrl(RoutingTestBase.FooBarNavigationTarget.class));
    }

    @Test
    public void nested_layouts_url_resolving() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteChild.class, LoneRoute.class);
        Assert.assertEquals((Object)"parent/child", (Object)this.routeConfiguration.getUrl(RouteChild.class));
        Assert.assertEquals((Object)"single", (Object)this.routeConfiguration.getUrl(LoneRoute.class));
    }

    @Test
    public void layout_with_url_parameter_url_resolving() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RoutingTestBase.GreetingNavigationTarget.class, RoutingTestBase.OtherGreetingNavigationTarget.class);
        Assert.assertEquals((Object)"greeting/my_param", (Object)this.routeConfiguration.getUrl(RoutingTestBase.GreetingNavigationTarget.class, (Object)"my_param"));
        Assert.assertEquals((Object)"greeting/true", (Object)this.routeConfiguration.getUrl(RoutingTestBase.GreetingNavigationTarget.class, (Object)"true"));
        Assert.assertEquals((Object)"greeting/other", (Object)this.routeConfiguration.getUrl(RoutingTestBase.GreetingNavigationTarget.class, (Object)"other"));
    }

    @Test
    public void url_resolves_correctly_for_optional_and_wild_parameters() throws InvalidRouteConfigurationException, NotFoundException {
        this.setNavigationTargets(OptionalParameter.class, WildParameter.class);
        Assert.assertEquals((String)"Optional value should be able to return even without any parameters", (Object)"optional", (Object)this.routeConfiguration.getUrl(OptionalParameter.class));
        Assert.assertEquals((String)"Wildcard value should be able to return even without any parameters", (Object)"wild", (Object)this.routeConfiguration.getUrl(WildParameter.class));
        Assert.assertEquals((Object)"optional/my_param", (Object)this.routeConfiguration.getUrl(OptionalParameter.class, (Object)"my_param"));
        Assert.assertEquals((Object)"wild/true", (Object)this.routeConfiguration.getUrl(WildParameter.class, (Object)"true"));
        Assert.assertEquals((Object)"wild/there/are/many/of/us", (Object)this.routeConfiguration.getUrl(WildParameter.class, (Object)"there/are/many/of/us"));
    }

    @Test
    public void wildcardPathWithEmptyParameter_emptyParameterIsAvailable() {
        WildParameter.events.clear();
        WildParameter.param = null;
        this.setNavigationTargets(WildParameter.class);
        this.router.navigate(this.ui, new Location("wild//two/three"), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((Object)"/two/three", (Object)WildParameter.param);
        this.router.navigate(this.ui, new Location("wild////four/five"), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((Object)"///four/five", (Object)WildParameter.param);
        this.router.navigate(this.ui, new Location("wild//two//four"), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((Object)"/two//four", (Object)WildParameter.param);
    }

    @Test
    public void root_navigation_target_with_wildcard_parameter() throws InvalidRouteConfigurationException {
        WildRootParameter.events.clear();
        WildRootParameter.param = null;
        this.setNavigationTargets(WildRootParameter.class);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)WildRootParameter.events.size());
        Assert.assertEquals((String)"Parameter should be empty", (Object)"", (Object)WildRootParameter.param);
        this.router.navigate(this.ui, new Location("my/wild"), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)2L, (long)WildRootParameter.events.size());
        Assert.assertEquals((String)"Parameter should be empty", (Object)"my/wild", (Object)WildRootParameter.param);
        Assert.assertEquals((Object)"", (Object)this.routeConfiguration.getUrl(WildRootParameter.class));
        Assert.assertEquals((Object)"wild", (Object)this.routeConfiguration.getUrl(WildRootParameter.class, (Object)"wild"));
        List<String> params = Arrays.asList("", null);
        Assert.assertEquals((Object)"", (Object)this.routeConfiguration.getUrl(WildRootParameter.class, (Object)params.get(1)));
    }

    @Test
    public void root_navigation_target_with_optional_parameter() throws InvalidRouteConfigurationException {
        OptionalRootParameter.events.clear();
        OptionalRootParameter.param = null;
        this.setNavigationTargets(OptionalRootParameter.class);
        this.router.navigate(this.ui, new Location(""), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)1L, (long)OptionalRootParameter.events.size());
        Assert.assertNull((String)"Parameter should be empty", (Object)OptionalRootParameter.param);
        this.router.navigate(this.ui, new Location("optional"), NavigationTrigger.PROGRAMMATIC);
        Assert.assertEquals((String)"Expected event amount was wrong", (long)2L, (long)OptionalRootParameter.events.size());
        Assert.assertEquals((String)"Parameter should be empty", (Object)"optional", (Object)OptionalRootParameter.param);
        Assert.assertEquals((Object)"", (Object)this.routeConfiguration.getUrl(OptionalRootParameter.class));
        Assert.assertEquals((Object)"optional", (Object)this.routeConfiguration.getUrl(OptionalRootParameter.class, (Object)"optional"));
        List<String> params = Arrays.asList("", null);
        Assert.assertEquals((Object)"", (Object)this.routeConfiguration.getUrl(OptionalRootParameter.class, (Object)params.get(1)));
    }

    @Test
    public void getUrl_for_has_url_with_supported_parameters() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(IntegerParameter.class, LongParameter.class, BooleanParameter.class);
        Assert.assertEquals((Object)"integer/5", (Object)this.routeConfiguration.getUrl(IntegerParameter.class, (Object)5));
        Assert.assertEquals((Object)"long/5", (Object)this.routeConfiguration.getUrl(LongParameter.class, (Object)5L));
        Assert.assertEquals((Object)"boolean/false", (Object)this.routeConfiguration.getUrl(BooleanParameter.class, (Object)false));
    }

    @Test
    public void getUrl_throws_for_required_parameter() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage(String.format("Navigation target '%s' requires a parameter.", RouteWithParameter.class.getName()));
        this.setNavigationTargets(RouteWithParameter.class);
        this.routeConfiguration.getUrl(RouteWithParameter.class);
    }

    @Test
    public void getUrl_returns_url_if_parameter_is_wildcard_or_optional() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteWithMultipleParameters.class, OptionalParameter.class);
        String url = this.routeConfiguration.getUrl(RouteWithMultipleParameters.class);
        Assert.assertEquals((String)"Returned url didn't match Wildcard parameter", (Object)RouteWithMultipleParameters.class.getAnnotation(Route.class).value(), (Object)url);
        url = this.routeConfiguration.getUrl(OptionalParameter.class);
        Assert.assertEquals((String)"Returned url didn't match Optional parameter", (Object)OptionalParameter.class.getAnnotation(Route.class).value(), (Object)url);
    }

    @Test
    public void getUrlBase_returns_url_without_parameter_even_for_required_parameters() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteWithParameter.class, RouteWithMultipleParameters.class, OptionalParameter.class, RoutingTestBase.FooNavigationTarget.class);
        Assert.assertEquals((String)"Required parameter didn't match url base.", (Object)RouteWithParameter.class.getAnnotation(Route.class).value(), this.routeConfiguration.getUrlBase(RouteWithParameter.class).orElse(null));
        Assert.assertEquals((String)"Wildcard parameter didn't match url base.", (Object)RouteWithMultipleParameters.class.getAnnotation(Route.class).value(), this.routeConfiguration.getUrlBase(RouteWithMultipleParameters.class).orElse(null));
        Assert.assertEquals((String)"Optional parameter didn't match url base.", (Object)OptionalParameter.class.getAnnotation(Route.class).value(), this.routeConfiguration.getUrlBase(OptionalParameter.class).orElse(null));
        Assert.assertEquals((String)"Non parameterized url didn't match url base.", (Object)RoutingTestBase.FooNavigationTarget.class.getAnnotation(Route.class).value(), this.routeConfiguration.getUrlBase(RoutingTestBase.FooNavigationTarget.class).orElse(null));
    }

    @Test
    public void getTemplate_returns_url_template() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(RouteWithParameter.class, RouteWithMultipleParameters.class, OptionalParameter.class, RoutingTestBase.FooNavigationTarget.class);
        Assert.assertEquals((String)"Required parameter didn't match route template.", (Object)"param/:___url_parameter", this.routeConfiguration.getTemplate(RouteWithParameter.class).orElse(null));
        Assert.assertEquals((String)"Wildcard parameter didn't match route template.", (Object)"param/:___url_parameter*", this.routeConfiguration.getTemplate(RouteWithMultipleParameters.class).orElse(null));
        Assert.assertEquals((String)"Optional parameter didn't match route template.", (Object)"optional/:___url_parameter?", this.routeConfiguration.getTemplate(OptionalParameter.class).orElse(null));
        Assert.assertEquals((String)"Non parameterized url didn't match route template.", (Object)"foo", this.routeConfiguration.getTemplate(RoutingTestBase.FooNavigationTarget.class).orElse(null));
    }

    @Test
    public void routerLinkInParent_updatesWhenNavigating() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(LoneRoute.class, RouteChild.class);
        this.ui.navigate(this.routeConfiguration.getUrl(LoneRoute.class));
        RouteParent routeParent = (RouteParent)((Object)this.ui.getInternals().getActiveRouterTargetsChain().get(1));
        RouterLink loneLink = routeParent.loneLink;
        Assert.assertTrue((String)"Link should be attached", (boolean)loneLink.getUI().isPresent());
        Assert.assertTrue((String)"Link should be highlighted when navigated to link target", (boolean)loneLink.getElement().hasAttribute("highlight"));
        this.ui.navigate(this.routeConfiguration.getUrl(RouteChild.class));
        Assert.assertTrue((String)"Link should be attached", (boolean)loneLink.getUI().isPresent());
        Assert.assertFalse((String)"Link should not be highlighted when navigated to other target", (boolean)loneLink.getElement().hasAttribute("highlight"));
    }

    @Test
    public void navigation_targets_remove_route_with_same_path() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(MyPage.class, MyPageWithParam.class);
        this.assertMyPageAndWithParamAvailable();
        this.routeConfiguration.update((Command & Serializable)() -> this.routeConfiguration.removeRoute("my"));
        List availableRoutes = this.routeConfiguration.getAvailableRoutes();
        Assert.assertEquals((long)1L, (long)availableRoutes.size());
        Assert.assertEquals((Object)"my/:___url_parameter", (Object)((RouteData)availableRoutes.get(0)).getTemplate());
        Assert.assertEquals(MyPageWithParam.class, (Object)((RouteData)availableRoutes.get(0)).getNavigationTarget());
    }

    @Test
    public void navigation_targets_remove_route_with_same_path_and_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(MyPage.class, MyPageWithParam.class);
        this.assertMyPageAndWithParamAvailable();
        this.routeConfiguration.update((Command & Serializable)() -> this.routeConfiguration.removeRoute("my/:___url_parameter"));
        this.assertMyPageAvailable();
    }

    @Test
    public void navigation_targets_remove_route_target_with_same_path_and_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(MyPage.class, MyPageWithParam.class);
        this.assertMyPageAndWithParamAvailable();
        this.routeConfiguration.update((Command & Serializable)() -> this.routeConfiguration.removeRoute("my", MyPageWithParam.class));
        this.assertMyPageAvailable();
    }

    private void assertMyPageAvailable() {
        List availableRoutes = this.routeConfiguration.getAvailableRoutes();
        Assert.assertEquals((long)1L, (long)availableRoutes.size());
        Assert.assertEquals((Object)"my", (Object)((RouteData)availableRoutes.get(0)).getTemplate());
        Assert.assertEquals(MyPage.class, (Object)((RouteData)availableRoutes.get(0)).getNavigationTarget());
    }

    private void assertMyPageAndWithParamAvailable() {
        Assert.assertEquals(MyPage.class, this.routeConfiguration.getRoute("my").get());
        Assert.assertEquals(MyPageWithParam.class, this.routeConfiguration.getRoute("my/:___url_parameter").get());
        Assert.assertEquals(MyPageWithParam.class, this.routeConfiguration.getRoute("my", Arrays.asList(":___url_parameter")).get());
    }

    @Test
    public void navigation_targets_with_same_route_and_one_with_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(MyPage.class, MyPageWithParam.class);
        this.assertSameRouteWithParams();
    }

    @Test
    public void navigation_targets_with_same_route_and_two_with_parameter() throws InvalidRouteConfigurationException {
        this.setNavigationTargets(MyPage.class, MyPageWithParam.class, MyPageWithWildcardParam.class);
        this.assertSameRouteWithParams();
        Assert.assertEquals((Object)"my/:___url_parameter*", this.routeConfiguration.getTemplate(MyPageWithWildcardParam.class).get());
        Assert.assertEquals((Object)"my/wild/value", (Object)this.routeConfiguration.getUrl(MyPageWithWildcardParam.class, (Object)"wild/value"));
        Assert.assertEquals((Object)"my/wild/value", (Object)this.routeConfiguration.getUrl(MyPageWithWildcardParam.class, new RouteParameters("___url_parameter", "wild/value")));
        Assert.assertEquals(MyPageWithWildcardParam.class, this.routeConfiguration.getRoute("my/wild/param").get());
    }

    private void assertSameRouteWithParams() {
        Assert.assertEquals((Object)"my", this.routeConfiguration.getTemplate(MyPage.class).get());
        Assert.assertEquals((Object)"my/:___url_parameter", this.routeConfiguration.getTemplate(MyPageWithParam.class).get());
        Assert.assertEquals((Object)"my", (Object)this.routeConfiguration.getUrl(MyPage.class));
        Assert.assertEquals((Object)"my/value", (Object)this.routeConfiguration.getUrl(MyPageWithParam.class, (Object)"value"));
        Assert.assertEquals((Object)"my/value", (Object)this.routeConfiguration.getUrl(MyPageWithParam.class, new RouteParameters("___url_parameter", "value")));
        Assert.assertEquals(MyPage.class, this.routeConfiguration.getRoute("my").get());
        Assert.assertEquals(MyPageWithParam.class, this.routeConfiguration.getRoute("my/param").get());
    }

    @Route(value="child", layout=RouteParent.class)
    @Tag(value="div")
    public static class RouteChild
    extends Component
    implements BeforeLeaveObserver,
    BeforeEnterObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }

        public void beforeLeave(BeforeLeaveEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="single", layout=RouteParent.class, absolute=true)
    @Tag(value="div")
    public static class LoneRoute
    extends Component
    implements BeforeEnterObserver {
        static List<EventObject> events = new ArrayList<EventObject>();

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((EventObject)event);
        }
    }

    @Route(value="optional")
    @Tag(value="div")
    public static class OptionalParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, @com.vaadin.flow.router.OptionalParameter String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="wild")
    @Tag(value="div")
    public static class WildParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static String param;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class WildRootParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String param;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add((EventObject)event);
            param = parameter;
        }
    }

    @Route(value="")
    @Tag(value="div")
    public static class OptionalRootParameter
    extends Component
    implements HasUrlParameter<String> {
        private static List<EventObject> events = new ArrayList<EventObject>();
        private static String param;

        public void setParameter(BeforeEvent event, @com.vaadin.flow.router.OptionalParameter String parameter) {
            events.add((EventObject)event);
            param = parameter;
        }
    }

    @Route(value="integer")
    @Tag(value="div")
    public static class IntegerParameter
    extends Component
    implements HasUrlParameter<Integer> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Integer param;

        public void setParameter(BeforeEvent event, Integer parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="long")
    @Tag(value="div")
    public static class LongParameter
    extends Component
    implements HasUrlParameter<Long> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Long param;

        public void setParameter(BeforeEvent event, Long parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="boolean")
    @Tag(value="div")
    public static class BooleanParameter
    extends Component
    implements HasUrlParameter<Boolean> {
        private static List<BeforeEvent> events = new ArrayList<BeforeEvent>();
        private static Boolean param;

        public void setParameter(BeforeEvent event, Boolean parameter) {
            events.add(event);
            param = parameter;
        }
    }

    @Route(value="param")
    @Tag(value="div")
    public static class RouteWithParameter
    extends Component
    implements BeforeEnterObserver,
    HasUrlParameter<String> {
        private static String param;
        private static List<BeforeEvent> events;

        public void setParameter(BeforeEvent event, String parameter) {
            events.add(event);
            param = parameter;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }

        static {
            events = new ArrayList<BeforeEvent>();
        }
    }

    @Route(value="param")
    @Tag(value="div")
    public static class RouteWithMultipleParameters
    extends Component
    implements BeforeEnterObserver,
    HasUrlParameter<String> {
        private static String param;
        private static List<BeforeEvent> events;

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
            events.add(event);
            param = parameter;
        }

        public void beforeEnter(BeforeEnterEvent event) {
            events.add((BeforeEvent)event);
        }

        static {
            events = new ArrayList<BeforeEvent>();
        }
    }

    @RoutePrefix(value="parent")
    @Tag(value="div")
    public static class RouteParent
    extends Component
    implements RouterLayout {
        private final RouterLink loneLink = new RouterLink("lone", LoneRoute.class);

        public RouteParent() {
            this.getElement().appendChild(new Element[]{this.loneLink.getElement()});
        }
    }

    @Route(value="my")
    @Tag(value="div")
    public class MyPage
    extends Component {
    }

    @Route(value="my")
    @Tag(value="div")
    public class MyPageWithParam
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="my")
    @Tag(value="div")
    public class MyPageWithWildcardParam
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        }
    }
}

