/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListClearChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class NodeListAddRemoveTest
extends AbstractNodeFeatureTest<ElementClassList> {
    protected ElementClassList nodeList = (ElementClassList)this.createFeature();

    private List<String> resetToRemoveAfterAddCase() {
        this.nodeList.clear();
        this.collectChanges((NodeFeature)this.nodeList);
        return this.addOriginalItems(4);
    }

    @Test
    public void clear_onlyListClearChange() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.clear();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        this.verifyCleared(changes);
        Assert.assertEquals((long)0L, (long)this.nodeList.size());
    }

    @Test
    public void remove_add_changesAreNotAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.remove(items.size() - 2);
        String removed = items.get(items.size() - 2);
        this.nodeList.add((Serializable)((Object)removed));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)2L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        Assert.assertTrue((boolean)(changes.get(1) instanceof ListAddChange));
        ListRemoveChange remove = (ListRemoveChange)changes.get(0);
        Assert.assertEquals((long)(items.size() - 2), (long)remove.getIndex());
        Assert.assertEquals((Object)removed, (Object)remove.getRemovedItem());
        ListAddChange add = (ListAddChange)changes.get(1);
        Assert.assertEquals((long)(items.size() - 1), (long)add.getIndex());
        Assert.assertEquals((long)1L, (long)add.getNewItems().size());
        Assert.assertEquals((Object)removed, add.getNewItems().get(0));
    }

    @Test
    public void add_immediatelyRemove_changesDiscarded() {
        List<String> items = this.resetToRemoveAfterAddCase();
        String newItem = "foo";
        this.nodeList.add((Serializable)((Object)newItem));
        int index = items.size();
        this.nodeList.remove(index);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)0L, (long)changes.size());
    }

    @Test
    public void addAll_immediatelyRemove_changeIsAdjusted() {
        this.resetToRemoveAfterAddCase();
        ArrayList<String> items = new ArrayList<String>();
        this.addItemsAll(items, 3);
        this.nodeList.remove(this.nodeList.size() - 2);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        ListAddChange add = (ListAddChange)changes.get(0);
        Assert.assertEquals((long)(this.nodeList.size() - 2), (long)add.getIndex());
        Assert.assertEquals((long)2L, (long)add.getNewItems().size());
        items.remove(1);
        Assert.assertEquals(items, (Object)add.getNewItems());
    }

    @Test
    public void add_addInBetweenAndRemove_changesAreAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        String newItem = "foo";
        this.nodeList.add((Serializable)((Object)newItem));
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.add((Serializable)((Object)"bar1"));
        int index = items.size();
        String item = (String)((Object)this.nodeList.get(index));
        this.nodeList.remove(index);
        Optional<AbstractListChange> optionalChange = this.nodeList.getChangeTracker().stream().filter(change -> {
            ListAddChange addChange = (ListAddChange)change;
            return addChange.getNewItems().contains(item);
        }).findFirst();
        Assert.assertFalse((boolean)optionalChange.isPresent());
        Assert.assertEquals((long)2L, (long)this.nodeList.getChangeTracker().size());
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)2L, (long)changes.size());
        this.verifyAdded(changes, Arrays.asList("bar", "bar1"), index, index + 1);
    }

    @Test
    public void insertBefore_addAndRemove_changesAreDiscarded() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = this.nodeList.size() - 1;
        this.nodeList.add(index, (Serializable)((Object)"bar"));
        this.nodeList.remove(this.nodeList.size() - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        this.verifyAdded(changes, Arrays.asList("bar"), index);
    }

    @Test
    public void insertAfter_addAllAndRemove_changesAreAdjusted() {
        this.resetToRemoveAfterAddCase();
        ArrayList<String> items = new ArrayList<String>();
        this.addItemsAll(items, 3);
        int index = this.nodeList.size() - 1;
        this.nodeList.add(index, (Serializable)((Object)"bar"));
        this.nodeList.remove(index - 2);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)2L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        Assert.assertTrue((boolean)(changes.get(1) instanceof ListAddChange));
        ListAddChange add = (ListAddChange)changes.get(0);
        Assert.assertEquals((long)(index - 2), (long)add.getIndex());
        Assert.assertEquals((long)2L, (long)add.getNewItems().size());
        items.remove(0);
        Assert.assertEquals(items, (Object)add.getNewItems());
        add = (ListAddChange)changes.get(1);
        Assert.assertEquals((long)(index - 1), (long)add.getIndex());
        Assert.assertEquals((long)1L, (long)add.getNewItems().size());
        Assert.assertEquals((Object)"bar", add.getNewItems().get(0));
    }

    @Test
    public void addOperationAfterDelete_addRemove_subsequentOoperationsAreNotAffected() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = items.size();
        this.nodeList.remove(index);
        String newItem = "bar";
        this.nodeList.add((Serializable)((Object)newItem));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        this.verifyAdded(changes, Arrays.asList(newItem), index);
    }

    @Test
    public void removeOperationAfterDelete_addRemove_subsequentOperationsAreNotAffected() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = items.size();
        this.nodeList.remove(index);
        this.nodeList.remove(index - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        this.verifyRemoved(changes, Arrays.asList(items.get(index - 1)), index - 1);
    }

    @Test
    public void removeInBetween_addRemove_removeIsNotAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        int index = items.size();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.remove(index - 1);
        this.nodeList.remove(index - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        this.verifyRemoved(changes, Arrays.asList(items.get(index - 1)), index - 1);
    }

    @Test
    public void clearInBetween_addRemove_removeIsAdjustedProperly() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.remove(0);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertEquals(ListClearChange.class, changes.get(0).getClass());
    }

    @Test
    public void clear_collectChanges_allPreviousEventsAreRemoved() {
        List<String> items = this.resetToRemoveAfterAddCase();
        int index = items.size();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.remove(index);
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"baz"));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assert.assertEquals((long)2L, (long)changes.size());
        MatcherAssert.assertThat((Object)changes.get(0), (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
        MatcherAssert.assertThat((Object)changes.get(1), (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
        Assert.assertEquals((long)1L, (long)this.nodeList.size());
        Assert.assertEquals((Object)"baz", (Object)this.nodeList.get(0));
    }

    @Test
    public void clear_collectChanges_resetChangeTracker_clearEventIsCollected() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.add((Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)3L, (long)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(2)), (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
        this.nodeList.add((Serializable)((Object)"baz"));
        changes.clear();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }

    @Test
    public void clear_collectChanges_resetChangeTracker_reattach_clearEventIsCollected() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.add((Serializable)((Object)"bar"));
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).remove(0);
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)3L, (long)changes.size());
        Assert.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assert.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
        Assert.assertEquals(ListAddChange.class, ((NodeChange)changes.get(2)).getClass());
        changes.clear();
        this.nodeList.add((Serializable)((Object)"baz"));
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }

    @Test
    public void clearNodeList_clearChanges_generateChangesFromEmpty_clearChangeIsCollected() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)2L, (long)changes.size());
        Assert.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assert.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
    }

    @Test
    public void clearNodeList_clearChanges_reatach_generateChangesFromEmpty_clearChangeIsCollected() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).remove(0);
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)2L, (long)changes.size());
        Assert.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assert.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
    }

    @Test
    public void collectChanges_clearNodeListIsDoneFirst_noClearEventinCollectedChanges() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        changes.clear();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertEquals(ListAddChange.class, ((NodeChange)changes.get(0)).getClass());
    }

    @Test
    public void clear_modifyList_collectChanges_clearChangeIsCollected() {
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"foo"));
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assert.assertEquals((long)3L, (long)changes.size());
        Assert.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assert.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
        Assert.assertEquals(ListAddChange.class, ((NodeChange)changes.get(2)).getClass());
    }

    private List<String> addOriginalItems(int numberOfOriginalItems) {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < numberOfOriginalItems; ++i) {
            String item = "o-" + i;
            this.nodeList.add((Serializable)((Object)item));
            items.add(item);
        }
        this.collectChanges((NodeFeature)this.nodeList);
        this.verifyNodeListContent(items.toArray());
        return items;
    }

    private void addItemsAll(List<String> listCaptureAdded, int numberOfItems) {
        ArrayList<CallSite> items = new ArrayList<CallSite>();
        int indexInList = listCaptureAdded.size();
        for (int i = 0; i < numberOfItems; ++i) {
            String item = "a-" + indexInList + ":" + i + "/" + numberOfItems;
            items.add((CallSite)((Object)item));
            ++indexInList;
        }
        this.nodeList.addAll(items);
        listCaptureAdded.addAll(items);
    }

    private void verifyNodeListContent(Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Assert.assertEquals((Object)items[i], (Object)this.nodeList.get(i));
        }
    }

    private void verifyCleared(List<NodeChange> changes) {
        Assert.assertEquals((long)1L, (long)changes.size());
        NodeChange nodeChange = changes.get(0);
        MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
    }

    private void verifyRemoved(List<NodeChange> changes, List<String> items, Integer ... indexes) {
        Assert.assertTrue((changes.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < indexes.length; ++i) {
            NodeChange nodeChange = changes.get(i);
            MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListRemoveChange.class));
            ListRemoveChange change = (ListRemoveChange)nodeChange;
            Assert.assertEquals((long)indexes[i].intValue(), (long)change.getIndex());
            Assert.assertEquals((Object)items.get(i), (Object)change.getRemovedItem());
        }
    }

    private void verifyAdded(List<NodeChange> changes, List<String> items, Integer ... indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            NodeChange nodeChange = changes.get(i);
            MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
            ListAddChange change = (ListAddChange)nodeChange;
            Assert.assertEquals((long)indexes[i].intValue(), (long)change.getIndex());
            Assert.assertEquals((long)1L, (long)change.getNewItems().size());
            Assert.assertEquals((Object)items.get(i), change.getNewItems().get(0));
        }
    }
}

