/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class MapPutChangeTest {
    private NodeMap feature = (NodeMap)AbstractNodeFeatureTest.createFeature(ElementPropertyMap.class);

    @Test
    public void testJson() {
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "some", (Object)"string");
        ObjectNode json = change.toJson(null);
        Assert.assertEquals((long)change.getNode().getId(), (long)json.get("node").intValue());
        Assert.assertEquals((long)NodeFeatureRegistry.getId(this.feature.getClass()), (long)json.get("feat").intValue());
        Assert.assertEquals((Object)"put", (Object)json.get("type").textValue());
        Assert.assertEquals((Object)"some", (Object)json.get("key").textValue());
        Assert.assertEquals((Object)"string", (Object)json.get("value").textValue());
    }

    @Test
    public void testJsonValueTypes() {
        JsonNode stringValue = this.getValue("string");
        Assert.assertSame((Object)JsonNodeType.STRING, (Object)stringValue.getNodeType());
        Assert.assertEquals((Object)"string", (Object)stringValue.textValue());
        JsonNode numberValue = this.getValue(1);
        Assert.assertSame((Object)JsonNodeType.NUMBER, (Object)numberValue.getNodeType());
        Assert.assertEquals((float)1.0f, (float)numberValue.intValue(), (float)0.0f);
        JsonNode booleanValue = this.getValue(Boolean.TRUE);
        Assert.assertSame((Object)JsonNodeType.BOOLEAN, (Object)booleanValue.getNodeType());
        Assert.assertTrue((boolean)booleanValue.asBoolean());
        ObjectNode jsonInput = JacksonUtils.createObjectNode();
        JsonNode jsonValue = this.getValue(jsonInput);
        Assert.assertSame((Object)JsonNodeType.OBJECT, (Object)jsonValue.getNodeType());
        Assert.assertEquals((Object)jsonInput, (Object)jsonValue);
    }

    @Test
    public void testNodeValueType() {
        StateNode value = StateNodeTest.createEmptyNode("value");
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "myKey", (Object)value);
        ObjectNode json = change.toJson(null);
        Assert.assertFalse((boolean)json.has("value"));
        JsonNode nodeValue = json.get("nodeValue");
        Assert.assertSame((Object)JsonNodeType.NUMBER, (Object)nodeValue.getNodeType());
        Assert.assertEquals((long)value.getId(), (long)nodeValue.intValue());
    }

    private JsonNode getValue(Object input) {
        MapPutChange change = new MapPutChange((NodeFeature)this.feature, "myKey", input);
        ObjectNode json = change.toJson(null);
        return json.get("value");
    }
}

