/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.EncodeUtil;
import org.junit.Assert;
import org.junit.Test;

public class EncodeUtilTest {
    @Test(expected=NullPointerException.class)
    public void rfc5987Encode_withNull_nullPointerException() {
        EncodeUtil.rfc5987Encode(null);
    }

    @Test(expected=NullPointerException.class)
    public void rfc2047Encode_withNull_nullPointerException() {
        EncodeUtil.rfc2047Encode(null);
    }

    @Test
    public void rfc5987Encode_asciiCharacters() {
        String input = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'*+-.^_`|~";
        Assert.assertEquals((Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&%27%2A+-.^_`|~", (Object)EncodeUtil.rfc5987Encode((String)input));
    }

    @Test
    public void rfc5987Encode_unicodeCharacters0to126() throws Exception {
        StringBuilder text = new StringBuilder();
        int codePoint = 0;
        while (codePoint <= 126) {
            text.append(new String(new int[]{codePoint++}, 0, 1));
        }
        Assert.assertEquals((Object)"%00%01%02%03%04%05%06%07%08%09%0A%0B%0C%0D%0E%0F%10%11%12%13%14%15%16%17%18%19%1A%1B%1C%1D%1E%1F%20!%22#$%25&%27%28%29%2A+%2C-.%2F0123456789%3A%3B%3C%3D%3E%3F%40ABCDEFGHIJKLMNOPQRSTUVWXYZ%5B%5C%5D^_`abcdefghijklmnopqrstuvwxyz%7B|%7D~", (Object)EncodeUtil.rfc5987Encode((String)text.toString()));
    }

    @Test
    public void rfc5987Encode_unicodeLatin1SupplementCharacters() throws Exception {
        Assert.assertEquals((Object)"%E2%82%AC%20%C3%BF", (Object)EncodeUtil.rfc5987Encode((String)"\u20ac \u00ff"));
    }

    @Test
    public void rfc5987Encode_unicodeLatinExtendACharacters() throws Exception {
        Assert.assertEquals((Object)"%C4%80%C4%81", (Object)EncodeUtil.rfc5987Encode((String)"\u0100\u0101"));
    }

    @Test
    public void rfc2047Encode_asciiCharacters() {
        String input = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'*+-.^_`|~ ?=\"";
        Assert.assertEquals((Object)"=?UTF-8?Q?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'*+-.^=5F`|~_=3F=3D=22?=", (Object)EncodeUtil.rfc2047Encode((String)input));
    }

    @Test
    public void rfc2047Encode_nonAsciiCharacters() {
        String input = "\u0158\u0159\u00fc\u00f1\u00ee\u00e7\u00f8d\u00eb 1\u4e2d\u6587 \u20ac \u00ff\u0100\u0101";
        Assert.assertEquals((Object)"=?UTF-8?Q?=C5=98=C5=99=C3=BC=C3=B1=C3=AE=C3=A7=C3=B8d=C3=AB_1=E4=B8=AD=E6=96=87_=E2=82=AC_=C3=BF=C4=80=C4=81?=", (Object)EncodeUtil.rfc2047Encode((String)input));
    }

    @Test
    public void isPureUSASCII_withAsciiOnly_returnTrue() {
        String input = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'*+-.^_`|~ ?=\"";
        Assert.assertTrue((boolean)EncodeUtil.isPureUSASCII((String)input));
    }

    @Test
    public void isPureUSASCII_withNonAscii_returnFalse() {
        String input = "\u0158\u0159\u00fc\u00f1\u00ee\u00e7\u00f8\u00eb\u4e2d\u6587\u20ac\u00ff\u0100\u0101";
        input.chars().forEach(c -> Assert.assertFalse((String)("Character " + (char)c + " should not be US-ASCII"), (boolean)EncodeUtil.isPureUSASCII((String)Character.toString((char)c))));
    }
}

