/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtil {
    private static final Pattern PERCENT_ENCODED = Pattern.compile("%([0-9A-Fa-f]{2})");

    private UrlUtil() {
    }

    public static boolean isExternal(String url) {
        if (url.startsWith("//")) {
            return true;
        }
        return url.contains("://");
    }

    public static String encodeURI(String uri) {
        try {
            return URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%2F", "/").replace("%40", "@").replace("%3B", ";").replace("%2C", ",").replace("%3F", "?").replace("%3A", ":").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%23", "#");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }

    public static String encodeURIComponent(String path) {
        try {
            return URLEncoder.encode(path, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }

    public static String decodeURIComponent(String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            return encoded;
        }
        Matcher matcher = PERCENT_ENCODED.matcher(encoded);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            result.append(encoded, lastEnd, matcher.start());
            String hex = matcher.group(1);
            int value = Integer.parseInt(hex, 16);
            result.append((char)value);
            lastEnd = matcher.end();
        }
        result.append(encoded, lastEnd, encoded.length());
        byte[] bytes = new byte[result.length()];
        boolean hasMultibyte = false;
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c > '\u007f') {
                hasMultibyte = true;
            }
            bytes[i] = (byte)c;
        }
        if (hasMultibyte) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return result.toString();
    }

    public static String getServletPathRelative(String absolutePath, HttpServletRequest request) {
        int i;
        Object pathToServlet = request.getContextPath() + request.getServletPath();
        if (((String)pathToServlet).startsWith("/")) {
            pathToServlet = ((String)pathToServlet).substring(1);
        }
        if (absolutePath.startsWith("/")) {
            absolutePath = absolutePath.substring(1);
        }
        String[] servletPathSegments = ((String)pathToServlet).isEmpty() ? new String[]{} : ((String)pathToServlet).split("/");
        String[] absolutePathSegments = absolutePath.isEmpty() ? new String[]{} : absolutePath.split("/");
        for (int startFrom = 0; absolutePathSegments.length > startFrom && servletPathSegments.length > startFrom && absolutePathSegments[startFrom].equals(servletPathSegments[startFrom]); ++startFrom) {
        }
        Object ret = "";
        for (i = startFrom; i < servletPathSegments.length; ++i) {
            ret = (String)ret + "../";
        }
        for (i = startFrom; i < absolutePathSegments.length; ++i) {
            ret = (String)ret + absolutePathSegments[i] + "/";
        }
        if (((String)ret).isEmpty()) {
            return ".";
        }
        return ((String)ret).substring(0, ((String)ret).length() - 1);
    }
}

