/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class DomEvent
extends EventObject {
    private final JsonNode eventData;
    private final String eventType;
    private final DebouncePhase phase;
    private final Element eventTarget;

    public DomEvent(Element source, String eventType, JsonNode eventData) {
        super(source);
        assert (source != null);
        assert (eventType != null);
        assert (eventData != null);
        this.eventType = eventType;
        this.eventData = eventData;
        this.phase = DomEvent.extractPhase(eventData);
        this.eventTarget = DomEvent.extractEventTarget(eventData, source);
    }

    private static DebouncePhase extractPhase(JsonNode eventData) {
        JsonNode jsonValue = eventData.get("for");
        if (jsonValue == null) {
            return DebouncePhase.LEADING;
        }
        return DebouncePhase.forIdentifier(jsonValue.asString());
    }

    private static Element extractEventTarget(JsonNode eventData, Element currentTarget) {
        return DomEvent.extractElement(eventData, currentTarget, "]", false);
    }

    static Element extractElement(JsonNode eventData, Element source, String key, boolean lookUnderUI) {
        Element mappedElementOrNull;
        NodeOwner owner;
        assert (key.startsWith("]"));
        if (!eventData.has(key)) {
            return null;
        }
        JsonNode reportedStateNodeId = eventData.get(key);
        if (reportedStateNodeId == null) {
            return null;
        }
        int id = reportedStateNodeId.intValue();
        if (id == -1) {
            return null;
        }
        AtomicReference matchingNode = new AtomicReference();
        Consumer<StateNode> visitor = node -> {
            if (node.getId() == id) {
                matchingNode.set(Element.get(node));
            }
        };
        source.getNode().visitNodeTree(visitor);
        if (lookUnderUI && matchingNode.get() == null && (owner = source.getNode().getOwner()) instanceof StateTree) {
            ((StateTree)owner).getRootNode().visitNodeTree(visitor);
        }
        if ((mappedElementOrNull = (Element)matchingNode.get()) != null && !mappedElementOrNull.isVisible()) {
            return null;
        }
        return mappedElementOrNull;
    }

    @Override
    public Element getSource() {
        return (Element)super.getSource();
    }

    public String getType() {
        return this.eventType;
    }

    public JsonNode getEventData() {
        return this.eventData;
    }

    public <T> T getEventData(Class<T> type) {
        return JacksonCodec.decodeAs(this.eventData, type);
    }

    public <T> T getEventData(TypeReference<T> typeReference) {
        return JacksonCodec.decodeAs(this.eventData, typeReference);
    }

    public DebouncePhase getPhase() {
        return this.phase;
    }

    public Optional<Element> getEventTarget() {
        return Optional.ofNullable(this.eventTarget);
    }

    public Optional<Element> getEventDataElement(String eventDataExpression) {
        Objects.requireNonNull(eventDataExpression);
        if (Objects.equals(eventDataExpression, "event.target")) {
            return this.getEventTarget();
        }
        return Optional.ofNullable(DomEvent.extractElement(this.eventData, this.getSource(), "]" + eventDataExpression, true));
    }

    public <T> T getEventDetail(Class<T> type) {
        JsonNode detailNode = this.getDetailNode();
        if (detailNode == null) {
            return null;
        }
        return JacksonCodec.decodeAs(detailNode, type);
    }

    public <T> T getEventDetail(TypeReference<T> typeReference) {
        JsonNode detailNode = this.getDetailNode();
        if (detailNode == null) {
            return null;
        }
        return JacksonCodec.decodeAs(detailNode, typeReference);
    }

    private JsonNode getDetailNode() {
        JsonNode detailNode = this.eventData.get("event.detail");
        if (detailNode != null && !detailNode.isNull()) {
            return detailNode;
        }
        boolean hasDetailProperties = JacksonUtils.getKeys(this.eventData).stream().anyMatch(key -> key.startsWith("event.detail."));
        if (!hasDetailProperties) {
            return null;
        }
        ObjectNode detailObject = JacksonUtils.createObjectNode();
        JacksonUtils.getKeys(this.eventData).forEach(key -> {
            if (key.startsWith("event.detail.")) {
                String propertyName = key.substring("event.detail.".length());
                detailObject.set(propertyName, this.eventData.get(key));
            }
        });
        return detailObject;
    }
}

