/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.Serializable;
import java.util.stream.IntStream;

public final class Range
implements Serializable {
    private final int start;
    private final int end;

    public Range[] partitionWith(Range other) {
        Range[] splitBefore = this.splitAt(other.getStart());
        Range rangeBefore = splitBefore[0];
        Range[] splitAfter = splitBefore[1].splitAt(other.getEnd());
        Range rangeInside = splitAfter[0];
        Range rangeAfter = splitAfter[1];
        return new Range[]{rangeBefore, rangeInside, rangeAfter};
    }

    public Range offsetBy(int offset) {
        if (offset == 0) {
            return this;
        }
        return new Range(this.start + offset, this.end + offset);
    }

    public static Range withOnly(int integer) {
        return new Range(integer, integer + 1);
    }

    public static Range between(int start, int end) throws IllegalArgumentException {
        return new Range(start, end);
    }

    public static Range withLength(int start, int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("length must not be negative");
        }
        return new Range(start, start + length);
    }

    private Range(int start, int end) throws IllegalArgumentException {
        if (start > end) {
            throw new IllegalArgumentException("start must not be greater than end");
        }
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int length() {
        return this.getEnd() - this.getStart();
    }

    public boolean isEmpty() {
        return this.getStart() >= this.getEnd();
    }

    public boolean intersects(Range other) {
        return this.getStart() < other.getEnd() && other.getStart() < this.getEnd();
    }

    public boolean contains(int integer) {
        return this.getStart() <= integer && integer < this.getEnd();
    }

    public boolean isSubsetOf(Range other) {
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return other.getStart() <= this.getStart() && this.getEnd() <= other.getEnd();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStart() + ".." + this.getEnd() + "]" + (this.isEmpty() ? " (empty)" : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public boolean startsBefore(Range other) {
        return this.getStart() < other.getStart();
    }

    public boolean endsBefore(Range other) {
        return this.getEnd() <= other.getStart();
    }

    public boolean endsAfter(Range other) {
        return this.getEnd() > other.getEnd();
    }

    public boolean startsAfter(Range other) {
        return this.getStart() >= other.getEnd();
    }

    public Range[] splitAt(int integer) {
        if (integer < this.start) {
            return new Range[]{Range.withLength(this.start, 0), this};
        }
        if (integer >= this.end) {
            return new Range[]{this, Range.withLength(this.end, 0)};
        }
        return new Range[]{new Range(this.start, integer), new Range(integer, this.end)};
    }

    public Range[] splitAtFromStart(int length) {
        return this.splitAt(this.getStart() + length);
    }

    public Range combineWith(Range other) throws IllegalArgumentException {
        if (this.getStart() > other.getEnd() || other.getStart() > this.getEnd()) {
            throw new IllegalArgumentException("There is a gap between " + this + " and " + other);
        }
        return Range.between(Math.min(this.getStart(), other.getStart()), Math.max(this.getEnd(), other.getEnd()));
    }

    public Range expand(int startDelta, int endDelta) throws IllegalArgumentException {
        return Range.between(this.getStart() - startDelta, this.getEnd() + endDelta);
    }

    public Range restrictTo(Range bounds) {
        boolean boundsWithin;
        boolean startWithin = bounds.contains(this.getStart());
        boolean endWithin = bounds.contains(this.getEnd());
        boolean bl = boundsWithin = this.getStart() < bounds.getStart() && this.getEnd() >= bounds.getEnd();
        if (startWithin) {
            if (endWithin) {
                return this;
            }
            return Range.between(this.getStart(), bounds.getEnd());
        }
        if (endWithin) {
            return Range.between(bounds.getStart(), this.getEnd());
        }
        if (boundsWithin) {
            return bounds;
        }
        return Range.withLength(this.getStart(), 0);
    }

    public IntStream stream() {
        return IntStream.range(this.getStart(), this.getEnd());
    }
}

