/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import java.io.Serializable;
import java.util.stream.Stream;

public class JacksonCodec {
    public static final int NODE_TYPE = 0;
    public static final int ARRAY_TYPE = 1;
    public static final int RETURN_CHANNEL_TYPE = 2;

    private JacksonCodec() {
    }

    public static JsonNode encodeWithTypeInfo(Object value) {
        assert (value == null || JacksonCodec.canEncodeWithTypeInfo(value.getClass()));
        if (value instanceof Component) {
            return JacksonCodec.encodeNode(((Component)value).getElement());
        }
        if (value instanceof Node) {
            return JacksonCodec.encodeNode((Node)value);
        }
        if (value instanceof ReturnChannelRegistration) {
            return JacksonCodec.encodeReturnChannel((ReturnChannelRegistration)value);
        }
        JsonNode encoded = JacksonCodec.encodeWithoutTypeInfo(value);
        if (encoded.getNodeType() == JsonNodeType.ARRAY) {
            encoded = JacksonCodec.wrapComplexValue(1, encoded);
        }
        return encoded;
    }

    private static ArrayNode encodeReturnChannel(ReturnChannelRegistration value) {
        return JacksonCodec.wrapComplexValue(2, JacksonUtils.getMapper().valueToTree((Object)value.getStateNodeId()), JacksonUtils.getMapper().valueToTree((Object)value.getChannelId()));
    }

    private static JsonNode encodeNode(Node<?> node) {
        StateNode stateNode = node.getNode();
        if (stateNode.isAttached()) {
            return JacksonCodec.wrapComplexValue(0, JacksonUtils.getMapper().valueToTree((Object)stateNode.getId()));
        }
        return JacksonUtils.getMapper().nullNode();
    }

    private static ArrayNode wrapComplexValue(int typeId, JsonNode ... values) {
        return Stream.concat(Stream.of(JacksonUtils.getMapper().valueToTree((Object)typeId)), Stream.of(values)).collect(JacksonUtils.asArray());
    }

    public static boolean canEncodeWithoutTypeInfo(Class<?> type) {
        assert (type != null);
        return String.class.equals(type) || Integer.class.equals(type) || Double.class.equals(type) || Boolean.class.equals(type) || JsonNode.class.isAssignableFrom(type);
    }

    public static boolean canEncodeWithTypeInfo(Class<?> type) {
        return JacksonCodec.canEncodeWithoutTypeInfo(type) || Node.class.isAssignableFrom(type) || Component.class.isAssignableFrom(type) || ReturnChannelRegistration.class.isAssignableFrom(type);
    }

    public static JsonNode encodeWithConstantPool(Object value, ConstantPool constantPool) {
        if (value instanceof ConstantPoolKey) {
            ConstantPoolKey reference = (ConstantPoolKey)value;
            return JacksonUtils.getMapper().valueToTree((Object)constantPool.getConstantId(reference));
        }
        return JacksonCodec.encodeWithoutTypeInfo(value);
    }

    public static JsonNode encodeWithoutTypeInfo(Object value) {
        if (value == null) {
            return JacksonUtils.getMapper().nullNode();
        }
        assert (JacksonCodec.canEncodeWithoutTypeInfo(value.getClass())) : "this:_" + value.getClass();
        Class<?> type = value.getClass();
        if (String.class.equals(value.getClass())) {
            return JacksonUtils.getMapper().valueToTree(value);
        }
        if (Integer.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Number)value).intValue());
        }
        if (Double.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Number)value).doubleValue());
        }
        if (Boolean.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Boolean)value));
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (JsonNode)value;
        }
        assert (!JacksonCodec.canEncodeWithoutTypeInfo(type));
        throw new IllegalArgumentException("Can't encode " + value.getClass() + " to json");
    }

    public static Serializable decodeWithoutTypeInfo(BaseJsonNode json) {
        assert (json != null);
        switch (json.getNodeType()) {
            case BOOLEAN: {
                return JacksonCodec.decodeAs((JsonNode)json, Boolean.class);
            }
            case STRING: {
                return (Serializable)((Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
            }
            case NUMBER: {
                return JacksonCodec.decodeAs((JsonNode)json, Double.class);
            }
            case NULL: {
                return null;
            }
        }
        return json;
    }

    public static <T> T decodeAs(JsonNode json, Class<T> type) {
        assert (json != null);
        if (json.getNodeType() == JsonNodeType.NULL && !type.isPrimitive()) {
            return null;
        }
        Class<?> convertedType = ReflectTools.convertPrimitiveType(type);
        if (type == String.class) {
            return type.cast(json.asText());
        }
        if (convertedType == Boolean.class) {
            return (T)convertedType.cast(json.asBoolean());
        }
        if (convertedType == Double.class) {
            return (T)convertedType.cast(json.doubleValue());
        }
        if (convertedType == Integer.class) {
            return (T)convertedType.cast(json.intValue());
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return type.cast(json);
        }
        assert (!JacksonCodec.canEncodeWithoutTypeInfo(type));
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }
}

