/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyList
implements Serializable {
    private final Set<String> urlCache = new HashSet<String>();
    private final Map<String, Dependency> urlToLoadedDependency = new LinkedHashMap<String, Dependency>();

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)DependencyList.class.getName());
    }

    public void add(Dependency dependency) {
        String dependencyUrl = dependency.getUrl();
        if (this.urlCache.contains(dependencyUrl)) {
            Optional.ofNullable(this.urlToLoadedDependency.get(dependencyUrl)).ifPresent(currentDependency -> this.handleDuplicateDependency(dependency, (Dependency)currentDependency));
        } else {
            this.urlCache.add(dependencyUrl);
            this.urlToLoadedDependency.put(dependencyUrl, dependency);
        }
    }

    private void handleDuplicateDependency(Dependency newDependency, Dependency currentDependency) {
        if (newDependency.getLoadMode() != currentDependency.getLoadMode()) {
            LoadMode moreEagerLoadMode = LoadMode.values()[Math.min(newDependency.getLoadMode().ordinal(), currentDependency.getLoadMode().ordinal())];
            this.getLogger().warn("Dependency with url {} was imported with two different loading strategies: {} and {}. The dependency will be loaded as {}.", new Object[]{newDependency.getUrl(), newDependency.getLoadMode(), currentDependency.getLoadMode(), moreEagerLoadMode});
            this.urlToLoadedDependency.replace(newDependency.getUrl(), new Dependency(newDependency.getType(), newDependency.getUrl(), moreEagerLoadMode));
        }
    }

    public Collection<Dependency> getPendingSendToClient() {
        return this.urlToLoadedDependency.values();
    }

    public void clearPendingSendToClient() {
        this.urlToLoadedDependency.clear();
    }
}

