/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.SystemMessagesInfo;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.dau.DAUCustomizer;
import com.vaadin.flow.server.dau.DauEnforcementException;
import com.vaadin.flow.server.dau.EnforcementNotificationMessages;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DAUUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DAUUtils.class);
    static final String DAU_COOKIE_NAME = "DailyActiveUser";
    static final int DAU_COOKIE_MAX_AGE_IN_SECONDS = 86400;
    static final long DAU_MIN_ACTIVITY_IN_SECONDS = 60L;
    public static final String ENFORCEMENT_EXCEPTION_KEY = DAUUtils.class.getName() + ".EnforcementException";
    public static final String STATUS_CODE_KEY = "Vaadin-DAU-Status-Code";

    private DAUUtils() {
    }

    public static boolean isDauEnabled(VaadinService service) {
        System.clearProperty("vaadin.dau.enable");
        return service.getDeploymentConfiguration().isProductionMode() && service.getDeploymentConfiguration().getBooleanProperty("dau.enable", false);
    }

    public static Optional<Cookie> getTrackingCookie(VaadinRequest request) {
        Cookie[] cookies = Objects.requireNonNull(request, "Request must not be null").getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> DAU_COOKIE_NAME.equals(cookie.getName())).findAny();
    }

    static Optional<DauCookie> parseCookie(Cookie cookie) {
        Instant creationTime;
        String cookieValue = cookie.getValue();
        String[] tokens = cookieValue.split("\\$");
        if (tokens.length != 2) {
            LOGGER.debug("Invalid DAU cookie value: {}.", (Object)cookieValue);
            return Optional.empty();
        }
        String trackingHash = tokens[0];
        if (trackingHash.isBlank()) {
            LOGGER.debug("Invalid DAU cookie value: {}. Missing tracking hash", (Object)cookieValue);
            return Optional.empty();
        }
        try {
            creationTime = Instant.ofEpochMilli(Long.parseLong(tokens[1]));
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Invalid DAU cookie value: {}. Unparsable creation timestamp.", (Object)cookieValue);
            return Optional.empty();
        }
        return Optional.of(new DauCookie(trackingHash, creationTime));
    }

    public static String jsonEnforcementResponse(VaadinRequest vaadinRequest, DauEnforcementException enforcementException) {
        EnforcementNotificationMessages messages = DAUUtils.getEnforcementNotificationMessages(vaadinRequest);
        return VaadinService.createCriticalNotificationJSON(messages.caption(), messages.message(), messages.details(), messages.url());
    }

    public static EnforcementNotificationMessages getEnforcementNotificationMessages(VaadinRequest vaadinRequest) {
        DAUCustomizer dauCustomizer;
        EnforcementNotificationMessages messages = EnforcementNotificationMessages.DEFAULT;
        VaadinService service = vaadinRequest.getService();
        if (service != null && (dauCustomizer = service.getContext().getAttribute(DAUCustomizer.class)) != null) {
            SystemMessagesInfo systemMessagesInfo = new SystemMessagesInfo(HandlerHelper.findLocale(VaadinSession.getCurrent(), vaadinRequest), vaadinRequest, service);
            messages = dauCustomizer.getEnforcementNotificationMessages(systemMessagesInfo);
        }
        return messages;
    }

    static boolean isTrackableRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.INIT) || HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL) || TrackableOperation.INSTANCE.isTrackable() || DAUUtils.isDirectViewRequest(request);
    }

    private static boolean isKnownPublicResource(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        return Stream.concat(Stream.of(HandlerHelper.getPublicResources()), Stream.of(HandlerHelper.getPublicResourcesRoot())).anyMatch(path -> path.equals(pathInfo)) || DAUUtils.isPwaIcon(request);
    }

    private static boolean isPwaIcon(VaadinRequest request) {
        VaadinServletContext vaadinContext;
        PwaConfiguration pwaConfiguration;
        String pathInfo = request.getPathInfo();
        VaadinContext vaadinContext2 = request.getService().getContext();
        if (vaadinContext2 instanceof VaadinServletContext && (pwaConfiguration = PwaRegistry.getInstance((vaadinContext = (VaadinServletContext)vaadinContext2).getContext()).getPwaConfiguration()).isEnabled()) {
            return HandlerHelper.getIconVariants(pwaConfiguration.getIconPath()).contains(pathInfo);
        }
        return false;
    }

    private static boolean isDirectViewRequest(VaadinRequest request) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.isEmpty() || "/".equals(pathInfo)) {
                return true;
            }
            if (pathInfo.startsWith("/VAADIN/") || pathInfo.startsWith("/HILLA/")) {
                return false;
            }
            return !DAUUtils.isKnownPublicResource(request);
        }
        return false;
    }

    private static VaadinRequest createVaadinRequest(VaadinService defaultVaadinService, HttpServletRequest request) {
        VaadinService service = VaadinService.getCurrent();
        if (service == null) {
            service = defaultVaadinService;
        }
        if (!(service instanceof VaadinServletService)) {
            service = null;
        }
        return new VaadinServletRequest(request, (VaadinServletService)service);
    }

    public static EnforcementResult trackDAU(VaadinService defaultVaadinService, HttpServletRequest request, HttpServletResponse response) {
        assert (request != null);
        VaadinRequest vaadinRequest = DAUUtils.createVaadinRequest(defaultVaadinService, request);
        VaadinService service = vaadinRequest.getService();
        VaadinServletResponse vaadinResponse = response != null ? new VaadinServletResponse(response, (VaadinServletService)service) : null;
        Runnable endRequestAction = null;
        if (service != null) {
            endRequestAction = () -> service.requestEnd(vaadinRequest, null, null);
            try {
                TrackableOperation.INSTANCE.execute(() -> {
                    service.requestStart(vaadinRequest, vaadinResponse);
                    if (DAUUtils.isDauEnabled(service)) {
                        FlowDauIntegration.applyEnforcement(vaadinRequest, unused -> true);
                    }
                });
            }
            catch (DauEnforcementException e) {
                EnforcementNotificationMessages messages = DAUUtils.getEnforcementNotificationMessages(vaadinRequest);
                return new EnforcementResult(messages, e, endRequestAction);
            }
        }
        return new EnforcementResult(null, null, endRequestAction);
    }

    record DauCookie(String trackingHash, Instant creationTime) {
        public boolean isActive() {
            return this.creationTime.plus(60L, ChronoUnit.SECONDS).isBefore(Instant.now());
        }
    }

    public static enum TrackableOperation {
        INSTANCE;


        public void execute(Runnable operation) {
            CurrentInstance.set(TrackableOperation.class, INSTANCE);
            try {
                operation.run();
            }
            finally {
                CurrentInstance.set(TrackableOperation.class, null);
            }
        }

        public boolean isTrackable() {
            return CurrentInstance.get(TrackableOperation.class) != null;
        }
    }

    public record EnforcementResult(EnforcementNotificationMessages messages, RuntimeException origin, Runnable endRequestAction) {
        public boolean isEnforcementNeeded() {
            return this.messages != null;
        }
    }
}

