/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractServerHandlers<T>
extends SerializableNodeList<String> {
    private Map<String, DisabledUpdateMode> disabledRpcModes;

    public AbstractServerHandlers(StateNode node) {
        super(node);
    }

    protected abstract void ensureSupportedParameterTypes(Method var1);

    public void componentSet(T component) {
        assert (component != null);
        this.collectHandlerMethods(component.getClass());
    }

    public DisabledUpdateMode getDisabledUpdateMode(String handler) {
        DisabledUpdateMode mode;
        DisabledUpdateMode disabledUpdateMode = mode = this.disabledRpcModes == null ? null : this.disabledRpcModes.get(handler);
        if (mode == null) {
            return DisabledUpdateMode.ONLY_WHEN_ENABLED;
        }
        return mode;
    }

    public boolean hasHandler(String handler) {
        return this.indexOf(handler) != -1;
    }

    protected void collectHandlerMethods(Class<?> classWithAnnotations) {
        ArrayList<Method> methods = new ArrayList<Method>();
        this.collectHandlerMethods(classWithAnnotations, methods);
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method2 : methods) {
            Method existing = (Method)map.get(method2.getName());
            if (existing != null && !Arrays.equals(existing.getParameterTypes(), method2.getParameterTypes())) {
                String msg = String.format(Locale.ENGLISH, "There may be only one handler method with the given name. Class '%s' (considering its superclasses) contains several handler methods with the same name: '%s'", classWithAnnotations.getName(), method2.getName());
                throw new IllegalStateException(msg);
            }
            map.put(method2.getName(), method2);
        }
        map.values().forEach(method -> this.add(method.getName(), this.getUpdateMode((Method)method)));
    }

    protected void collectHandlerMethods(Class<?> clazz, Collection<Method> methods) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        if (clazz.equals(this.getType())) {
            return;
        }
        Stream.of(clazz.getDeclaredMethods()).filter(method -> this.hasAnnotation((Method)method, this.getHandlerAnnotationFqn())).forEach(method -> this.addHandlerMethod((Method)method, methods));
        this.collectHandlerMethods(clazz.getSuperclass(), methods);
    }

    private boolean hasAnnotation(Method method, String fqn) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(fqn)) continue;
            return true;
        }
        return false;
    }

    protected void addHandlerMethod(Method method, Collection<Method> methods) {
        this.ensureSupportedParameterTypes(method);
        this.ensureSupportedReturnType(method);
        Optional<Class> checkedException = Stream.of(method.getExceptionTypes()).filter(ReflectTools::isCheckedException).findFirst();
        if (checkedException.isPresent()) {
            String msg = String.format(Locale.ENGLISH, "Handler method may not declare checked exceptions. Component '%s' has method '%s' which declares checked exception '%s' and annotated with '%s'", method.getDeclaringClass().getName(), method.getName(), checkedException.get().getName(), this.getHandlerAnnotationFqn());
            throw new IllegalStateException(msg);
        }
        methods.add(method);
    }

    protected void ensureSupportedReturnType(Method method) {
    }

    protected abstract String getHandlerAnnotationFqn();

    protected abstract DisabledUpdateMode getUpdateMode(Method var1);

    private void add(String handler, DisabledUpdateMode mode) {
        this.add(handler);
        if (!DisabledUpdateMode.ONLY_WHEN_ENABLED.equals((Object)mode)) {
            if (this.disabledRpcModes == null) {
                this.disabledRpcModes = new HashMap<String, DisabledUpdateMode>();
            }
            this.disabledRpcModes.put(handler, mode);
        }
    }

    private final Class<T> getType() {
        Type type = GenericTypeReflector.getTypeParameter((Type)this.getClass().getGenericSuperclass(), this.getClass().getSuperclass().getTypeParameters()[0]);
        if (type instanceof Class || type instanceof ParameterizedType) {
            return GenericTypeReflector.erase((Type)type);
        }
        throw new IllegalStateException(AbstractServerHandlers.getExceptionMessage(type));
    }

    private static String getExceptionMessage(Type type) {
        if (type == null) {
            return "AbstractServerHandlers is used as raw type: either add type information or override collectHandlerMethods(Class<?> clazz, Collection<Method> methods).";
        }
        if (type instanceof TypeVariable) {
            return String.format("Could not determine the composite content type for TypeVariable '%s'. Either specify exact type or override collectHandlerMethods().", type.getTypeName());
        }
        return String.format("Could not determine the composite content type for %s. Override collectHandlerMethods().", type.getTypeName());
    }
}

