/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.TransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class InputStreamDownloadHandler
extends AbstractDownloadHandler<InputStreamDownloadHandler> {
    private final InputStreamDownloadCallback callback;

    public InputStreamDownloadHandler(InputStreamDownloadCallback callback) {
        this.callback = callback;
    }

    @Override
    public void handleDownloadRequest(DownloadEvent downloadEvent) throws IOException {
        DownloadResponse download;
        VaadinResponse response = downloadEvent.getResponse();
        try {
            download = this.callback.complete(downloadEvent);
        }
        catch (IOException | RuntimeException e) {
            IOException cause;
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
            if (e instanceof IOException) {
                IOException ioe;
                cause = ioe = (IOException)e;
            } else if (e instanceof UncheckedIOException) {
                UncheckedIOException uioe = (UncheckedIOException)e;
                cause = uioe.getCause();
            } else {
                cause = new IOException(e.getMessage(), e);
            }
            downloadEvent.setException(e);
            this.notifyError(downloadEvent, cause);
            throw e;
        }
        if (download.hasError()) {
            response.setStatus(download.getError());
            Object message = download.getErrorMessage();
            if (message == null) {
                message = "Download failed with code " + download.getError();
            }
            IOException ioException = new IOException((String)message);
            if (download.getException() != null) {
                downloadEvent.setException(download.getException());
            } else {
                downloadEvent.setException(ioException);
            }
            this.notifyError(downloadEvent, ioException);
            return;
        }
        String downloadName = download.getFileName();
        String contentType = download.getContentType() == null ? this.getContentType(downloadName, response) : download.getContentType();
        downloadEvent.setContentType(contentType);
        if (!this.isInline()) {
            downloadEvent.setFileName(downloadName);
        } else {
            downloadEvent.getResponse().setHeader("Content-Disposition", "inline");
        }
        try (OutputStream outputStream = downloadEvent.getOutputStream();
             InputStream inputStream = download.getInputStream();){
            TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(downloadEvent), this.getListeners());
        }
        catch (IOException ioe) {
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
            downloadEvent.setException(ioe);
            this.notifyError(downloadEvent, ioe);
            throw ioe;
        }
    }
}

