/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface I18NProvider
extends Serializable {
    public List<Locale> getProvidedLocales();

    default public Locale getDefaultLocale() {
        List<Locale> providedLocales = this.getProvidedLocales();
        if (providedLocales.isEmpty()) {
            return null;
        }
        return providedLocales.get(0);
    }

    public String getTranslation(String var1, Locale var2, Object ... var3);

    default public String getTranslation(Object key, Locale locale, Object ... params) {
        return this.getTranslation(key.toString(), locale, params);
    }

    default public Map<String, String> getAllTranslations(Locale locale) {
        return Map.of();
    }

    default public Map<String, String> getTranslations(Collection<String> keys, Locale locale) {
        return keys.stream().distinct().collect(Collectors.toMap(Function.identity(), k -> this.getTranslation((String)k, locale, new Object[0])));
    }

    public static String translate(String key, Object ... params) {
        return I18NProvider.translate(LocaleUtil.getLocale(), key, params);
    }

    public static String translate(Locale locale, String key, Object ... params) {
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService == null) {
            throw new IllegalStateException("I18NProvider is not available as VaadinService is null");
        }
        Instantiator instantiator = vaadinService.getInstantiator();
        if (instantiator == null) {
            throw new IllegalStateException("I18NProvider is not available as Instantiator is null");
        }
        return LocaleUtil.getI18NProvider().map(i18n -> i18n.getTranslation(key, locale, params)).orElseGet(() -> "!{" + key + "}!");
    }
}

