/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import java.io.Serializable;
import java.util.stream.Stream;

public interface Style
extends Serializable {
    public String get(String var1);

    public Style set(String var1, String var2);

    public Style remove(String var1);

    public Style clear();

    public boolean has(String var1);

    public Stream<String> getNames();

    default public Style setBackground(String value) {
        return this.set("background", value);
    }

    default public Style setBackgroundColor(String value) {
        return this.set("background-color", value);
    }

    default public Style setBackgroundPosition(String value) {
        return this.set("background-position", value);
    }

    default public Style setBackgroundSize(String value) {
        return this.set("background-size", value);
    }

    default public Style setBorder(String value) {
        return this.set("border", value);
    }

    default public Style setBorderLeft(String value) {
        return this.set("border-left", value);
    }

    default public Style setBorderRight(String value) {
        return this.set("border-right", value);
    }

    default public Style setBorderTop(String value) {
        return this.set("border-top", value);
    }

    default public Style setBorderBottom(String value) {
        return this.set("border-bottom", value);
    }

    default public Style setBorderRadius(String value) {
        return this.set("border-radius", value);
    }

    default public Style setBoxSizing(BoxSizing value) {
        return this.applyOrErase("box-sizing", value);
    }

    default public Style setBoxShadow(String value) {
        return this.set("box-shadow", value);
    }

    default public Style setClear(Clear value) {
        return this.applyOrErase("clear", value);
    }

    default public Style setCursor(String value) {
        return this.set("cursor", value);
    }

    default public Style setColor(String value) {
        return this.set("color", value);
    }

    default public Style setFilter(String value) {
        return this.applyOrErase("filter", value);
    }

    default public Style setDisplay(Display value) {
        return this.applyOrErase("display", value);
    }

    default public Style setFloat(FloatCss value) {
        return this.applyOrErase("float", value);
    }

    default public Style setFont(String value) {
        return this.set("font", value);
    }

    default public Style setGap(String value) {
        return this.applyOrErase("gap", value);
    }

    default public Style setHeight(String value) {
        return this.set("height", value);
    }

    default public Style setMinHeight(String value) {
        return this.set("min-height", value);
    }

    default public Style setMaxHeight(String value) {
        return this.set("max-height", value);
    }

    default public Style setMargin(String value) {
        return this.set("margin", value);
    }

    default public Style setMarginLeft(String value) {
        return this.set("margin-left", value);
    }

    default public Style setMarginRight(String value) {
        return this.set("margin-right", value);
    }

    default public Style setMarginTop(String value) {
        return this.set("margin-top", value);
    }

    default public Style setMarginBottom(String value) {
        return this.set("margin-bottom", value);
    }

    default public Style setMarginInlineStart(String value) {
        return this.set("margin-inline-start", value);
    }

    default public Style setMarginInlineEnd(String value) {
        return this.set("margin-inline-end", value);
    }

    default public Style setOutline(String value) {
        return this.set("outline", value);
    }

    default public Style setOpacity(String value) {
        return this.set("opacity", value);
    }

    default public Style setOverflow(Overflow value) {
        return this.applyOrErase("overflow", value);
    }

    default public Style setPadding(String value) {
        return this.set("padding", value);
    }

    default public Style setPaddingLeft(String value) {
        return this.set("padding-left", value);
    }

    default public Style setPaddingRight(String value) {
        return this.set("padding-right", value);
    }

    default public Style setPaddingTop(String value) {
        return this.set("padding-top", value);
    }

    default public Style setPaddingBottom(String value) {
        return this.set("padding-bottom", value);
    }

    default public Style setPosition(Position value) {
        return this.applyOrErase("position", value);
    }

    default public Style setRotate(String value) {
        return this.applyOrErase("rotate", value);
    }

    default public Style setScale(String value) {
        return this.set("scale", value);
    }

    default public Style setTextAlign(TextAlign value) {
        return this.applyOrErase("text-align", value);
    }

    default public Style setTextDecoration(String value) {
        return this.set("text-decoration", value);
    }

    default public Style setTransform(String value) {
        return this.set("transform", value);
    }

    default public Style setTransformOrigin(String value) {
        return this.set("transform-origin", value);
    }

    default public Style setTransition(String value) {
        return this.set("transition", value);
    }

    default public Style setVisibility(Visibility value) {
        return this.applyOrErase("visibility", value);
    }

    default public Style setWidth(String value) {
        return this.set("width", value);
    }

    default public Style setMinWidth(String value) {
        return this.set("min-width", value);
    }

    default public Style setMaxWidth(String value) {
        return this.set("max-width", value);
    }

    default public Style setWhiteSpace(WhiteSpace value) {
        return this.applyOrErase("white-space", value);
    }

    default public Style setLeft(String value) {
        return this.set("left", value);
    }

    default public Style setRight(String value) {
        return this.set("right", value);
    }

    default public Style setTop(String value) {
        return this.set("top", value);
    }

    default public Style setBottom(String value) {
        return this.set("bottom", value);
    }

    default public Style setZIndex(Integer value) {
        return this.applyOrErase("z-index", value);
    }

    default public Style setFontWeight(FontWeight value) {
        return this.applyOrErase("font-weight", value);
    }

    default public Style setFontWeight(Integer value) {
        return this.applyOrErase("font-weight", value);
    }

    default public Style setFontWeight(String value) {
        return this.set("font-weight", value);
    }

    default public Style setFontSize(String value) {
        return this.set("font-size", value);
    }

    default public Style setLineHeight(String value) {
        return this.set("line-height", value);
    }

    default public Style setAlignItems(AlignItems value) {
        return this.applyOrErase("align-items", value);
    }

    default public Style setAlignSelf(AlignSelf value) {
        return this.applyOrErase("align-self", value);
    }

    default public Style setFlexWrap(FlexWrap value) {
        return this.applyOrErase("flex-wrap", value);
    }

    default public Style setFlexGrow(String value) {
        return this.set("flex-grow", value);
    }

    default public Style setFlexShrink(String value) {
        return this.set("flex-shrink", value);
    }

    default public Style setJustifyContent(JustifyContent value) {
        return this.applyOrErase("justify-content", value);
    }

    default public Style setFlexDirection(FlexDirection value) {
        return this.applyOrErase("flex-direction", value);
    }

    default public Style setFlexBasis(FlexBasis value) {
        return this.applyOrErase("flex-basis", value);
    }

    default public Style setFlexBasis(String value) {
        return this.set("flex-basis", value);
    }

    private Style applyOrErase(String propertyName, Enum value) {
        if (value == null) {
            return this.remove(propertyName);
        }
        return this.set(propertyName, value.name().replace("_", "-").toLowerCase());
    }

    private Style applyOrErase(String propertyName, Object value) {
        if (value == null) {
            return this.remove(propertyName);
        }
        return this.set(propertyName, value.toString());
    }

    public static enum FlexBasis {
        AUTO,
        MAX_CONTENT,
        MIN_CONTENT,
        FIT_CONTENT,
        CONTENT,
        INITIAL;

    }

    public static enum FlexDirection {
        ROW,
        ROW_REVERSE,
        COLUMN,
        COLUMN_REVERSE,
        INITIAL;

    }

    public static enum JustifyContent {
        CENTER,
        START,
        END,
        FLEX_START,
        FLEX_END,
        LEFT,
        RIGHT,
        NORMAL,
        SPACE_BETWEEN,
        SPACE_AROUND,
        SPACE_EVENLY,
        STRETCH,
        SAFE,
        UNSAFE,
        INITIAL;

    }

    public static enum FlexWrap {
        NOWRAP,
        WRAP,
        WRAP_REVERSE,
        INITIAL;

    }

    public static enum AlignSelf {
        AUTO,
        NORMAL,
        STRETCH,
        UNSAFE,
        SAFE,
        CENTER,
        START,
        END,
        FLEX_START,
        FLEX_END,
        SELF_START,
        SELF_END,
        BASELINE,
        INITIAL;

    }

    public static enum AlignItems {
        NORMAL,
        STRETCH,
        CENTER,
        UNSAFE,
        SAFE,
        START,
        END,
        FLEX_START,
        FLEX_END,
        SELF_START,
        SELF_END,
        BASELINE,
        INITIAL;

    }

    public static enum FontWeight {
        NORMAL,
        LIGHTER,
        BOLD,
        BOLDER,
        INITIAL,
        INHERIT;

    }

    public static enum WhiteSpace {
        NORMAL,
        NOWRAP,
        PRE,
        PRE_LINE,
        PRE_WRAP,
        BREAK_SPACES,
        INITIAL,
        INHERIT;

    }

    public static enum Visibility {
        VISIBLE,
        HIDDEN,
        COLLAPSE,
        INITIAL,
        INHERIT;

    }

    public static enum TextAlign {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY,
        INITIAL,
        INHERIT;

    }

    public static enum Position {
        STATIC,
        RELATIVE,
        ABSOLUTE,
        FIXED,
        STICKY;

    }

    public static enum Overflow {
        VISIBLE,
        HIDDEN,
        CLIP,
        SCROLL,
        AUTO,
        INITIAL,
        INHERIT;

    }

    public static enum FloatCss {
        NONE,
        LEFT,
        RIGHT,
        INITIAL,
        INHERIT;

    }

    public static enum Display {
        INLINE,
        BLOCK,
        CONTENTS,
        FLEX,
        GRID,
        INLINE_BLOCK,
        INLINE_FLEX,
        INLINE_GRID,
        INLINE_TABLE,
        LIST_ITEM,
        RUN_IN,
        TABLE,
        TABLE_CAPTION,
        TABLE_COLUMN_GROUP,
        TABLE_HEADER_GROUP,
        TABLE_FOOTER_GROUP,
        TABLE_ROW_GROUP,
        TABLE_CELL,
        TABLE_COLUMN,
        TABLE_ROW,
        NONE,
        INITIAL,
        INHERIT;

    }

    public static enum Clear {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        INITIAL,
        INHERIT;

    }

    public static enum BoxSizing {
        CONTENT_BOX,
        BORDER_BOX,
        INITIAL,
        INHERIT;

    }
}

