/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.scanner;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarManifestChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarManifestChecker.class);
    public static final String VAADIN_PACKAGE_VERSION = "Vaadin-Package-Version";
    private static final ConcurrentHashMap<File, Boolean> manifestCache = new ConcurrentHashMap();

    private JarManifestChecker() {
    }

    public static boolean hasVaadinManifest(File jarFile) {
        if (jarFile == null) {
            return false;
        }
        return manifestCache.computeIfAbsent(jarFile, JarManifestChecker::checkManifest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkManifest(File jarFile) {
        if (!jarFile.exists() || !jarFile.isFile()) {
            LOGGER.debug("File does not exist or is not a file: {}", (Object)jarFile);
            return false;
        }
        try (JarFile jar = new JarFile(jarFile);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                LOGGER.trace("No manifest found in {}", (Object)jarFile);
                boolean bl = false;
                return bl;
            }
            Attributes attrs = manifest.getMainAttributes();
            if (attrs == null) {
                LOGGER.trace("No main attributes in manifest of {}", (Object)jarFile);
                boolean bl = false;
                return bl;
            }
            String packageVersion = attrs.getValue(VAADIN_PACKAGE_VERSION);
            if (packageVersion != null) {
                LOGGER.debug("Found {} manifest attribute in {}: {}", new Object[]{VAADIN_PACKAGE_VERSION, jarFile.getName(), packageVersion});
                boolean bl = true;
                return bl;
            }
            LOGGER.trace("No {} attribute in manifest of {}", (Object)VAADIN_PACKAGE_VERSION, (Object)jarFile);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Error reading manifest from {}", (Object)jarFile, (Object)e);
            return false;
        }
    }

    public static void clearCache() {
        manifestCache.clear();
        LOGGER.debug("Manifest cache cleared");
    }

    public static int getCacheSize() {
        return manifestCache.size();
    }
}

