/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class ThemeValidationUtil {
    private static final Pattern THEME_PATH_PATTERN = Pattern.compile("themes\\/([\\s\\S]+?)\\/theme.json");
    private static final String FRONTEND_HASHES_KEY = "frontendHashes";

    public static boolean themeConfigurationChanged(Options options, JsonNode statsJson, FrontendDependenciesScanner frontendDependencies) {
        HashMap<String, JsonNode> themeJsonContents = new HashMap<String, JsonNode>();
        if (options.getJarFiles() != null) {
            options.getJarFiles().stream().filter(File::exists).filter(file -> !file.isDirectory()).forEach(jarFile -> ThemeValidationUtil.getPackagedThemeJsonContents(jarFile, themeJsonContents));
        }
        Optional<String> maybeThemeName = Optional.ofNullable(frontendDependencies.getThemeDefinition()).map(ThemeDefinition::getName).filter(name -> !name.isBlank());
        Optional projectThemeJson = maybeThemeName.flatMap(themeName -> ThemeUtils.getThemeJson(themeName, options.getFrontendDirectory()));
        String projectThemeName = maybeThemeName.orElse(null);
        JsonNode statsThemeJson = statsJson.get("themeJsonContents");
        if (statsThemeJson == null && (!themeJsonContents.isEmpty() || projectThemeJson.isPresent())) {
            ThemeValidationUtil.getLogger().info("Found newly added theme configurations in 'theme.json'.");
            return true;
        }
        if (projectThemeJson.isPresent()) {
            String key;
            if (statsThemeJson.has(projectThemeName)) {
                key = projectThemeName;
            } else if (!options.isProductionMode() && statsThemeJson.has("vaadin-dev-bundle")) {
                key = "vaadin-dev-bundle";
            } else if (options.isProductionMode() && statsThemeJson.has("vaadin-prod-bundle")) {
                key = "vaadin-prod-bundle";
            } else {
                ThemeValidationUtil.getLogger().info("Found newly added configuration for project theme '{}' in 'theme.json'.", (Object)projectThemeName);
                return true;
            }
            ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, key, (JsonNode)projectThemeJson.get());
        }
        for (Map.Entry<String, JsonNode> entry : themeJsonContents.entrySet()) {
            if (ThemeValidationUtil.hasNewAssetsOrImports(statsThemeJson, entry)) {
                ThemeValidationUtil.getLogger().info("Found new configuration for theme '{}' in 'theme.json'.", (Object)entry.getKey());
                return true;
            }
            if (!statsThemeJson.has(entry.getKey())) continue;
            ArrayList<String> missedKeys = new ArrayList<String>();
            ObjectNode content = JacksonUtils.readTree(statsThemeJson.get(entry.getKey()).textValue());
            if (ThemeValidationUtil.objectIncludesEntry((JsonNode)content, entry.getValue(), missedKeys)) continue;
            ThemeValidationUtil.getLogger().info("Custom theme '{}' has imports/assets removed or added in 'theme.json' not represented in the bundle ('stats.json').", (Object)entry.getKey());
            ThemeValidationUtil.logMissedEntries(missedKeys);
            return true;
        }
        return false;
    }

    public static boolean themeShadowDOMStylesheetsChanged(Options options, JsonNode statsJson, FrontendDependenciesScanner frontendDependencies) {
        File frontendDirectory = options.getFrontendDirectory();
        Set themeComponentsDirs = Optional.ofNullable(frontendDependencies.getThemeDefinition()).map(ThemeDefinition::getName).filter(name -> !name.isBlank()).map(themeName -> {
            HashMap themeJsonContents = new HashMap();
            ThemeUtils.getThemeJson(themeName, frontendDirectory).ifPresent(themeJson -> ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, themeName, themeJson));
            return themeJsonContents.keySet().stream().map(name -> ThemeUtils.getThemeFolder(frontendDirectory, name)).map(dir -> new File((File)dir, "components")).filter(File::exists).map(File::toPath).collect(Collectors.toSet());
        }).orElse(null);
        if (themeComponentsDirs != null) {
            HashMap hashesWithNoComponentCssMatches = new HashMap();
            if (statsJson.has(FRONTEND_HASHES_KEY)) {
                JsonNode json = statsJson.get(FRONTEND_HASHES_KEY);
                JacksonUtils.getKeys(json).stream().filter(path -> themeComponentsDirs.stream().anyMatch(dir -> frontendDirectory.toPath().resolve((String)path).startsWith((Path)dir))).forEach(key -> hashesWithNoComponentCssMatches.put(key, json.get(key).textValue()));
            }
            ArrayList<String> themeComponentsCssFiles = new ArrayList<String>();
            for (Path dir : themeComponentsDirs) {
                try {
                    FileIOUtils.listFiles(dir.toFile(), new String[]{"css"}, true).stream().filter(themeFile -> ThemeValidationUtil.isFrontendResourceChangedOrMissingInBundle(hashesWithNoComponentCssMatches, frontendDirectory, themeFile)).map(f -> frontendDirectory.toPath().relativize(f.toPath()).toString().replaceAll("\\\\", "/")).collect(Collectors.toCollection(() -> themeComponentsCssFiles));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not list theme CSS files in " + String.valueOf(dir), e);
                }
            }
            if (!themeComponentsCssFiles.isEmpty()) {
                BundleValidationUtil.logChangedFiles(themeComponentsCssFiles, "Detected new or changed theme components CSS files");
            }
            if (!hashesWithNoComponentCssMatches.isEmpty()) {
                BundleValidationUtil.logChangedFiles(new ArrayList<String>(hashesWithNoComponentCssMatches.keySet()), "Detected removed theme components CSS files");
            }
            return !themeComponentsCssFiles.isEmpty() || !hashesWithNoComponentCssMatches.isEmpty();
        }
        return false;
    }

    private static boolean hasNewAssetsOrImports(JsonNode contentsInStats, Map.Entry<String, JsonNode> themeContent) {
        JsonNode json = themeContent.getValue();
        int keys = JacksonUtils.getKeys(json).size();
        boolean moreThanOneKey = keys > 1;
        boolean noParentEntry = keys == 1 && !json.has("parent");
        return !contentsInStats.has(themeContent.getKey()) && (moreThanOneKey || noParentEntry);
    }

    private static void collectThemeJsonContentsInFrontend(Options options, Map<String, JsonNode> themeJsonContents, String themeName, JsonNode themeJson) {
        Optional<String> parentThemeInFrontend = ThemeUtils.getParentThemeName(themeJson);
        if (parentThemeInFrontend.isPresent()) {
            String parentThemeName = parentThemeInFrontend.get();
            Optional<JsonNode> parentThemeJson = ThemeUtils.getThemeJson(parentThemeName, options.getFrontendDirectory());
            parentThemeJson.ifPresent(jsonObject -> ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, parentThemeName, jsonObject));
        }
        themeJsonContents.put(themeName, themeJson);
    }

    static boolean objectIncludesEntry(JsonNode jsonFromBundle, JsonNode projectJson, Collection<String> missedKeys) {
        JsonNodeType bundleJsonNodeType = jsonFromBundle.getNodeType();
        JsonNodeType projectJsonNodeTypeType = projectJson.getNodeType();
        assert (bundleJsonNodeType.equals((Object)projectJsonNodeTypeType));
        if (bundleJsonNodeType == JsonNodeType.NULL) {
            return true;
        }
        if (bundleJsonNodeType == JsonNodeType.BOOLEAN) {
            return JacksonUtils.booleanEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonNodeType == JsonNodeType.NUMBER) {
            return JacksonUtils.numbersEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonNodeType == JsonNodeType.STRING) {
            return JacksonUtils.stringEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonNodeType == JsonNodeType.ARRAY) {
            ArrayNode jsonArrayFromBundle = (ArrayNode)jsonFromBundle;
            ArrayNode jsonArrayFromProject = (ArrayNode)projectJson;
            return ThemeValidationUtil.compareArrays(missedKeys, jsonArrayFromBundle, jsonArrayFromProject);
        }
        if (bundleJsonNodeType == JsonNodeType.OBJECT) {
            return ThemeValidationUtil.compareObjects(missedKeys, jsonFromBundle, projectJson);
        }
        throw new IllegalArgumentException("Unsupported JsonNodeType: " + String.valueOf(bundleJsonNodeType));
    }

    private static void logMissedEntries(List<String> missedKeys) {
        Collections.reverse(missedKeys);
        BundleValidationUtil.logChangedFiles(missedKeys, "Detected missed or added entries:");
    }

    private static void getPackagedThemeJsonContents(File jarFileToLookup, Map<String, JsonNode> packagedThemeHashes) {
        JarContentsManager jarContentsManager = new JarContentsManager();
        if (jarContentsManager.containsPath(jarFileToLookup, "META-INF/resources/themes/")) {
            List<String> themeJsons = jarContentsManager.findFiles(jarFileToLookup, "META-INF/resources/themes/", "theme.json");
            for (String themeJson : themeJsons) {
                byte[] byteContent = jarContentsManager.getFileContents(jarFileToLookup, themeJson);
                String content = StringUtil.toUTF8String(byteContent);
                content = content.replaceAll("\\r\\n", "\n");
                Matcher matcher = THEME_PATH_PATTERN.matcher(themeJson);
                if (!matcher.find()) {
                    throw new IllegalStateException("Packaged theme folders structure is incorrect, should have META-INF/resources/themes/[theme-name]/");
                }
                String themeName = matcher.group(1);
                ObjectNode jsonContent = null;
                jsonContent = JacksonUtils.readTree(content);
                packagedThemeHashes.put(themeName, (JsonNode)jsonContent);
            }
        }
    }

    private static boolean compareObjects(Collection<String> missedKeys, JsonNode jsonObjectFromBundle, JsonNode projectJsonNode) {
        boolean allEntriesFound = true;
        for (String projectEntryKey : JacksonUtils.getKeys(projectJsonNode)) {
            JsonNode projectEntry = projectJsonNode.get(projectEntryKey);
            if (projectEntry.getNodeType() == JsonNodeType.STRING && "parent".equals(projectEntryKey)) continue;
            boolean entryFound = false;
            for (String bundleEntryKey : JacksonUtils.getKeys(jsonObjectFromBundle)) {
                JsonNode bundleEntry = jsonObjectFromBundle.get(bundleEntryKey);
                if (bundleEntry.getNodeType() != projectEntry.getNodeType() || !ThemeValidationUtil.objectIncludesEntry(bundleEntry, projectEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(projectEntryKey);
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private static boolean compareArrays(Collection<String> missedKeys, ArrayNode jsonArrayFromBundle, ArrayNode jsonArrayFromProject) {
        boolean allEntriesFound = ThemeValidationUtil.checkMissedKeys(missedKeys, jsonArrayFromBundle, jsonArrayFromProject);
        if (jsonArrayFromBundle.size() != jsonArrayFromProject.size()) {
            allEntriesFound = allEntriesFound && ThemeValidationUtil.checkMissedKeys(missedKeys, jsonArrayFromProject, jsonArrayFromBundle);
        }
        return allEntriesFound;
    }

    private static boolean checkMissedKeys(Collection<String> missedKeys, ArrayNode arrayIterating, ArrayNode arrayComparing) {
        boolean allEntriesFound = true;
        for (int arrayComparingIndex = 0; arrayComparingIndex < arrayComparing.size(); ++arrayComparingIndex) {
            JsonNode arrayComparingEntry = arrayComparing.get(arrayComparingIndex);
            boolean entryFound = false;
            for (int arrayIteratingIndex = 0; arrayIteratingIndex < arrayIterating.size(); ++arrayIteratingIndex) {
                JsonNode arrayIteratingEntry = arrayIterating.get(arrayIteratingIndex);
                if (arrayIteratingEntry.getNodeType() != arrayComparingEntry.getNodeType() || !ThemeValidationUtil.objectIncludesEntry(arrayIteratingEntry, arrayComparingEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(arrayComparingEntry.toString());
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private static boolean isFrontendResourceChangedOrMissingInBundle(Map<String, String> bundledHashes, File frontendFolder, File frontendResource) {
        String relativePath = frontendFolder.toPath().relativize(frontendResource.toPath()).toString().replaceAll("\\\\", "/");
        boolean presentInBundle = bundledHashes.containsKey(relativePath);
        if (presentInBundle) {
            String contentHash;
            try {
                contentHash = BundleValidationUtil.calculateHash(Files.readString(frontendResource.toPath(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return !bundledHashes.remove(relativePath).equals(contentHash);
        }
        return true;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ThemeValidationUtil.class);
    }
}

