/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared;

import java.io.Serializable;

@Deprecated
public class BrowserDetails
implements Serializable {
    private static final String CHROME = " chrome/";
    private static final String HEADLESSCHROME = " headlesschrome/";
    private static final String OS_MAJOR = "OS major";
    private static final String OS_MINOR = "OS minor";
    private static final String BROWSER_MAJOR = "Browser major";
    private static final String BROWSER_MINOR = "Browser minor";
    private BrowserName browserName;
    private BrowserEngine browserEngine;
    private boolean isWindowsPhone;
    private boolean isIPad;
    private boolean isIPhone;
    private boolean isChromeOS;
    private OperatingSystem os;
    private float browserEngineVersion = -10.0f;
    private int browserMajorVersion = -10;
    private int browserMinorVersion = -10;
    private int osMajorVersion = -10;
    private int osMinorVersion = -10;
    private String userAgent;

    public BrowserDetails(String userAgentString) {
        this.userAgent = userAgentString.toLowerCase();
    }

    private void parseBrowserEngine() {
        this.browserEngine = this.userAgent.contains("gecko") && !this.userAgent.contains("webkit") && !this.userAgent.contains("trident/") ? BrowserEngine.GECKO : (this.userAgent.contains(" presto/") ? BrowserEngine.PRESTO : (this.userAgent.contains("trident/") ? BrowserEngine.TRIDENT : (!this.userAgent.contains("trident/") && this.userAgent.contains("applewebkit") ? BrowserEngine.WEBKIT : BrowserEngine.UNKNOWN)));
    }

    private void parseBrowserName() {
        this.browserName = this.userAgent.contains(" edge/") || this.userAgent.contains(" edg/") || this.userAgent.contains(" edga/") || this.userAgent.contains(" edgios/") ? BrowserName.EDGE : ((this.userAgent.contains(CHROME) || this.userAgent.contains(" crios/") || this.userAgent.contains(HEADLESSCHROME)) && !this.userAgent.contains(" opr/") ? BrowserName.CHROME : (this.userAgent.contains("opera") || this.userAgent.contains(" opr/") ? BrowserName.OPERA : (this.userAgent.contains("msie") && !this.userAgent.contains("webtv") || this.userAgent.contains("trident/") ? BrowserName.IE : (this.userAgent.contains(" firefox/") || this.userAgent.contains("fxios/") ? BrowserName.FIREFOX : (this.userAgent.contains("safari") ? BrowserName.SAFARI : BrowserName.UNKNOWN)))));
    }

    private void parseEngineVersion() {
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        try {
            if (this.browserEngine.equals((Object)BrowserEngine.GECKO)) {
                int rvPos = this.userAgent.indexOf("rv:");
                if (rvPos >= 0) {
                    String tmp = this.userAgent.substring(rvPos + 3);
                    tmp = tmp.replaceFirst("(\\.[0-9]+).+", "$1");
                    this.browserEngineVersion = Float.parseFloat(tmp);
                }
            } else if (this.browserEngine.equals((Object)BrowserEngine.WEBKIT)) {
                String tmp = this.userAgent.substring(this.userAgent.indexOf("webkit/") + 7);
                tmp = tmp.replaceFirst("([0-9]+\\.[0-9]+).*", "$1");
                this.browserEngineVersion = Float.parseFloat(tmp);
            } else if (this.browserEngine.equals((Object)BrowserEngine.TRIDENT)) {
                String tmp = this.userAgent.substring(this.userAgent.indexOf("trident/") + 8);
                tmp = tmp.replaceFirst("([0-9]+\\.[0-9]+).*", "$1");
                this.browserEngineVersion = Float.parseFloat(tmp);
                if (this.browserEngineVersion > 7.0f) {
                    this.browserEngineVersion = 7.0f;
                }
            } else {
                this.browserEngineVersion = this.browserName != null && this.browserName.equals((Object)BrowserName.EDGE) ? 0.0f : -1.0f;
            }
        }
        catch (Exception e) {
            this.log("Browser engine version parsing failed for: " + this.userAgent, e);
        }
    }

    private void parseBrowserVersion() {
        this.browserMajorVersion = -1;
        this.browserMinorVersion = -1;
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        try {
            if (this.browserName.equals((Object)BrowserName.IE)) {
                if (!this.userAgent.contains("msie")) {
                    int rvPos = this.userAgent.indexOf("rv:");
                    if (rvPos >= 0) {
                        String tmp = this.userAgent.substring(rvPos + 3);
                        tmp = tmp.replaceFirst("(\\.[0-9]+).+", "$1");
                        this.parseVersionString(tmp, this.userAgent);
                    }
                } else if (this.browserEngine.equals((Object)BrowserEngine.TRIDENT)) {
                    this.browserMajorVersion = 4 + (int)this.browserEngineVersion;
                    this.browserMinorVersion = 0;
                } else {
                    String ieVersionString = this.userAgent.substring(this.userAgent.indexOf("msie ") + 5);
                    ieVersionString = BrowserDetails.safeSubstring(ieVersionString, 0, ieVersionString.indexOf(59));
                    this.parseVersionString(ieVersionString, this.userAgent);
                }
            } else if (this.browserName.equals((Object)BrowserName.FIREFOX)) {
                int i = this.userAgent.indexOf(" fxios/");
                i = i != -1 ? this.userAgent.indexOf(" fxios/") + 7 : this.userAgent.indexOf(" firefox/") + 9;
                this.parseVersionString(BrowserDetails.safeSubstring(this.userAgent, i, i + BrowserDetails.getVersionStringLength(this.userAgent, i)), this.userAgent);
            } else if (this.browserName.equals((Object)BrowserName.CHROME)) {
                this.parseChromeVersion(this.userAgent);
            } else if (this.browserName.equals((Object)BrowserName.SAFARI)) {
                int i = this.userAgent.indexOf(" version/");
                if (i >= 0) {
                    this.parseVersionString(BrowserDetails.safeSubstring(this.userAgent, i += 9, i + BrowserDetails.getVersionStringLength(this.userAgent, i)), this.userAgent);
                } else {
                    int engineVersion;
                    if (this.browserEngineVersion == -10.0f) {
                        this.parseEngineVersion();
                    }
                    if ((engineVersion = (int)(this.browserEngineVersion * 10.0f)) >= 6010 && engineVersion < 6015) {
                        this.browserMajorVersion = 9;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6015 && engineVersion < 6018) {
                        this.browserMajorVersion = 9;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6020 && engineVersion < 6030) {
                        this.browserMajorVersion = 10;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6030 && engineVersion < 6040) {
                        this.browserMajorVersion = 10;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6040 && engineVersion < 6050) {
                        this.browserMajorVersion = 11;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6050 && engineVersion < 6060) {
                        this.browserMajorVersion = 11;
                        this.browserMinorVersion = 1;
                    } else if (engineVersion >= 6060 && engineVersion < 6070) {
                        this.browserMajorVersion = 12;
                        this.browserMinorVersion = 0;
                    } else if (engineVersion >= 6070) {
                        this.browserMajorVersion = 12;
                        this.browserMinorVersion = 1;
                    }
                }
            } else if (this.browserName.equals((Object)BrowserName.OPERA)) {
                int i = this.userAgent.indexOf(" version/");
                i = i != -1 ? (i += 9) : (this.userAgent.contains(" opr/") ? this.userAgent.indexOf(" opr/") + 5 : this.userAgent.indexOf("opera/") + 6);
                this.parseVersionString(BrowserDetails.safeSubstring(this.userAgent, i, i + BrowserDetails.getVersionStringLength(this.userAgent, i)), this.userAgent);
            } else if (this.browserName.equals((Object)BrowserName.EDGE)) {
                int i = this.userAgent.indexOf(" edge/") + 6;
                if (this.userAgent.contains(" edg/")) {
                    i = this.userAgent.indexOf(" edg/") + 5;
                } else if (this.userAgent.contains(" edga/")) {
                    i = this.userAgent.indexOf(" edga/") + 6;
                } else if (this.userAgent.contains(" edgios/")) {
                    i = this.userAgent.indexOf(" edgios/") + 8;
                }
                this.parseVersionString(BrowserDetails.safeSubstring(this.userAgent, i, i + BrowserDetails.getVersionStringLength(this.userAgent, i)), this.userAgent);
            }
        }
        catch (Exception e) {
            this.log("Browser version parsing failed for: " + this.userAgent, e);
        }
    }

    private void parseOperatingSystem() {
        if (this.userAgent.contains("windows ")) {
            this.os = OperatingSystem.WINDOWS;
            this.isWindowsPhone = this.userAgent.contains("windows phone");
        } else if (this.userAgent.contains("android")) {
            this.os = OperatingSystem.ANDROID;
            this.parseAndroidVersion(this.userAgent);
        } else if (this.userAgent.contains("linux")) {
            this.os = OperatingSystem.LINUX;
        } else if (this.userAgent.contains("macintosh") || this.userAgent.contains("mac osx") || this.userAgent.contains("mac os x")) {
            this.isIPad = this.userAgent.contains("ipad");
            this.isIPhone = this.userAgent.contains("iphone");
            if (this.isIPad || this.isIPhone) {
                this.os = OperatingSystem.IOS;
                this.parseIOSVersion(this.userAgent);
            } else {
                this.os = OperatingSystem.MACOSX;
            }
        } else if (this.userAgent.contains("; cros ")) {
            this.os = OperatingSystem.CHROMEOS;
            this.isChromeOS = true;
            this.parseChromeOSVersion(this.userAgent);
        } else {
            this.os = OperatingSystem.UNKNOWN;
        }
    }

    private void parseChromeOSVersion(String userAgent) {
        int cur;
        int start = userAgent.indexOf("; cros ");
        if (start == -1) {
            return;
        }
        int end = userAgent.indexOf(41, start);
        if (end == -1) {
            return;
        }
        for (cur = end; cur >= start && userAgent.charAt(cur) != ' '; --cur) {
        }
        if (cur == start) {
            return;
        }
        String osVersionString = userAgent.substring(cur + 1, end);
        String[] parts = osVersionString.split("\\.");
        this.parseChromeOsVersionParts(parts, userAgent);
    }

    private void parseChromeOsVersionParts(String[] parts, String userAgent) {
        this.osMajorVersion = -1;
        this.osMinorVersion = -1;
        if (parts.length > 2) {
            this.osMajorVersion = this.parseVersionPart(parts[0], OS_MAJOR, userAgent);
            this.osMinorVersion = this.parseVersionPart(parts[1], OS_MINOR, userAgent);
        }
    }

    private void parseChromeVersion(String userAgent) {
        String crios = " crios/";
        int i = userAgent.indexOf(" crios/");
        if (i == -1) {
            i = userAgent.indexOf(CHROME);
            i = i == -1 ? userAgent.indexOf(HEADLESSCHROME) + HEADLESSCHROME.length() : (i += CHROME.length());
            int versionBreak = BrowserDetails.getVersionStringLength(userAgent, i);
            this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + versionBreak), userAgent);
        } else {
            int versionBreak = BrowserDetails.getVersionStringLength(userAgent, i += " crios/".length());
            this.parseVersionString(BrowserDetails.safeSubstring(userAgent, i, i + versionBreak), userAgent);
        }
    }

    private static int getVersionStringLength(String userAgent, int startIndex) {
        String versionSubString = userAgent.substring(startIndex);
        int versionBreak = versionSubString.indexOf(" ");
        if (versionBreak == -1) {
            versionBreak = versionSubString.length();
        }
        return versionBreak;
    }

    private void parseAndroidVersion(String userAgent) {
        if (!userAgent.contains("android ")) {
            this.osMajorVersion = -1;
            this.osMinorVersion = -1;
            return;
        }
        if (userAgent.contains("ddg_android/")) {
            int startIndex = userAgent.indexOf("ddg_android/");
            String osVersionString = BrowserDetails.safeSubstring(userAgent, startIndex + "ddg_android/".length(), userAgent.indexOf(32, startIndex));
            String[] parts = osVersionString.split("\\.");
            this.parseOsVersion(parts, userAgent);
            return;
        }
        if (userAgent.contains("callpod keeper for android")) {
            String token = "; android ";
            int startIndex = userAgent.indexOf(token) + token.length();
            int endIndex = userAgent.indexOf(";", startIndex);
            String osVersionString = BrowserDetails.safeSubstring(userAgent, startIndex, endIndex);
            String[] parts = osVersionString.split("\\.");
            this.parseOsVersion(parts, userAgent);
            return;
        }
        String osVersionString = BrowserDetails.safeSubstring(userAgent, userAgent.indexOf("android ") + "android ".length(), userAgent.length());
        int semicolonIndex = osVersionString.indexOf(";");
        int bracketIndex = osVersionString.indexOf(")");
        int endIndex = semicolonIndex != -1 && semicolonIndex < bracketIndex ? semicolonIndex : bracketIndex;
        osVersionString = BrowserDetails.safeSubstring(osVersionString, 0, endIndex);
        String[] parts = osVersionString.split("\\.");
        this.parseOsVersion(parts, userAgent);
    }

    private void parseIOSVersion(String userAgent) {
        if (!userAgent.contains("os ") || !userAgent.contains(" like mac")) {
            this.osMajorVersion = -1;
            this.osMinorVersion = -1;
            return;
        }
        String osVersionString = BrowserDetails.safeSubstring(userAgent, userAgent.indexOf("os ") + 3, userAgent.indexOf(" like mac"));
        String[] parts = osVersionString.split("_");
        this.parseOsVersion(parts, userAgent);
    }

    private void parseOsVersion(String[] parts, String userAgent) {
        this.osMajorVersion = -1;
        this.osMinorVersion = -1;
        if (parts.length >= 1) {
            this.osMajorVersion = this.parseVersionPart(parts[0], OS_MAJOR, userAgent);
        }
        if (parts.length >= 2) {
            int dashIndex = parts[1].indexOf(45);
            if (dashIndex > -1) {
                String dashlessVersion = parts[1].substring(0, dashIndex);
                this.osMinorVersion = this.parseVersionPart(dashlessVersion, OS_MINOR, userAgent);
            } else {
                this.osMinorVersion = this.parseVersionPart(parts[1], OS_MINOR, userAgent);
            }
        }
    }

    private void parseVersionString(String versionString, String userAgent) {
        int idx = versionString.indexOf(46);
        if (idx < 0) {
            idx = versionString.length();
        }
        String majorVersionPart = BrowserDetails.safeSubstring(versionString, 0, idx);
        this.browserMajorVersion = this.parseVersionPart(majorVersionPart, BROWSER_MAJOR, userAgent);
        if (this.browserMajorVersion == -1) {
            return;
        }
        int idx2 = versionString.indexOf(46, idx + 1);
        if (idx2 < 0) {
            if (versionString.substring(idx).length() == 0) {
                this.browserMinorVersion = 0;
                return;
            }
            idx2 = versionString.length();
        }
        String minorVersionPart = BrowserDetails.safeSubstring(versionString, idx + 1, idx2).replaceAll("[^0-9].*", "");
        this.browserMinorVersion = this.parseVersionPart(minorVersionPart, BROWSER_MINOR, userAgent);
    }

    private static String safeSubstring(String string, int beginIndex, int endIndex) {
        int trimmedStart = beginIndex < 0 ? 0 : beginIndex;
        int trimmedEnd = endIndex < 0 || endIndex > string.length() ? string.length() : endIndex;
        return string.substring(trimmedStart, trimmedEnd);
    }

    private int parseVersionPart(String versionString, String partName, String userAgent) {
        try {
            return Integer.parseInt(versionString);
        }
        catch (Exception e) {
            this.log(partName + " version parsing failed for: \"" + versionString + "\"\nWith userAgent: " + userAgent, e);
            return -1;
        }
    }

    public boolean isFirefox() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.FIREFOX);
    }

    public boolean isGecko() {
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        return this.browserEngine.equals((Object)BrowserEngine.GECKO);
    }

    public boolean isWebKit() {
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        return this.browserEngine.equals((Object)BrowserEngine.WEBKIT);
    }

    public boolean isPresto() {
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        return this.browserEngine.equals((Object)BrowserEngine.PRESTO);
    }

    public boolean isTrident() {
        if (this.browserEngine == null) {
            this.parseBrowserEngine();
        }
        return this.browserEngine.equals((Object)BrowserEngine.TRIDENT);
    }

    public boolean isSafari() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.SAFARI);
    }

    public boolean isChrome() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.CHROME);
    }

    public boolean isOpera() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.OPERA);
    }

    public boolean isIE() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.IE);
    }

    public boolean isEdge() {
        if (this.browserName == null) {
            this.parseBrowserName();
        }
        return this.browserName.equals((Object)BrowserName.EDGE);
    }

    public float getBrowserEngineVersion() {
        if (this.browserEngineVersion == -10.0f) {
            this.parseEngineVersion();
        }
        return this.browserEngineVersion;
    }

    public final int getBrowserMajorVersion() {
        if (this.browserMajorVersion == -10) {
            this.parseBrowserVersion();
        }
        return this.browserMajorVersion;
    }

    public final int getBrowserMinorVersion() {
        if (this.browserMinorVersion == -10) {
            this.parseBrowserVersion();
        }
        return this.browserMinorVersion;
    }

    private OperatingSystem getOs() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.os;
    }

    public boolean isWindows() {
        return this.getOs().equals((Object)OperatingSystem.WINDOWS);
    }

    public boolean isWindowsPhone() {
        return this.isWindowsPhone;
    }

    public boolean isMacOSX() {
        return this.getOs().equals((Object)OperatingSystem.MACOSX);
    }

    public boolean isLinux() {
        return this.getOs().equals((Object)OperatingSystem.LINUX);
    }

    public boolean isAndroid() {
        return this.getOs().equals((Object)OperatingSystem.ANDROID);
    }

    public boolean isIPhone() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.isIPhone;
    }

    public boolean isIPad() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.isIPad;
    }

    public boolean isChromeOS() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.isChromeOS;
    }

    public int getOperatingSystemMajorVersion() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.osMajorVersion;
    }

    public int getOperatingSystemMinorVersion() {
        if (this.os == null) {
            this.parseOperatingSystem();
        }
        return this.osMinorVersion;
    }

    public boolean isTooOldToFunctionProperly() {
        if (this.isIE()) {
            return true;
        }
        if (this.isEdge() && this.getBrowserMajorVersion() < 79) {
            return true;
        }
        if (this.isSafari() && this.getBrowserMajorVersion() < 14) {
            return !this.isIPhone() || this.getOperatingSystemMajorVersion() <= 14 && (this.getOperatingSystemMajorVersion() != 14 || this.getOperatingSystemMinorVersion() < 7);
        }
        if (this.isFirefox() && this.getBrowserMajorVersion() < 78) {
            return true;
        }
        if (this.isOpera() && this.getBrowserMajorVersion() < 58) {
            return true;
        }
        return this.isChrome() && this.getBrowserMajorVersion() < 71;
    }

    protected void log(String error, Exception e) {
        System.err.println(error + " " + e.getMessage());
    }

    public static enum BrowserEngine {
        UNKNOWN,
        GECKO,
        WEBKIT,
        PRESTO,
        TRIDENT;

    }

    public static enum BrowserName {
        UNKNOWN,
        SAFARI,
        CHROME,
        FIREFOX,
        OPERA,
        IE,
        EDGE;

    }

    public static enum OperatingSystem {
        UNKNOWN,
        WINDOWS,
        MACOSX,
        LINUX,
        IOS,
        ANDROID,
        CHROMEOS;

    }
}

