/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.BeanUtil;
import com.vaadin.flow.shared.Registration;
import java.beans.IntrospectionException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import tools.jackson.core.type.TypeReference;

public interface DomListenerRegistration
extends Registration {
    public DomListenerRegistration addEventData(String var1);

    public DomListenerRegistration setFilter(String var1);

    public String getFilter();

    public DomListenerRegistration setDisabledUpdateMode(DisabledUpdateMode var1);

    public DomListenerRegistration debounce(int var1, DebouncePhase var2, DebouncePhase ... var3);

    default public DomListenerRegistration debounce(int timeout) {
        return this.debounce(timeout, DebouncePhase.TRAILING, new DebouncePhase[0]);
    }

    default public DomListenerRegistration throttle(int period) {
        return this.debounce(period, DebouncePhase.LEADING, DebouncePhase.INTERMEDIATE);
    }

    default public int getDebounceTimeout() {
        throw new UnsupportedOperationException();
    }

    default public Set<DebouncePhase> getDebouncePhases() {
        throw new UnsupportedOperationException();
    }

    default public String getEventType() {
        throw new UnsupportedOperationException();
    }

    default public DomListenerRegistration onUnregister(SerializableRunnable unregisterHandler) {
        throw new UnsupportedOperationException();
    }

    default public DomListenerRegistration synchronizeProperty(String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("Property name must be given");
        }
        return this.addEventData("}" + propertyName);
    }

    default public DomListenerRegistration mapEventTargetElement() {
        return this.addEventData("]");
    }

    default public DomListenerRegistration addEventDataElement(String eventData) {
        Objects.requireNonNull(eventData);
        if (Objects.equals(eventData, "event.target")) {
            return this.mapEventTargetElement();
        }
        return this.addEventData("]" + eventData);
    }

    default public DomListenerRegistration stopPropagation() {
        this.addEventData("event.stopPropagation()");
        return this;
    }

    default public DomListenerRegistration preventDefault() {
        this.addEventData("event.preventDefault()");
        return this;
    }

    default public DomListenerRegistration addEventData(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        try {
            List<String> propertyPaths = BeanUtil.getBeanPropertyPaths(type);
            for (String path : propertyPaths) {
                this.addEventData(path);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Failed to introspect type: " + type.getName(), e);
        }
        return this;
    }

    default public DomListenerRegistration addEventData(TypeReference<?> typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException("Type reference cannot be null");
        }
        Class<?> rawType = DomListenerRegistration.extractRawType(typeReference);
        if (rawType != null) {
            this.addEventData(rawType);
        }
        return this;
    }

    private static Class<?> extractRawType(TypeReference<?> typeReference) {
        ParameterizedType paramType;
        if (typeReference.getType() instanceof Class) {
            return (Class)typeReference.getType();
        }
        if (typeReference.getType() instanceof ParameterizedType && (paramType = (ParameterizedType)typeReference.getType()).getRawType() instanceof Class) {
            return (Class)paramType.getRawType();
        }
        return null;
    }

    public DomListenerRegistration allowInert();
}

