/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.internal.DeadlockDetectingCompletableFuture;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;

public interface PendingJavaScriptResult
extends Serializable {
    public boolean cancelExecution();

    public boolean isSentToBrowser();

    default public <T> void then(Class<T> targetType, SerializableConsumer<T> resultHandler, SerializableConsumer<String> errorHandler) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type cannot be null");
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException("Result handler cannot be null");
        }
        SerializableConsumer convertingResultHandler = value -> resultHandler.accept(JacksonCodec.decodeAs(value, targetType));
        this.then(convertingResultHandler, errorHandler);
    }

    default public <T> void then(Class<T> targetType, SerializableConsumer<T> resultHandler) {
        this.then(targetType, resultHandler, null);
    }

    default public <T> CompletableFuture<T> toCompletableFuture(Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("Target type cannot be null");
        }
        VaadinSession session = VaadinSession.getCurrent();
        DeadlockDetectingCompletableFuture completableFuture = new DeadlockDetectingCompletableFuture(session);
        this.then(value -> {
            Object convertedValue = JacksonCodec.decodeAs(value, targetType);
            completableFuture.complete(convertedValue);
        }, errorValue -> {
            JavaScriptException exception = new JavaScriptException((String)errorValue);
            completableFuture.completeExceptionally(exception);
        });
        return completableFuture;
    }

    default public <T> void then(TypeReference<T> typeReference, SerializableConsumer<T> resultHandler, SerializableConsumer<String> errorHandler) {
        if (typeReference == null) {
            throw new IllegalArgumentException("Type reference cannot be null");
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException("Result handler cannot be null");
        }
        SerializableConsumer convertingResultHandler = value -> resultHandler.accept(JacksonCodec.decodeAs(value, typeReference));
        this.then(convertingResultHandler, errorHandler);
    }

    default public <T> void then(TypeReference<T> typeReference, SerializableConsumer<T> resultHandler) {
        this.then(typeReference, resultHandler, null);
    }

    default public <T> CompletableFuture<T> toCompletableFuture(TypeReference<T> typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException("Type reference cannot be null");
        }
        VaadinSession session = VaadinSession.getCurrent();
        DeadlockDetectingCompletableFuture completableFuture = new DeadlockDetectingCompletableFuture(session);
        this.then(value -> {
            Object convertedValue = JacksonCodec.decodeAs(value, typeReference);
            completableFuture.complete(convertedValue);
        }, errorValue -> {
            JavaScriptException exception = new JavaScriptException((String)errorValue);
            completableFuture.completeExceptionally(exception);
        });
        return completableFuture;
    }

    public void then(SerializableConsumer<JsonNode> var1, SerializableConsumer<String> var2);

    default public void then(SerializableConsumer<JsonNode> resultHandler) {
        this.then(resultHandler, null);
    }

    default public CompletableFuture<JsonNode> toCompletableFuture() {
        return this.toCompletableFuture(JsonNode.class);
    }

    public static class JavaScriptException
    extends RuntimeException {
        public JavaScriptException(String message) {
            super(message);
        }
    }
}

