/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class Page
implements Serializable {
    private final UI ui;
    private final History history;
    private DomListenerRegistration resizeReceiver;
    private ArrayList<BrowserWindowResizeListener> resizeListeners;

    public Page(UI ui) {
        this.ui = ui;
        this.history = new History(ui);
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Cannot set a null page title.");
        }
        this.ui.getInternals().setTitle(title);
    }

    public Registration addStyleSheet(String url) {
        return this.addStyleSheet(url, LoadMode.EAGER);
    }

    public Registration addStyleSheet(String url, LoadMode loadMode) {
        DependencyList dependencyList = this.ui.getInternals().getDependencyList();
        Dependency existing = dependencyList.getDependencyByUrl(url, Dependency.Type.STYLESHEET);
        String dependencyId = existing != null && existing.getId() != null ? existing.getId() : UUID.randomUUID().toString();
        Dependency dependency = new Dependency(Dependency.Type.STYLESHEET, url, loadMode, dependencyId);
        dependencyList.add(dependency);
        return () -> this.ui.getInternals().removeStyleSheet(dependencyId);
    }

    public void addJavaScript(String url) {
        this.addJavaScript(url, LoadMode.EAGER);
    }

    public void addJavaScript(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.JAVASCRIPT, url, loadMode));
    }

    public void addJsModule(String url) {
        if (!UrlUtil.isExternal(url) && !url.startsWith("/")) {
            throw new IllegalArgumentException("url argument must contains either a protocol (eg. starts with \"http://\" or \"//\"), or starts with \"/\".");
        }
        this.addDependency(new Dependency(Dependency.Type.JS_MODULE, url, LoadMode.EAGER));
    }

    public void addDynamicImport(String expression) {
        this.addDependency(new Dependency(Dependency.Type.DYNAMIC_IMPORT, expression));
    }

    public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
        UIInternals.JavaScriptInvocation invocation = new UIInternals.JavaScriptInvocation(expression, parameters);
        PendingJavaScriptInvocation execution = new PendingJavaScriptInvocation(this.ui.getInternals().getStateTree().getRootNode(), invocation);
        this.ui.getInternals().addJavaScriptInvocation(execution);
        return execution;
    }

    @Deprecated
    public PendingJavaScriptResult executeJs(String expression, Serializable[] parameters) {
        return this.executeJs(expression, (Object[])parameters);
    }

    public History getHistory() {
        return this.history;
    }

    public void reload() {
        this.executeJs("window.location.reload();", new Object[0]);
    }

    public Registration addBrowserWindowResizeListener(BrowserWindowResizeListener resizeListener) {
        Objects.requireNonNull(resizeListener);
        if (this.resizeReceiver == null) {
            this.ui.getElement().executeJs("    const el = this;\n    window.addEventListener('resize', evt => {\n        const event = new Event(\"window-resize\");\n        event.w = document.documentElement.clientWidth;\n        event.h = document.documentElement.clientHeight;\n        el.dispatchEvent(event);\n    });\n", new Object[0]);
            this.resizeReceiver = this.ui.getElement().addEventListener("window-resize", e -> {
                BrowserWindowResizeEvent evt = new BrowserWindowResizeEvent(this, e.getEventData().get("event.w").intValue(), e.getEventData().get("event.h").intValue());
                new ArrayList<BrowserWindowResizeListener>(this.resizeListeners).forEach(l -> l.browserWindowResized(evt));
            }).addEventData("event.w").addEventData("event.h").debounce(300).allowInert();
        }
        if (this.resizeListeners == null) {
            this.resizeListeners = new ArrayList(1);
        }
        this.resizeListeners.add(resizeListener);
        return () -> this.resizeListeners.remove(resizeListener);
    }

    public void open(String url) {
        this.open(url, "_blank");
    }

    public void open(String url, String windowName) {
        this.executeJs("if ($1 == '_self') this.stopApplication(); window.open($0, $1)", url, windowName);
    }

    public void setLocation(String uri) {
        this.open(uri, "_self");
    }

    public void setLocation(URI uri) {
        this.setLocation(uri.toString());
    }

    private void addDependency(Dependency dependency) {
        assert (dependency != null);
        this.ui.getInternals().getDependencyList().add(dependency);
    }

    public void retrieveExtendedClientDetails(ExtendedClientDetailsReceiver receiver) {
        ExtendedClientDetails cachedDetails = this.ui.getInternals().getExtendedClientDetails();
        if (cachedDetails != null) {
            receiver.receiveDetails(cachedDetails);
            return;
        }
        String js = "return Vaadin.Flow.getBrowserDetailsParameters();";
        SerializableConsumer resultHandler = json -> {
            this.handleExtendedClientDetailsResponse((JsonNode)json);
            receiver.receiveDetails(this.ui.getInternals().getExtendedClientDetails());
        };
        SerializableConsumer errorHandler = err -> {
            throw new RuntimeException("Unable to retrieve extended client details. JS error is '" + err + "'");
        };
        this.executeJs("return Vaadin.Flow.getBrowserDetailsParameters();", new Object[0]).then(resultHandler, errorHandler);
    }

    private void handleExtendedClientDetailsResponse(JsonNode json) {
        ExtendedClientDetails cachedDetails = this.ui.getInternals().getExtendedClientDetails();
        if (cachedDetails != null) {
            return;
        }
        if (!(json instanceof ObjectNode)) {
            throw new RuntimeException("Expected a JSON object");
        }
        ObjectNode jsonObj = (ObjectNode)json;
        Function<String, String> getStringElseNull = key -> {
            JsonNode jsValue = jsonObj.get(key);
            if (jsValue != null && JsonNodeType.STRING.equals((Object)jsValue.getNodeType())) {
                return jsValue.asText();
            }
            return null;
        };
        this.ui.getInternals().setExtendedClientDetails(new ExtendedClientDetails(getStringElseNull.apply("v-sw"), getStringElseNull.apply("v-sh"), getStringElseNull.apply("v-ww"), getStringElseNull.apply("v-wh"), getStringElseNull.apply("v-bw"), getStringElseNull.apply("v-bh"), getStringElseNull.apply("v-tzo"), getStringElseNull.apply("v-rtzo"), getStringElseNull.apply("v-dstd"), getStringElseNull.apply("v-dston"), getStringElseNull.apply("v-tzid"), getStringElseNull.apply("v-curdate"), getStringElseNull.apply("v-td"), getStringElseNull.apply("v-pr"), getStringElseNull.apply("v-wn"), getStringElseNull.apply("v-np")));
    }

    public void fetchCurrentURL(SerializableConsumer<URL> callback) {
        Objects.requireNonNull(callback, "Url consumer callback should not be null.");
        String js = "return window.location.href";
        this.executeJs("return window.location.href", new Object[0]).then(String.class, urlString -> {
            try {
                callback.accept(new URL((String)urlString));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Error while encoding the URL from client", e);
            }
        });
    }

    public void fetchPageDirection(SerializableConsumer<Direction> callback) {
        this.executeJs("return document.dir", new Object[0]).then(String.class, dir -> {
            Direction direction = this.getDirectionByClientName((String)dir);
            callback.accept(direction);
        });
    }

    private Direction getDirectionByClientName(String directionClientName) {
        return Arrays.stream(Direction.values()).filter(direction -> direction.getClientName().equals(directionClientName)).findFirst().orElse(Direction.LEFT_TO_RIGHT);
    }

    @FunctionalInterface
    public static interface ExtendedClientDetailsReceiver
    extends Serializable {
        public void receiveDetails(ExtendedClientDetails var1);
    }
}

