/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyList
implements Serializable {
    private final Set<String> urlCache = new HashSet<String>();
    private final Map<String, Dependency> urlToLoadedDependency = new LinkedHashMap<String, Dependency>();
    private final Map<String, Dependency> dependencyIdToDependency = new HashMap<String, Dependency>();
    private final Set<String> sentToClient = new HashSet<String>();

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)DependencyList.class.getName());
    }

    public void add(Dependency dependency) {
        String dependencyUrl = dependency.getUrl();
        if (this.urlCache.contains(dependencyUrl)) {
            Dependency currentDep;
            Optional.ofNullable(this.urlToLoadedDependency.get(dependencyUrl)).ifPresent(currentDependency -> this.handleDuplicateDependency(dependency, (Dependency)currentDependency));
            if (dependency.getId() != null && (currentDep = this.urlToLoadedDependency.get(dependencyUrl)) != null) {
                this.dependencyIdToDependency.put(dependency.getId(), currentDep);
            }
        } else {
            Dependency existing;
            this.urlCache.add(dependencyUrl);
            this.urlToLoadedDependency.put(dependencyUrl, dependency);
            if (dependency.getId() != null && (existing = this.dependencyIdToDependency.put(dependency.getId(), dependency)) != null && !existing.equals(dependency)) {
                this.getLogger().warn("Dependency ID '{}' was already used for dependency '{}', now replaced with '{}'", new Object[]{dependency.getId(), existing.getUrl(), dependency.getUrl()});
            }
        }
    }

    private void handleDuplicateDependency(Dependency newDependency, Dependency currentDependency) {
        if (newDependency.getLoadMode() != currentDependency.getLoadMode()) {
            LoadMode moreEagerLoadMode = LoadMode.values()[Math.min(newDependency.getLoadMode().ordinal(), currentDependency.getLoadMode().ordinal())];
            this.getLogger().warn("Dependency with url {} was imported with two different loading strategies: {} and {}. The dependency will be loaded as {}.", new Object[]{newDependency.getUrl(), newDependency.getLoadMode(), currentDependency.getLoadMode(), moreEagerLoadMode});
            String idToUse = currentDependency.getId() != null ? currentDependency.getId() : newDependency.getId();
            Dependency replacementDep = new Dependency(newDependency.getType(), newDependency.getUrl(), moreEagerLoadMode, idToUse);
            this.urlToLoadedDependency.replace(newDependency.getUrl(), replacementDep);
            if (idToUse != null) {
                this.dependencyIdToDependency.put(idToUse, replacementDep);
            }
        }
    }

    public Collection<Dependency> getPendingSendToClient() {
        return this.urlToLoadedDependency.values().stream().filter(dep -> !this.sentToClient.contains(dep.getUrl())).toList();
    }

    public void clearPendingSendToClient() {
        this.urlToLoadedDependency.keySet().forEach(this.sentToClient::add);
    }

    public Dependency getDependencyByUrl(String url, Dependency.Type type) {
        Dependency dep = this.urlToLoadedDependency.get(url);
        if (dep != null && dep.getType() == type) {
            return dep;
        }
        return null;
    }

    public boolean remove(String dependencyId) {
        Dependency dependency = this.dependencyIdToDependency.remove(dependencyId);
        if (dependency != null) {
            String url = dependency.getUrl();
            this.urlToLoadedDependency.remove(url);
            this.urlCache.remove(url);
            this.sentToClient.remove(url);
            return true;
        }
        return false;
    }
}

