/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.function.Predicate;

public interface MenuAccessControl
extends Serializable {
    public void setPopulateClientSideMenu(PopulateClientMenu var1);

    public PopulateClientMenu getPopulateClientSideMenu();

    default public boolean canAccessView(AvailableViewInfo viewInfo) {
        VaadinRequest request = VaadinRequest.getCurrent();
        if (request == null) {
            return !viewInfo.loginRequired();
        }
        return MenuAccessControl.canAccessView(viewInfo, request.getUserPrincipal(), request::isUserInRole);
    }

    public static boolean canAccessView(AvailableViewInfo viewInfo, Principal principal, Predicate<String> roleChecker) {
        boolean isUserAuthenticated;
        boolean bl = isUserAuthenticated = principal != null;
        if (viewInfo.loginRequired() && !isUserAuthenticated) {
            return false;
        }
        String[] roles = viewInfo.rolesAllowed();
        return roles == null || roles.length == 0 || Arrays.stream(roles).anyMatch(roleChecker);
    }

    public static enum PopulateClientMenu {
        ALWAYS,
        NEVER,
        AUTOMATIC;

    }
}

