/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.experimental;

import com.vaadin.flow.internal.UsageStatistics;
import java.io.Serializable;
import java.util.Objects;

public final class Feature
implements Serializable {
    private final String title;
    private final String id;
    private final String moreInfoLink;
    private final boolean requiresServerRestart;
    private final String componentClassName;
    private boolean enabled;

    public Feature(String title, String id, String moreInfoLink, boolean requiresServerRestart, String componentClassName) {
        this.title = Objects.requireNonNull(title);
        this.id = Objects.requireNonNull(id);
        this.moreInfoLink = moreInfoLink;
        this.requiresServerRestart = requiresServerRestart;
        this.componentClassName = componentClassName;
    }

    public Feature(Feature feature) {
        this.title = feature.getTitle();
        this.id = feature.getId();
        this.moreInfoLink = feature.getMoreInfoLink();
        this.requiresServerRestart = feature.isRequiresServerRestart();
        this.enabled = feature.enabled;
        this.componentClassName = feature.componentClassName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getMoreInfoLink() {
        return this.moreInfoLink;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public boolean isRequiresServerRestart() {
        return this.requiresServerRestart;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            UsageStatistics.markAsUsed("flow/featureflags/" + this.getId(), null);
        }
        this.enabled = enabled;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return this.id.equals(other.id);
    }
}

