/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.RpcDecoder;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;

public class StringToEnumDecoder
implements RpcDecoder {
    @Override
    public boolean isApplicable(JsonNode value, Class<?> type) {
        return value.getNodeType().equals((Object)JsonNodeType.STRING) && type.isEnum();
    }

    @Override
    public <T> T decode(JsonNode value, Class<T> type) throws RpcDecodeException {
        String stringValue = value.asText();
        T result = Enum.valueOf(type, stringValue);
        return type.cast(result);
    }
}

