/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import java.util.Optional;
import tools.jackson.databind.JsonNode;

public class EventRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "event";
    }

    @Override
    public Optional<Runnable> handleNode(StateNode node, JsonNode invocationJson) {
        assert (invocationJson.has("event"));
        String eventType = invocationJson.get("event").asText();
        JsonNode eventData = invocationJson.get("data");
        if (eventData == null) {
            eventData = JacksonUtils.createObjectNode();
        }
        DomEvent event = new DomEvent(Element.get(node), eventType, eventData);
        node.getFeature(ElementListenerMap.class).fireEvent(event);
        return Optional.empty();
    }

    @Override
    protected boolean allowInert(UI ui, JsonNode invocationJson) {
        return true;
    }
}

