/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.TargetElement;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellSettings;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppShellRegistry
implements Serializable {
    public static final String ERROR_HEADER_NO_SHELL = "%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n";
    public static final String ERROR_HEADER_OFFENDING_PWA = "%n%nWe changed the way you configure PWAs, please see this link for more info:%nhttps://vaadin.com/docs/latest/flow/advanced/modifying-the-bootstrap-page%n";
    private static final String ERROR_LINE = "  - %s from %s";
    private static final String ERROR_MULTIPLE_SHELL = "%n%nMultiple classes implementing `AppShellConfigurator` were found. However, only a single class implementing `AppShellConfigurator` is allowed.%nRemove \"implements AppShellConfigurator\" from all but one of the following classes:%n  %s%n  %s%n";
    private static final String ERROR_MULTIPLE_ANNOTATION = "%n%s is not a repeatable annotation type.%n";
    private static final String ERROR_EXTENDS_COMPONENT = "%nApp shell class is not allowed to extend Vaadin Component: %s. App shells are only intended for page configuration and are instantiated before the UI is created.%n";
    private static final String[] UNIQUE_ELEMENTS = new String[]{"meta[name=viewport]", "meta[name=description]", "title", "base"};
    private static final Logger log = LoggerFactory.getLogger(AppShellRegistry.class);
    private Class<? extends AppShellConfigurator> appShellClass;

    private AppShellRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppShellRegistry getInstance(VaadinContext context) {
        VaadinContext vaadinContext = context;
        synchronized (vaadinContext) {
            AppShellRegistryWrapper attribute = context.getAttribute(AppShellRegistryWrapper.class);
            if (attribute == null) {
                attribute = new AppShellRegistryWrapper(new AppShellRegistry());
                context.setAttribute(attribute);
            }
            return attribute.registry;
        }
    }

    public void reset() {
        this.appShellClass = null;
    }

    public void setShell(Class<? extends AppShellConfigurator> shell) {
        if (this.appShellClass != null && shell != null) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_SHELL, this.appShellClass.getName(), shell.getName()));
        }
        if (shell != null && Component.class.isAssignableFrom(shell)) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_EXTENDS_COMPONENT, shell.getName()));
        }
        this.appShellClass = shell;
    }

    public Class<? extends AppShellConfigurator> getShell() {
        return this.appShellClass;
    }

    public String validateClass(Class<?> clz) {
        String offending;
        String error = null;
        List<Class<?>> validOnlyForAppShell = VaadinAppShellInitializer.getValidAnnotations();
        validOnlyForAppShell.remove(PageTitle.class);
        validOnlyForAppShell.remove(StyleSheet.class);
        if (WebComponentExporter.class.isAssignableFrom(clz)) {
            validOnlyForAppShell.remove(Theme.class);
            validOnlyForAppShell.remove(Push.class);
        }
        if (!(offending = AbstractAnnotationValidator.getClassAnnotations(clz, validOnlyForAppShell)).isEmpty()) {
            error = String.format(ERROR_LINE, offending, clz.getName());
        }
        return error;
    }

    private AppShellSettings createSettings(String contextPath) {
        List<PageTitle> pageTitles;
        List<BodySize> bodySizes;
        AppShellSettings settings = new AppShellSettings();
        this.getAnnotations(Meta.class).forEach(meta -> settings.addMetaTag(meta.name(), meta.content()));
        List<Viewport> viewPorts = this.getAnnotations(Viewport.class);
        if (viewPorts.size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, Viewport.class.getSimpleName()));
        }
        if (!viewPorts.isEmpty()) {
            settings.setViewport(viewPorts.get(0).value());
        }
        if ((bodySizes = this.getAnnotations(BodySize.class)).size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, BodySize.class.getSimpleName()));
        }
        if (!bodySizes.isEmpty()) {
            settings.setBodySize(bodySizes.get(0).width(), bodySizes.get(0).height());
        }
        if ((pageTitles = this.getAnnotations(PageTitle.class)).size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, PageTitle.class.getSimpleName()));
        }
        if (!pageTitles.isEmpty()) {
            settings.setPageTitle(pageTitles.get(0).value());
        }
        this.getAnnotations(Inline.class).forEach(settings::addInline);
        LinkedHashSet<String> stylesheets = new LinkedHashSet<String>();
        for (StyleSheet sheet : this.getAnnotations(StyleSheet.class)) {
            String href2 = this.resolveStyleSheetHref(sheet.value(), contextPath);
            if (href2 == null || href2.isBlank()) continue;
            stylesheets.add(href2);
        }
        stylesheets.forEach(href -> settings.addLink("stylesheet", (String)href));
        return settings;
    }

    private String resolveStyleSheetHref(String href, String contextPath) {
        if (href == null || ((String)href).isBlank()) {
            return null;
        }
        String lower = ((String)(href = ((String)href).trim())).toLowerCase();
        if (lower.startsWith("http://") || lower.startsWith("https://")) {
            return href;
        }
        String contextProtocol = "context://";
        if (lower.startsWith(contextProtocol)) {
            Object path = ((String)href).substring(contextProtocol.length());
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (contextPath != null && !contextPath.isEmpty()) {
                return contextPath + (String)path;
            }
            return path;
        }
        if (((String)href).startsWith("./")) {
            href = ((String)href).substring(2);
        }
        Object object = href = ((String)href).startsWith("/") ? href : "/" + (String)href;
        if (HandlerHelper.isPathUnsafe((String)href)) {
            log.warn("@StyleSheet href containing traversals ('../') are not allowed, ignored: " + (String)href);
            return null;
        }
        return href;
    }

    public void modifyIndexHtml(Document document, VaadinRequest request) {
        AppShellSettings settings = this.createSettings(request.getContextPath());
        if (this.appShellClass != null) {
            VaadinService.getCurrent().getInstantiator().getOrCreate(this.appShellClass).configurePage(settings);
        }
        settings.getHeadElements(Inline.Position.PREPEND).forEach(elm -> this.insertElement((Element)elm, arg_0 -> ((Element)document.head()).prependChild(arg_0)));
        settings.getHeadElements(Inline.Position.APPEND).forEach(elm -> this.insertElement((Element)elm, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
        settings.getInlineElements(request.getService(), TargetElement.HEAD, Inline.Position.PREPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.head()).prependChild(arg_0)));
        settings.getInlineElements(request.getService(), TargetElement.HEAD, Inline.Position.APPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.head()).appendChild(arg_0)));
        settings.getInlineElements(request.getService(), TargetElement.BODY, Inline.Position.PREPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.body()).prependChild(arg_0)));
        settings.getInlineElements(request.getService(), TargetElement.BODY, Inline.Position.APPEND).forEach(elm -> this.insertInlineElement((Element)elm, arg_0 -> ((Element)document.body()).appendChild(arg_0)));
    }

    public void modifyPushConfiguration(PushConfiguration pushConfiguration) {
        List<Push> pushAnnotations = this.getAnnotations(Push.class);
        if (pushAnnotations.size() > 1) {
            throw new InvalidApplicationConfigurationException(String.format(ERROR_MULTIPLE_ANNOTATION, Push.class.getSimpleName()));
        }
        if (!pushAnnotations.isEmpty()) {
            Push push = pushAnnotations.get(0);
            pushConfiguration.setPushMode(push.value());
            pushConfiguration.setTransport(push.transport());
        }
    }

    private void insertElement(Element elm, Consumer<Element> action) {
        action.accept(elm);
        for (String cssQuery : UNIQUE_ELEMENTS) {
            if (!elm.is(cssQuery)) continue;
            Element first = elm.parent().selectFirst(cssQuery);
            if (first == elm || first == null) break;
            first.replaceWith((Node)elm);
            break;
        }
    }

    private void insertInlineElement(Element elm, Consumer<Element> action) {
        if (elm instanceof Document) {
            elm.getAllElements().stream().filter(item -> !(item instanceof Document) && elm.equals((Object)item.parent())).forEach(action::accept);
        } else if (elm != null) {
            action.accept(elm);
        }
    }

    public String toString() {
        return "Shell: " + this.appShellClass + " metas: " + this.getAnnotations(Meta.class);
    }

    private <T extends Annotation> List<T> getAnnotations(Class<T> annotation) {
        assert (VaadinAppShellInitializer.getValidAnnotations().contains(annotation));
        return this.appShellClass == null ? Collections.emptyList() : Arrays.asList(this.appShellClass.getAnnotationsByType(annotation));
    }

    public static class AppShellRegistryWrapper
    implements Serializable {
        private final AppShellRegistry registry;

        public AppShellRegistryWrapper(AppShellRegistry registry) {
            this.registry = registry;
        }
    }
}

