/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.server.HttpStatusCode;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LocationChangeEvent
extends EventObject {
    private final UI ui;
    private final NavigationTrigger trigger;
    private final Location location;
    private int statusCode = HttpStatusCode.OK.getCode();
    private NavigationHandler rerouteTarget;
    private List<HasElement> routeTargetChain;

    public LocationChangeEvent(Router router, UI ui, NavigationTrigger trigger, Location location, List<HasElement> routeTargetChain) {
        super(router);
        assert (ui != null);
        assert (trigger != null);
        assert (location != null);
        this.ui = ui;
        this.trigger = trigger;
        this.location = location;
        this.routeTargetChain = Collections.unmodifiableList(routeTargetChain);
    }

    public Location getLocation() {
        return this.location;
    }

    public List<HasElement> getRouteTargetChain() {
        return this.routeTargetChain;
    }

    public UI getUI() {
        return this.ui;
    }

    public NavigationTrigger getTrigger() {
        return this.trigger;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.location.getQueryParameters().getParameters();
    }

    public Optional<String> getQueryParameter(String parameterName) {
        return this.location.getQueryParameters().getParameters().getOrDefault(parameterName, Collections.emptyList()).stream().findFirst();
    }

    @Override
    public Router getSource() {
        return (Router)super.getSource();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Optional<NavigationHandler> getRerouteTarget() {
        return Optional.ofNullable(this.rerouteTarget);
    }

    public void rerouteTo(NavigationHandler rerouteTarget) {
        this.rerouteTarget = rerouteTarget;
    }

    public void rerouteTo(NavigationState rerouteTargetState) {
        Objects.requireNonNull(rerouteTargetState, "rerouteTargetState cannot be null");
        this.rerouteTo(new NavigationStateRenderer(rerouteTargetState));
    }
}

