/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.streams.FileFactory;
import com.vaadin.flow.server.streams.FileUploadCallback;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressAwareHandler;
import com.vaadin.flow.server.streams.TransferUtil;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.server.streams.UploadMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public abstract class AbstractFileUploadHandler<R extends AbstractFileUploadHandler>
extends TransferProgressAwareHandler<UploadEvent, R>
implements UploadHandler {
    private final FileUploadCallback successCallback;
    private final FileFactory fileFactory;

    public AbstractFileUploadHandler(FileUploadCallback successCallback, FileFactory fileFactory) {
        this.successCallback = successCallback;
        this.fileFactory = fileFactory;
    }

    @Override
    public void handleUploadRequest(UploadEvent event) throws IOException {
        File file;
        UploadMetadata metadata = new UploadMetadata(event.getFileName(), event.getContentType(), event.getFileSize());
        try {
            file = this.fileFactory.createFile(metadata);
            try (InputStream inputStream = event.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(file);){
                TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(event), this.getListeners());
            }
        }
        catch (IOException e) {
            this.notifyError(event, e);
            throw e;
        }
        event.getUI().access(() -> {
            try {
                this.successCallback.complete(metadata, file);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error in file upload callback", e);
            }
        });
    }

    @Override
    protected TransferContext getTransferContext(UploadEvent transferEvent) {
        return new TransferContext(transferEvent.getRequest(), transferEvent.getResponse(), transferEvent.getSession(), transferEvent.getFileName(), transferEvent.getOwningElement(), transferEvent.getFileSize());
    }
}

