/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class AbstractDependenciesScanner
implements FrontendDependenciesScanner {
    public static final String LUMO = "com.vaadin.flow.theme.lumo.Lumo";
    protected static final String ERROR_INVALID_LOAD_DEPENDENCIES_ANNOTATION = "There can only be one @" + LoadDependenciesOnStartup.class.getSimpleName() + " annotation and it must be set on the " + AppShellConfigurator.class.getSimpleName() + " implementor.";
    protected static final String ERROR_INVALID_PWA_ANNOTATION = "There can only be one @PWA annotation and it must be set on the " + AppShellConfigurator.class.getSimpleName() + " implementor.";
    private final ClassFinder finder;
    private final FeatureFlags featureFlags;

    protected AbstractDependenciesScanner(ClassFinder finder, FeatureFlags featureFlags) {
        this.finder = finder;
        this.featureFlags = featureFlags;
    }

    protected final ClassFinder getFinder() {
        return this.finder;
    }

    protected final boolean isDisabledExperimentalClass(String className) {
        return this.featureFlags != null && this.featureFlags.getFeatures().stream().anyMatch(f -> !f.isEnabled() && className.equals(f.getComponentClassName()));
    }

    protected Class<? extends AbstractTheme> getLumoTheme() {
        try {
            return this.finder.loadClass(LUMO);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    protected void addValues(Map<String, List<String>> map, String key, List<String> values) {
        List valueList = map.getOrDefault(key, new ArrayList(values.size()));
        valueList.addAll(values);
        map.put(key, valueList);
    }
}

