/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.template.internal.DeprecatedPolymerPublishedEventHandler;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import com.vaadin.flow.server.communication.rpc.DefaultRpcDecoder;
import com.vaadin.flow.server.communication.rpc.RpcDecodeException;
import com.vaadin.flow.server.communication.rpc.RpcDecoder;
import com.vaadin.flow.server.communication.rpc.StringToEnumDecoder;
import com.vaadin.flow.server.communication.rpc.StringToNumberDecoder;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;

public class PublishedServerEventHandlerRpcHandler
extends AbstractRpcInvocationHandler {
    private static final Collection<RpcDecoder> DECODERS = PublishedServerEventHandlerRpcHandler.loadDecoders();

    @Override
    public String getRpcType() {
        return "publishedEventHandler";
    }

    @Override
    protected boolean allowInert(UI ui, JsonNode invocationJson) {
        return true;
    }

    @Override
    public Optional<Runnable> handleNode(StateNode node, JsonNode invocationJson) {
        assert (invocationJson.has("templateEventMethodName"));
        String methodName = invocationJson.get("templateEventMethodName").asText();
        if (methodName == null) {
            throw new IllegalArgumentException("Event handler method name may not be null");
        }
        JsonNode args = invocationJson.get("templateEventMethodArgs");
        if (args == null) {
            args = JacksonUtils.createArrayNode();
        }
        if (args.getNodeType() != JsonNodeType.ARRAY) {
            throw new IllegalArgumentException("Incorrect type for method arguments: " + args.getClass());
        }
        int promiseId = invocationJson.has("promise") ? invocationJson.get("promise").intValue() : -1;
        assert (node.hasFeature(ComponentMapping.class));
        Optional<Component> component = ComponentMapping.getComponent(node);
        if (!component.isPresent()) {
            throw new IllegalStateException("Unable to handle RPC template event JSON message: there is no component available for the target node");
        }
        boolean execute = node.isEnabled();
        if (!execute) {
            ClientCallableHandlers clientDelegate = node.getFeature(ClientCallableHandlers.class);
            PolymerServerEventHandlers eventHandlers = node.getFeature(PolymerServerEventHandlers.class);
            if (clientDelegate.hasHandler(methodName)) {
                execute = DisabledUpdateMode.ALWAYS.equals((Object)clientDelegate.getDisabledUpdateMode(methodName));
            }
            if (eventHandlers.hasHandler(methodName)) {
                boolean bl = execute = execute || DisabledUpdateMode.ALWAYS.equals((Object)eventHandlers.getDisabledUpdateMode(methodName));
            }
        }
        if (execute) {
            PublishedServerEventHandlerRpcHandler.invokeMethod(component.get(), component.get().getClass(), methodName, (ArrayNode)args, promiseId, node.isInert());
        }
        return Optional.empty();
    }

    static void invokeMethod(Component instance, Class<?> clazz, String methodName, ArrayNode args, int promiseId) {
        PublishedServerEventHandlerRpcHandler.invokeMethod(instance, clazz, methodName, args, promiseId, false);
    }

    static void invokeMethod(Component instance, Class<?> clazz, String methodName, ArrayNode args, int promiseId, boolean inert) {
        assert (instance != null);
        Optional<Method> method = PublishedServerEventHandlerRpcHandler.findMethod(instance, clazz, methodName);
        if (method.isPresent()) {
            PublishedServerEventHandlerRpcHandler.invokeMethod(instance, method.get(), args, promiseId, inert);
        } else if (instance instanceof Composite) {
            Object compositeContent = ((Composite)instance).getContent();
            PublishedServerEventHandlerRpcHandler.invokeMethod(compositeContent, compositeContent.getClass(), methodName, args, promiseId, inert);
        } else {
            PublishedServerEventHandlerRpcHandler.getLogger().error(String.format("Faulty method invocation. Neither class '%s' nor its super classes declare event handler method '%s'", instance.getClass().getName(), methodName));
            throw new IllegalStateException("Faulty method invocation. See server log for more details.");
        }
    }

    private static Optional<Method> findMethod(Component instance, Class<?> clazz, String methodName) {
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(method -> methodName.equals(method.getName())).filter(method -> PublishedServerEventHandlerRpcHandler.hasMethodAnnotation(method)).collect(Collectors.toList());
        if (methods.size() > 1) {
            PublishedServerEventHandlerRpcHandler.getLogger().error(String.format("Method conflict in event handler. Class '%s' contains several event handler methods with the same name '%s'", instance.getClass().getName(), methodName));
            throw new IllegalStateException("Method conflict in event handler with multiple methods with same name. See server log for more details.");
        }
        if (methods.size() == 1) {
            return Optional.of((Method)methods.get(0));
        }
        if (!Component.class.equals(clazz)) {
            return PublishedServerEventHandlerRpcHandler.findMethod(instance, clazz.getSuperclass(), methodName);
        }
        return Optional.empty();
    }

    private static boolean hasMethodAnnotation(Method method) {
        boolean hasEventHandler = ReflectTools.hasAnnotation(method, "com.vaadin.flow.component.polymertemplate.EventHandler");
        return hasEventHandler || method.isAnnotationPresent(ClientCallable.class);
    }

    private static void invokeMethod(Component instance, Method method, ArrayNode args, int promiseId, boolean inert) {
        if (inert && !method.isAnnotationPresent(AllowInert.class)) {
            return;
        }
        if (promiseId == -1) {
            PublishedServerEventHandlerRpcHandler.invokeMethod(instance, method, args);
        } else {
            try {
                Serializable returnValue = (Serializable)PublishedServerEventHandlerRpcHandler.invokeMethod(instance, method, args);
                instance.getElement().executeJs("this.$server['}p']($0, true, $1)", Integer.valueOf(promiseId), returnValue);
            }
            catch (RuntimeException e) {
                instance.getElement().executeJs("this.$server['}p']($0, false)", Integer.valueOf(promiseId));
                throw e;
            }
        }
    }

    private static Object invokeMethod(Component instance, Method method, ArrayNode args) {
        try {
            method.setAccessible(true);
            return method.invoke((Object)instance, PublishedServerEventHandlerRpcHandler.decodeArgs(instance, method, args));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LoggerFactory.getLogger((String)PublishedServerEventHandlerRpcHandler.class.getName()).debug(null, (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object[] decodeArgs(Component instance, Method method, ArrayNode argsFromClient) {
        ArrayNode argValues;
        int methodArgs = method.getParameterCount();
        int clientValuesCount = argsFromClient.size();
        if (method.isVarArgs()) {
            if (clientValuesCount < methodArgs - 1) {
                String msg = String.format("The number of received values (%d) is not enough to call the method '%s' declared in '%s' which has vararg parameter and the number of arguments %d", argsFromClient.size(), method.getName(), method.getDeclaringClass().getName(), method.getParameterCount());
                throw new IllegalArgumentException(msg);
            }
            argValues = PublishedServerEventHandlerRpcHandler.unwrapVarArgs(argsFromClient, method);
        } else {
            if (methodArgs != clientValuesCount) {
                String msg = String.format("The number of received values (%d) is not equal to the number of arguments (%d) in the method '%s' declared in '%s'", argsFromClient.size(), method.getParameterCount(), method.getName(), method.getDeclaringClass().getName());
                throw new IllegalArgumentException(msg);
            }
            argValues = argsFromClient;
        }
        ArrayList<Object> decoded = new ArrayList<Object>(method.getParameterCount());
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < argValues.size()) {
            Class<?> type = methodParameterTypes[i];
            decoded.add(PublishedServerEventHandlerRpcHandler.decodeArg(instance, method, type, i, argValues.get(i)));
            ++i;
        }
        return decoded.toArray(new Object[method.getParameterCount()]);
    }

    private static ArrayNode unwrapVarArgs(ArrayNode argsFromClient, Method method) {
        int paramCount = method.getParameterCount();
        if (argsFromClient.size() == paramCount && argsFromClient.get(paramCount - 1).getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            return argsFromClient;
        }
        ArrayNode result = JacksonUtils.createArrayNode();
        ArrayNode rest = JacksonUtils.createArrayNode();
        for (int i = 0; i < argsFromClient.size(); ++i) {
            JsonNode value = argsFromClient.get(i);
            if (i < paramCount - 1) {
                result.add(value);
                continue;
            }
            rest.add(value);
        }
        result.add((JsonNode)rest);
        return result;
    }

    private static Object decodeArg(Component instance, Method method, Class<?> type, int index, JsonNode argValue) {
        Optional<RpcDecoder> decoder;
        assert (argValue != null);
        if (type.isPrimitive() && argValue.getNodeType() == JsonNodeType.NULL) {
            return JacksonCodec.decodeAs(argValue, type);
        }
        if (type.isArray()) {
            return PublishedServerEventHandlerRpcHandler.decodeArray(method, type, index, argValue);
        }
        Class<?> convertedType = ReflectTools.convertPrimitiveType(type);
        if (instance != null) {
            Optional<UI> ui = instance.getUI();
            if (!ui.isPresent()) {
                throw new IllegalStateException("Rpc handler may not be called for a detached component");
            }
            VaadinContext context = ui.get().getSession().getService().getContext();
            DeprecatedPolymerPublishedEventHandler handler = context.getAttribute(Lookup.class).lookup(DeprecatedPolymerPublishedEventHandler.class);
            if (handler != null && handler.isTemplateModelValue(instance, argValue, convertedType)) {
                return handler.getTemplateItem(instance, argValue, method.getGenericParameterTypes()[index]);
            }
        }
        if ((decoder = PublishedServerEventHandlerRpcHandler.getDecoder(argValue, convertedType)).isPresent()) {
            try {
                return decoder.get().decode(argValue, convertedType);
            }
            catch (RpcDecodeException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        String msg = String.format("Class '%s' has the method '%s' whose parameter %d refers to unsupported type '%s'", method.getDeclaringClass().getName(), method.getName(), index, type.getName());
        throw new IllegalArgumentException(msg);
    }

    private static Optional<RpcDecoder> getDecoder(JsonNode value, Class<?> type) {
        return DECODERS.stream().filter(decoder -> decoder.isApplicable(value, type)).findFirst();
    }

    private static Object decodeArray(Method method, Class<?> type, int index, JsonNode argValue) {
        if (argValue.getNodeType() != JsonNodeType.ARRAY) {
            String msg = String.format("Class '%s' has the method '%s' whose parameter %d refers to the array type '%s' but received value is not an array, its type is '%s'", method.getDeclaringClass().getName(), method.getName(), index, type.getName(), argValue.getNodeType().name());
            throw new IllegalArgumentException(msg);
        }
        Class<?> componentType = type.getComponentType();
        ArrayNode array = (ArrayNode)argValue;
        Object result = Array.newInstance(componentType, array.size());
        for (int i = 0; i < array.size(); ++i) {
            Array.set(result, i, PublishedServerEventHandlerRpcHandler.decodeArg(null, method, componentType, index, array.get(i)));
        }
        return result;
    }

    private static Collection<RpcDecoder> loadDecoders() {
        ArrayList<RpcDecoder> decoders = new ArrayList<RpcDecoder>();
        decoders.add(new StringToNumberDecoder());
        decoders.add(new StringToEnumDecoder());
        decoders.add(new DefaultRpcDecoder());
        return decoders;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)PublishedServerEventHandlerRpcHandler.class.getName());
    }
}

