/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;

public class HeartbeatHandler
extends SynchronizedRequestHandler
implements SessionExpiredHandler {
    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.HEARTBEAT);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        UI ui = session.getService().findUI(request);
        if (ui != null) {
            ui.getInternals().setLastHeartbeatTimestamp(System.currentTimeMillis());
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Content-Type", "text/plain");
        } else {
            response.sendError(HttpStatusCode.NOT_FOUND.getCode(), "UI not found");
        }
        return true;
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.HEARTBEAT)) {
            return false;
        }
        response.sendError(HttpStatusCode.FORBIDDEN.getCode(), "Session expired");
        return true;
    }
}

