/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Optional;

public abstract class SynchronizedRequestHandler
implements RequestHandler {
    public static final int MAX_BUFFER_SIZE = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (!this.canHandleRequest(request)) {
            return false;
        }
        try {
            if (this.isReadAndWriteOutsideSessionLock()) {
                BufferedReader reader = request.getReader();
                String requestBody = reader == null ? null : SynchronizedRequestHandler.getRequestBody(reader);
                session.lock();
                Optional<ResponseWriter> responseWriter = this.synchronizedHandleRequest(session, request, response, requestBody);
                session.unlock();
                if (responseWriter.isPresent()) {
                    responseWriter.get().writeResponse();
                }
                boolean bl = responseWriter.isPresent();
                return bl;
            }
            session.lock();
            boolean bl = this.synchronizedHandleRequest(session, request, response);
            return bl;
        }
        finally {
            if (session.hasLock()) {
                session.unlock();
            }
        }
    }

    public abstract boolean synchronizedHandleRequest(VaadinSession var1, VaadinRequest var2, VaadinResponse var3) throws IOException;

    public boolean isReadAndWriteOutsideSessionLock() {
        return false;
    }

    public Optional<ResponseWriter> synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, String requestBody) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected boolean canHandleRequest(VaadinRequest request) {
        return true;
    }

    public static String getRequestBody(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder(65536);
        char[] buffer = new char[65536];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        return sb.toString();
    }

    @FunctionalInterface
    public static interface ResponseWriter
    extends Serializable {
        public void writeResponse() throws IOException;
    }
}

