/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.i18n.I18NProvider;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultI18NProvider
implements I18NProvider {
    final List<Locale> providedLocales;
    private final ClassLoader classLoader;
    public static final String BUNDLE_FOLDER = "vaadin-i18n";
    public static final String BUNDLE_FILENAME = "translations";
    public static final String BUNDLE_PREFIX = "vaadin-i18n.translations";

    public DefaultI18NProvider(List<Locale> providedLocales) {
        this(providedLocales, DefaultI18NProvider.class.getClassLoader());
    }

    public DefaultI18NProvider(List<Locale> providedLocales, ClassLoader classLoader) {
        this.providedLocales = Collections.unmodifiableList(providedLocales);
        this.classLoader = classLoader;
    }

    @Override
    public List<Locale> getProvidedLocales() {
        return this.providedLocales;
    }

    @Override
    public String getTranslation(String key, Locale locale, Object ... params) {
        String value;
        if (key == null) {
            DefaultI18NProvider.getLogger().warn("Got lang request for key with null value!");
            return "";
        }
        ResourceBundle bundle = this.getBundle(locale);
        if (bundle == null) {
            return key;
        }
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            DefaultI18NProvider.getLogger().debug("Missing resource for key " + key, (Throwable)e);
            return "!" + locale.getLanguage() + ": " + key;
        }
        if (params.length > 0) {
            value = new MessageFormat(value, locale).format(params);
        }
        return value;
    }

    @Override
    public Map<String, String> getAllTranslations(Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        return bundle == null ? Map.of() : this.getTranslations(bundle.keySet(), locale);
    }

    ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(BUNDLE_PREFIX, locale, this.classLoader);
        }
        catch (MissingResourceException e) {
            DefaultI18NProvider.getLogger().warn("Missing resource bundle for vaadin-i18n.translations and locale " + locale.getDisplayName(), (Throwable)e);
            return null;
        }
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(DefaultI18NProvider.class);
    }
}

