/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ThemeList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ThemeListImpl
implements ThemeList,
Serializable {
    public static final String THEME_ATTRIBUTE_NAME = "theme";
    private static final String THEME_NAMES_DELIMITER = " ";
    private final Element element;
    private final Set<String> themes;

    public ThemeListImpl(Element element) {
        this.element = element;
        this.themes = Optional.ofNullable(element.getAttribute(THEME_ATTRIBUTE_NAME)).map(value -> value.split(THEME_NAMES_DELIMITER)).map(Stream::of).map(stream -> stream.filter(themeName -> !themeName.isEmpty()).collect(Collectors.toSet())).orElseGet(HashSet::new);
    }

    @Override
    public Iterator<String> iterator() {
        return new ThemeListIterator();
    }

    @Override
    public boolean add(String themeName) {
        boolean changed = this.themes.add(themeName);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends String> themeNames) {
        boolean changed = this.themes.addAll(themeNames);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean remove(Object themeName) {
        boolean changed = this.themes.remove(themeName);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> themeNamesToRetain) {
        boolean changed = this.themes.retainAll(themeNamesToRetain);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> themeNamesToRemove) {
        boolean changed = this.themes.removeAll(themeNamesToRemove);
        if (changed) {
            this.updateThemeAttribute();
        }
        return changed;
    }

    @Override
    public void clear() {
        this.themes.clear();
        this.updateThemeAttribute();
    }

    private void updateThemeAttribute() {
        if (this.themes.isEmpty()) {
            this.element.removeAttribute(THEME_ATTRIBUTE_NAME);
        } else {
            this.element.setAttribute(THEME_ATTRIBUTE_NAME, this.themes.stream().collect(Collectors.joining(THEME_NAMES_DELIMITER)));
        }
    }

    @Override
    public int size() {
        return this.themes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.themes.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.themes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.themes.toArray(a);
    }

    @Override
    public boolean contains(Object themeName) {
        return this.themes.contains(themeName);
    }

    @Override
    public boolean containsAll(Collection<?> themeNames) {
        return this.themes.containsAll(themeNames);
    }

    public String toString() {
        return this.themes.toString();
    }

    private final class ThemeListIterator
    implements Iterator<String> {
        private final Iterator<String> wrappedIterator;

        private ThemeListIterator() {
            this.wrappedIterator = ThemeListImpl.this.themes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public String next() {
            return this.wrappedIterator.next();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
            ThemeListImpl.this.updateThemeAttribute();
        }
    }
}

